/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.extensions.IForgeDimensionSpecialEffects;
import org.joml.Matrix4f;
import zarkov.utilityworlds.config.UW_Config;

@OnlyIn(value=Dist.CLIENT)
public class UW_DimensionEffects
extends DimensionSpecialEffects
implements IForgeDimensionSpecialEffects {
    static final Vec3 fogColor = new Vec3(0.46875, 0.65234375, 1.0);
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");

    public UW_DimensionEffects(float cloudLevel, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(cloudLevel, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
    }

    public Vec3 m_5927_(Vec3 p_108908_, float p_108909_) {
        return fogColor;
    }

    public boolean m_5781_(int p_108874_, int p_108875_) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (((Boolean)UW_Config.DARK_VOID_WORLD.get()).booleanValue() && level.m_46472_().m_135782_().m_135815_().startsWith("uw_void")) {
            return false;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
        Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
        float sunWidth = 30.0f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_LOCATION);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -sunWidth, 100.0f, -sunWidth).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, sunWidth, 100.0f, -sunWidth).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, sunWidth, 100.0f, sunWidth).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -sunWidth, 100.0f, sunWidth).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        poseStack.m_85849_();
        RenderSystem.m_69458_((boolean)true);
        return true;
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        return true;
    }

    public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        UW_DimensionEffects clearSkyEffect = new UW_DimensionEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.END, false, false);
        event.register(new ResourceLocation("utilityworlds", "uw_mining"), (DimensionSpecialEffects)clearSkyEffect);
        event.register(new ResourceLocation("utilityworlds", "uw_void"), (DimensionSpecialEffects)clearSkyEffect);
        event.register(new ResourceLocation("utilityworlds", "uw_garden"), (DimensionSpecialEffects)clearSkyEffect);
    }
}

