/*
 * Decompiled with CFR 0.152.
 */
package com.github.channelingmc.visuality.config.entity;

import com.github.channelingmc.visuality.Visuality;
import com.github.channelingmc.visuality.config.ReloadableJsonConfig;
import com.github.channelingmc.visuality.data.Particle;
import com.github.channelingmc.visuality.data.VisualityCodecs;
import com.github.channelingmc.visuality.particle.type.ColorParticleType;
import com.github.channelingmc.visuality.particle.type.VisualityParticleTypes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntityArmorParticles
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int interval = 20;
    private List<Entry> entries;
    private final IdentityHashMap<Item, Particle> particles = new IdentityHashMap();

    public EntityArmorParticles() {
        super(Visuality.loc("particle_emitters/entity/armor"));
        this.entries = EntityArmorParticles.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (Item armor : entry.armors) {
                this.particles.put(armor, entry.particle);
            }
        }
        MinecraftForge.EVENT_BUS.addListener(this::spawnParticles);
    }

    public void spawnParticles(LivingEvent.LivingUpdateEvent event) {
        RenderLayerParent parent;
        if (!this.enabled) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (!level.f_46443_ || !entity.m_6084_()) {
            return;
        }
        Random random = entity.m_21187_();
        if (random.nextInt(this.interval) != 0) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderer renderer = minecraft.m_91290_().m_114382_((Entity)entity);
        if (!(renderer instanceof RenderLayerParent) || !((parent = (RenderLayerParent)renderer).m_7200_() instanceof HumanoidModel)) {
            return;
        }
        if (minecraft.f_91075_ == entity && minecraft.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        double height = random.nextDouble();
        EquipmentSlot slot = this.switchEquipmentSlotFromHeight(height);
        Item armor = entity.m_6844_(slot).m_41720_();
        if (this.particles.containsKey(armor)) {
            AABB aabb = entity.m_142469_();
            double radian = Math.PI * 2 * random.nextDouble();
            double x = Mth.m_14139_((double)(0.5 + 0.75 * Math.cos(radian)), (double)aabb.f_82288_, (double)aabb.f_82291_);
            double y = Mth.m_14139_((double)height, (double)aabb.f_82289_, (double)aabb.f_82292_);
            double z = Mth.m_14139_((double)(0.5 + 0.75 * Math.sin(radian)), (double)aabb.f_82290_, (double)aabb.f_82293_);
            this.particles.get(armor).spawn(level, x, y, z);
        }
    }

    private EquipmentSlot switchEquipmentSlotFromHeight(double height) {
        if (height < 0.1875) {
            return EquipmentSlot.FEET;
        }
        if (height < 0.5) {
            return EquipmentSlot.LEGS;
        }
        if (height < 0.8125) {
            return EquipmentSlot.CHEST;
        }
        return EquipmentSlot.HEAD;
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.m_6180_(source);
        if (config) {
            this.enabled = GsonHelper.m_13855_((JsonObject)input, (String)"enabled", (boolean)true);
            this.interval = GsonHelper.m_13824_((JsonObject)input, (String)"interval", (int)20);
        }
        if ((array = GsonHelper.m_13832_((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.m_7238_();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.PartialResult)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (Item armor : entry.armors) {
                this.particles.put(armor, entry.particle);
            }
        }
        profiler.m_7238_();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("interval", (Number)this.interval);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(true, msg -> this.logger.error("Failed to serialize config entries: {}", msg)));
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        ColorParticleType.Options gold = ((ColorParticleType)((Object)VisualityParticleTypes.SPARKLE.get())).withColor(16711613);
        entries.add(Entry.of(List.of(Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_), gold));
        ColorParticleType.Options diamond = ((ColorParticleType)((Object)VisualityParticleTypes.SPARKLE.get())).withColor(11861486);
        entries.add(Entry.of(List.of(Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_), diamond));
        return entries;
    }

    private record Entry(List<Item> armors, Particle particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compactListOf(ForgeRegistries.ITEMS.getCodec()).fieldOf("armor").forGetter(Entry::armors), (App)Particle.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(List<Item> armors, ParticleOptions particle) {
            return new Entry(armors, Particle.ofZeroVelocity(particle));
        }
    }
}

