/*
 * Decompiled with CFR 0.152.
 */
package com.github.channelingmc.visuality.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraftforge.registries.ForgeRegistries;

public class CompactParticleCodec
implements Codec<ParticleOptions> {
    private static final Codec<ParticleType<?>> PARTICLE_TYPE_CODEC = ForgeRegistries.PARTICLE_TYPES.getCodec();

    CompactParticleCodec() {
    }

    public <T> DataResult<Pair<ParticleOptions, T>> decode(DynamicOps<T> ops, T input) {
        if (ops instanceof NbtOps) {
            return ParticleTypes.f_123791_.decode(ops, input);
        }
        return (DataResult)PARTICLE_TYPE_CODEC.parse(ops, input).flatMap(type -> {
            DataResult dataResult;
            if (type instanceof ParticleOptions) {
                ParticleOptions particle = (ParticleOptions)type;
                dataResult = DataResult.success((Object)particle);
            } else {
                dataResult = DataResult.error((String)(ops.getStringValue(input) + " is not a ParticleOption!"));
            }
            return dataResult;
        }).get().map(particle -> DataResult.success((Object)Pair.of((Object)particle, (Object)input)), partial -> ParticleTypes.f_123791_.decode(ops, input));
    }

    public <T> DataResult<T> encode(ParticleOptions input, DynamicOps<T> ops, T prefix) {
        DataResult dataResult;
        if (ops instanceof NbtOps) {
            return ParticleTypes.f_123791_.encode((Object)input, ops, prefix);
        }
        if (input instanceof ParticleType) {
            ParticleType type = (ParticleType)input;
            dataResult = PARTICLE_TYPE_CODEC.encode((Object)type, ops, prefix);
        } else {
            dataResult = ParticleTypes.f_123791_.encode((Object)input, ops, prefix);
        }
        return dataResult;
    }
}

