/*
 * Decompiled with CFR 0.152.
 */
package net.poonggi.somebosses.entity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.poonggi.somebosses.entity.SandGiantEntity;
import net.poonggi.somebosses.init.SomebossesModEntities;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SkeletonVanguardEntity
extends Monster
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(SandGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int despawn;
    public String animationprocedure = "empty";

    public SkeletonVanguardEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SkeletonVanguardEntity>)((EntityType)SomebossesModEntities.SKELETON_VANGUARD.get()), world);
    }

    public SkeletonVanguardEntity(EntityType<SkeletonVanguardEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK, (Object)false);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setAttack(boolean attack) {
        this.f_19804_.m_135381_(ATTACK, (Object)attack);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BasicAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither_skeleton.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither_skeleton.death"));
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.1);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        return builder;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getAttack()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_vanguard.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_vanguard.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_vanguard.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public int maxSwingTime() {
        int i = 25;
        return i;
    }

    protected void m_21203_() {
        int i = this.maxSwingTime();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public boolean m_7327_(Entity entity) {
        return false;
    }

    public boolean defaultAttack(Entity entity) {
        return super.m_7327_(entity);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void m_6075_() {
        super.m_6075_();
        SkeletonVanguardEntity entity = this;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double random = Math.random();
        Level world = this.f_19853_;
        ++this.despawn;
        if (this.despawn >= 160) {
            if (!((Entity)entity).f_19853_.m_5776_()) {
                entity.m_146870_();
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 40, 0.5, 1.0, 0.5, 0.0);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class BasicAttackGoal
    extends Goal {
        final SkeletonVanguardEntity mob;
        int attackprogress;

        public BasicAttackGoal(SkeletonVanguardEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.f_20911_;
        }

        public void m_8056_() {
            this.mob.setAttack(true);
            this.attackprogress = 0;
        }

        public void m_8041_() {
            this.mob.setAttack(false);
        }

        public void m_8037_() {
            if (this.mob.f_20921_ > 0.5f && this.attackprogress == 0) {
                ++this.attackprogress;
                Vec3 _center = new Vec3(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
                List _entfound = this.mob.f_19853_.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(3.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
                for (Entity entityiterator : _entfound) {
                    if (entityiterator == this.mob || entityiterator != this.mob.m_5448_()) continue;
                    entityiterator.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                }
            }
        }
    }
}

