/*
 * Decompiled with CFR 0.152.
 */
package net.poonggi.somebosses.entity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.poonggi.somebosses.entity.ScreenShakeEntity;
import net.poonggi.somebosses.entity.StoneEggEntity;
import net.poonggi.somebosses.entity.StoneMinionEntity;
import net.poonggi.somebosses.entity.StoneShootEntity;
import net.poonggi.somebosses.init.SomebossesModEntities;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class StoneGuardEntity
extends Monster
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(StoneGuardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(StoneGuardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SKILLING = SynchedEntityData.m_135353_(StoneGuardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(StoneGuardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int skill;
    private int skill2;
    public String animationprocedure = "empty";
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);

    public StoneGuardEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<StoneGuardEntity>)((EntityType)SomebossesModEntities.STONE_GUARD.get()), world);
    }

    public StoneGuardEntity(EntityType<StoneGuardEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BasicAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 30.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(SKILLING, (Object)false);
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
    }

    public void setAttackState(int value) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)value);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setAttack(boolean attack) {
        this.f_19804_.m_135381_(ATTACK, (Object)attack);
    }

    public void setSkilling(boolean skilling) {
        this.f_19804_.m_135381_(SKILLING, (Object)skilling);
    }

    public boolean getSkilling() {
        return (Boolean)this.f_19804_.m_135370_(SKILLING);
    }

    public boolean getShooting() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.f_19804_.m_135381_(SHOOTING, (Object)shooting);
    }

    public int maxSwingTime() {
        int i = 45;
        return i;
    }

    protected void m_21203_() {
        int i = this.maxSwingTime();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public boolean m_7327_(Entity entity) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 300.0);
        builder = builder.m_22268_(Attributes.f_22284_, 9.0);
        builder = builder.m_22268_(Attributes.f_22285_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 15.0);
        builder = builder.m_22268_(Attributes.f_22277_, 60.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.0);
        return builder;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.stone_guard.dead", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getSkilling()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.stone_guard.skill", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getShooting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.stone_guard.skill2", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getAttack() && this.getAttackState() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.stone_guard.attack1", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getAttack() && this.getAttackState() == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.stone_guard.attack2", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.stone_guard.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 48) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_20334_(0.0, 0.0, 0.0);
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            StoneGuardEntity entity = this;
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            double d0 = target.m_20227_(0.5) - this.m_20227_(0.5);
            double d1 = target.m_20185_() - entity.m_20185_();
            double d3 = target.m_20189_() - entity.m_20189_();
            double random = Math.random();
            Level world = this.f_19853_;
            this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (!this.getShooting()) {
                ++this.skill;
            }
            if (!this.getSkilling()) {
                ++this.skill2;
            }
            if (this.skill2 == 167) {
                this.setShooting(true);
            }
            if (this.skill2 == 206) {
                if (world instanceof Level) {
                    Level _level = world;
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, new BlockPos(x, y, z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither.break_block")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                    } else {
                        _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither.break_block")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                    }
                }
                StoneGuardEntity _shootFrom = entity;
                Level projectileLevel = ((Entity)_shootFrom).f_19853_;
                if (!projectileLevel.m_5776_()) {
                    Projectile _entityToSpawn = new Object(){

                        public Projectile getArrow(Level level, Entity shooter, float damage, int knockback) {
                            StoneShootEntity entityToSpawn = new StoneShootEntity((EntityType<? extends StoneShootEntity>)((EntityType)SomebossesModEntities.STONE_SHOOT.get()), level);
                            entityToSpawn.m_5602_(shooter);
                            entityToSpawn.m_36781_(damage);
                            entityToSpawn.m_36735_(knockback);
                            entityToSpawn.m_20225_(true);
                            return entityToSpawn;
                        }
                    }.getArrow(projectileLevel, (Entity)entity, 4.0f, 0);
                    _entityToSpawn.m_6034_(_shootFrom.m_20185_(), _shootFrom.m_20188_() - 0.1, _shootFrom.m_20189_());
                    _entityToSpawn.m_6686_(d1, d0, d3, 2.0f, 0.0f);
                    projectileLevel.m_7967_((Entity)_entityToSpawn);
                }
            }
            if (this.skill2 >= 213) {
                this.setShooting(false);
                this.skill2 = 0;
            }
            if (this.skill == 113) {
                this.setSkilling(true);
            }
            if (this.skill == 144) {
                Vec3 _center = new Vec3(x, y, z);
                List _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(10.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
                for (Entity entityiterator : _entfound) {
                    if (entityiterator == entity || entityiterator instanceof StoneMinionEntity) continue;
                    entityiterator.m_6469_(DamageSource.m_19370_((LivingEntity)this), 10.0f);
                    entityiterator.m_20256_(new Vec3(0.0, 1.0, 0.0));
                }
                for (int index0 = 0; index0 < 2; ++index0) {
                    if (!(world instanceof ServerLevel)) continue;
                    ServerLevel _level = (ServerLevel)world;
                    StoneEggEntity entityToSpawn = new StoneEggEntity((EntityType<StoneEggEntity>)((EntityType)SomebossesModEntities.STONE_EGG.get()), (Level)_level);
                    entityToSpawn.m_7678_(x + Math.random() * 10.0 - 5.0, y, z + Math.random() * 10.0 - 5.0, 0.0f, 0.0f);
                    ((Mob)entityToSpawn).m_6710_(target);
                    entityToSpawn.m_5618_(0.0f);
                    entityToSpawn.m_5616_(0.0f);
                    entityToSpawn.m_20334_(0.0, 0.0, 0.0);
                    if (entityToSpawn instanceof Mob) {
                        Mob _mobToSpawn = (Mob)entityToSpawn;
                        _mobToSpawn.m_6518_((ServerLevelAccessor)_level, world.m_6436_(entityToSpawn.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    }
                    world.m_7967_((Entity)entityToSpawn);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 50, 10.0, 0.0, 10.0, 0.0);
                }
                if (world instanceof Level) {
                    Level _level = world;
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, new BlockPos(x, y, z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                    } else {
                        _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                    }
                }
                ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 20.0f, 0.4f, 0, 20);
            }
            if (this.skill >= 160) {
                this.setSkilling(false);
                this.skill = 0;
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class BasicAttackGoal
    extends Goal {
        final StoneGuardEntity mob;
        int attackprogress;

        public BasicAttackGoal(StoneGuardEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.f_20911_;
        }

        public void m_8056_() {
            if (Math.random() > 0.5) {
                this.mob.setAttack(true);
                this.mob.setAttackState(0);
            } else {
                this.mob.setAttack(true);
                this.mob.setAttackState(1);
            }
            this.attackprogress = 0;
        }

        public void m_8041_() {
            this.mob.setAttack(false);
        }

        public void m_8037_() {
            if (this.mob.f_20921_ > 0.6f && this.attackprogress == 0) {
                ++this.attackprogress;
                Vec3 _center = new Vec3(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
                List _entfound = this.mob.f_19853_.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(4.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
                for (Entity entityiterator : _entfound) {
                    if (entityiterator == this.mob || entityiterator != this.mob.m_5448_()) continue;
                    entityiterator.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                    if (!this.mob.f_19853_.m_5776_()) {
                        this.mob.f_19853_.m_5594_(null, new BlockPos(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.dragon_fireball.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                        continue;
                    }
                    this.mob.f_19853_.m_7785_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.dragon_fireball.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                }
            }
        }
    }
}

