/*
 * Decompiled with CFR 0.152.
 */
package net.poonggi.somebosses.entity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.poonggi.somebosses.entity.EnderOrdnanceEntity;
import net.poonggi.somebosses.entity.LavaballEntity;
import net.poonggi.somebosses.entity.ScreenShakeEntity;
import net.poonggi.somebosses.init.SomebossesModEntities;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class VolcaniumEntity
extends Monster
implements IAnimatable {
    private static final EntityDataAccessor<Integer> SKILL = SynchedEntityData.m_135353_(EnderOrdnanceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(VolcaniumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SKILLING = SynchedEntityData.m_135353_(EnderOrdnanceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(EnderOrdnanceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHOOT = SynchedEntityData.m_135353_(EnderOrdnanceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6);

    public VolcaniumEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<VolcaniumEntity>)((EntityType)SomebossesModEntities.VOLCANIUM.get()), world);
    }

    public VolcaniumEntity(EntityType<VolcaniumEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(SKILL, (Object)0);
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
        this.f_19804_.m_135372_(SKILLING, (Object)false);
        this.f_19804_.m_135372_(SHOOT, (Object)0);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setAttack(boolean attack) {
        this.f_19804_.m_135381_(ATTACK, (Object)attack);
    }

    public int getSkill() {
        return (Integer)this.f_19804_.m_135370_(SKILL);
    }

    public void setSkill(int skill) {
        this.f_19804_.m_135381_(SKILL, (Object)skill);
    }

    public boolean getShooting() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.f_19804_.m_135381_(SHOOTING, (Object)shooting);
    }

    public boolean getSkilling() {
        return (Boolean)this.f_19804_.m_135370_(SKILLING);
    }

    public void setSkilling(boolean skilling) {
        this.f_19804_.m_135381_(SKILLING, (Object)skilling);
    }

    public int getShoot() {
        return (Integer)this.f_19804_.m_135370_(SHOOT);
    }

    public void setShoot(int shoot) {
        this.f_19804_.m_135381_(SHOOT, (Object)shoot);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int maxSwingTime() {
        int i = 17;
        return i;
    }

    protected void m_21203_() {
        int i = this.maxSwingTime();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BasicAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            public boolean m_8036_() {
                return super.m_8036_() && !this.f_25540_.f_20911_;
            }

            protected double m_6639_(LivingEntity entity) {
                return 7.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.stone.break"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.blaze.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entity) {
        return false;
    }

    public boolean defaultAttack(Entity entity) {
        return super.m_7327_(entity);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 380.0);
        builder = builder.m_22268_(Attributes.f_22284_, 13.0);
        builder = builder.m_22268_(Attributes.f_22285_, 6.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 100.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 3.0);
        return builder;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.volcanium.dead", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getAttack()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.volcanium.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.volcanium.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.volcanium.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double random = Math.random();
        VolcaniumEntity entity = this;
        Level world = this.f_19853_;
        if (this.getShooting()) {
            ServerLevel _level;
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 20, 1.0, 1.0, 1.0, 0.0);
            }
            Vec3 _center = new Vec3(x, y, z);
            List _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
            for (Entity entityiterator : _entfound) {
                if (entityiterator == entity || entity.m_7307_(entityiterator)) continue;
                entityiterator.m_6469_(DamageSource.m_19373_((LivingEntity)this), 5.0f);
                entityiterator.m_20334_((entityiterator.m_20185_() - x) / 2.0, 0.5, (entityiterator.m_20189_() - z) / 2.0);
            }
            if (world instanceof Level) {
                _level = world;
                if (!_level.m_5776_()) {
                    _level.m_5594_(null, new BlockPos(x, y, z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                } else {
                    _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                }
            }
            this.setShoot(0);
            this.setShooting(false);
            ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 20.0f, 0.4f, 0, 20);
        }
        return super.m_142535_(l, d, source);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 23) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_6075_() {
        super.m_6075_();
        LivingEntity target = this.m_5448_();
        VolcaniumEntity entity = this;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double random = Math.random();
        Level world = this.f_19853_;
        if (this.m_5448_() != null) {
            Projectile _entityToSpawn;
            Level projectileLevel;
            VolcaniumEntity _shootFrom;
            LivingEntity _entity;
            VolcaniumEntity _ent;
            ServerLevel _level;
            double d0 = target.m_20227_(0.5) - this.m_20227_(0.5);
            double d1 = target.m_20185_() - entity.m_20185_();
            double d3 = target.m_20189_() - entity.m_20189_();
            double d2 = target.m_20227_(1.0) - this.m_20227_(0.1);
            this.setSkill(this.getSkill() + 1);
            this.setShoot(this.getShoot() + 1);
            if (this.getShoot() == 251) {
                this.setShooting(true);
                entity.m_20256_(new Vec3(entity.m_20184_().m_7096_(), 2.0, entity.m_20184_().m_7094_()));
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 20, 1.0, 1.0, 1.0, 0.0);
                }
                Vec3 _center = new Vec3(x, y, z);
                List _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
                for (Entity entityiterator : _entfound) {
                    if (entityiterator == entity || entity.m_7307_(entityiterator)) continue;
                    entityiterator.m_6469_(DamageSource.m_19373_((LivingEntity)this), 5.0f);
                }
                if (world instanceof Level) {
                    _level = world;
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, new BlockPos(x, y, z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                    } else {
                        _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                    }
                }
            }
            if (this.getSkill() >= 447) {
                this.setSkilling(false);
                this.setSkill(0);
            }
            if (this.getSkill() == 307) {
                this.setSkilling(true);
            }
            if (!this.getSkilling() && Math.random() <= 0.04) {
                if (world instanceof Level) {
                    _level = world;
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, new BlockPos(x, y, z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.blaze.hurt")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                    } else {
                        _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.blaze.hurt")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                    }
                }
                for (int index1 = 0; index1 < 5; ++index1) {
                    _ent = entity;
                    _ent.m_146922_((float)(Math.random() * 360.0));
                    _ent.m_146926_((float)(Math.random() * 180.0 + 90.0));
                    _ent.m_5618_(_ent.m_146908_());
                    _ent.m_5616_(_ent.m_146908_());
                    ((Entity)_ent).f_19859_ = _ent.m_146908_();
                    ((Entity)_ent).f_19860_ = _ent.m_146909_();
                    if (_ent instanceof LivingEntity) {
                        _entity = (LivingEntity)_ent;
                        _entity.f_20884_ = _entity.m_146908_();
                        _entity.f_20886_ = _entity.m_146908_();
                    }
                    _shootFrom = entity;
                    projectileLevel = ((Entity)_shootFrom).f_19853_;
                    if (projectileLevel.m_5776_()) continue;
                    _entityToSpawn = new Object(){

                        public Projectile getArrow(Level level, Entity shooter, float damage, int knockback, byte piercing) {
                            LavaballEntity entityToSpawn = new LavaballEntity((EntityType<? extends LavaballEntity>)((EntityType)SomebossesModEntities.LAVABALL.get()), level);
                            entityToSpawn.m_5602_(shooter);
                            entityToSpawn.m_36781_(damage);
                            entityToSpawn.m_36735_(knockback);
                            entityToSpawn.m_20225_(true);
                            entityToSpawn.m_36767_(piercing);
                            return entityToSpawn;
                        }
                    }.getArrow(projectileLevel, (Entity)entity, 2.0f, 0, (byte)100);
                    _entityToSpawn.m_6034_(_shootFrom.m_20185_(), _shootFrom.m_20188_() - 0.1, _shootFrom.m_20189_());
                    _entityToSpawn.m_6686_(_shootFrom.m_20154_().f_82479_, _shootFrom.m_20154_().f_82480_, _shootFrom.m_20154_().f_82481_, (float)(Math.random() / 1.5), 0.0f);
                    projectileLevel.m_7967_((Entity)_entityToSpawn);
                }
            }
            if (this.getSkilling()) {
                if (world instanceof ServerLevel) {
                    ServerLevel _level2 = (ServerLevel)world;
                    _level2.m_8767_((ParticleOptions)ParticleTypes.f_123792_, x, y + 2.0, z, 10, 1.0, 0.0, 1.0, 0.0);
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity _entity2 = (LivingEntity)entity;
                    _entity2.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1, 2, false, false));
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity _entity3 = (LivingEntity)entity;
                    _entity3.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1, 2, false, false));
                }
                if (Math.random() <= 0.07) {
                    if (world instanceof Level) {
                        Level _level3 = world;
                        if (!_level3.m_5776_()) {
                            _level3.m_5594_(null, new BlockPos(x, y, z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.blaze.hurt")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                        } else {
                            _level3.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.blaze.hurt")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                        }
                    }
                    for (int index1 = 0; index1 < 5; ++index1) {
                        _ent = entity;
                        _ent.m_146922_((float)(Math.random() * 360.0));
                        _ent.m_146926_((float)(Math.random() * 180.0 + 90.0));
                        _ent.m_5618_(_ent.m_146908_());
                        _ent.m_5616_(_ent.m_146908_());
                        ((Entity)_ent).f_19859_ = _ent.m_146908_();
                        ((Entity)_ent).f_19860_ = _ent.m_146909_();
                        if (_ent instanceof LivingEntity) {
                            _entity = (LivingEntity)_ent;
                            _entity.f_20884_ = _entity.m_146908_();
                            _entity.f_20886_ = _entity.m_146908_();
                        }
                        _shootFrom = entity;
                        projectileLevel = ((Entity)_shootFrom).f_19853_;
                        if (projectileLevel.m_5776_()) continue;
                        _entityToSpawn = new Object(){

                            public Projectile getArrow(Level level, Entity shooter, float damage, int knockback, byte piercing) {
                                LavaballEntity entityToSpawn = new LavaballEntity((EntityType<? extends LavaballEntity>)((EntityType)SomebossesModEntities.LAVABALL.get()), level);
                                entityToSpawn.m_5602_(shooter);
                                entityToSpawn.m_36781_(damage);
                                entityToSpawn.m_36735_(knockback);
                                entityToSpawn.m_20225_(true);
                                entityToSpawn.m_36767_(piercing);
                                return entityToSpawn;
                            }
                        }.getArrow(projectileLevel, (Entity)entity, 3.0f, 0, (byte)100);
                        _entityToSpawn.m_6034_(_shootFrom.m_20185_(), _shootFrom.m_20188_() - 0.1, _shootFrom.m_20189_());
                        _entityToSpawn.m_6686_(_shootFrom.m_20154_().f_82479_, _shootFrom.m_20154_().f_82480_, _shootFrom.m_20154_().f_82481_, (float)(Math.random() / 1.5), 0.0f);
                        projectileLevel.m_7967_((Entity)_entityToSpawn);
                    }
                }
            }
        }
    }

    public class BasicAttackGoal
    extends Goal {
        final VolcaniumEntity mob;
        int attackprogress;

        public BasicAttackGoal(VolcaniumEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.f_20911_;
        }

        public void m_8056_() {
            this.mob.setAttack(true);
            this.attackprogress = 0;
        }

        public void m_8041_() {
            this.mob.setAttack(false);
        }

        public void m_8037_() {
            if (this.mob.f_20921_ > 0.5f && this.attackprogress == 0) {
                ++this.attackprogress;
                Vec3 _center = new Vec3(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
                List _entfound = this.mob.f_19853_.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(3.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
                for (Entity entityiterator : _entfound) {
                    if (entityiterator == this.mob || entityiterator != this.mob.m_5448_()) continue;
                    entityiterator.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                }
            }
        }
    }
}

