/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageList;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ButtonAction;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerButton;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

class EnlargedScreenshotScreen
extends GuiScreen {
    @Nullable
    private ScreenshotImageHolder showing;
    @Nullable
    private ScreenshotImageList imageList;
    private final GuiButton doneBtn = new ScreenshotViewerButton(0, 0, 52, 20, ManageScreenshotsScreen.GUI_DONE, btn -> this.close());
    private final GuiButton nextBtn;
    private final GuiButton prevBtn = new ScreenshotViewerButton(0, 0, 20, 20, "<", btn -> this.previousScreenshot());

    EnlargedScreenshotScreen() {
        this.nextBtn = new ScreenshotViewerButton(0, 0, 20, 20, ">", btn -> this.nextScreenshot());
    }

    void show(ScreenshotImageHolder showing, ScreenshotImageList imageList) {
        this.showing = showing;
        this.imageList = imageList;
        this.updateButtonsState();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.addUpdatedButton(this.doneBtn, (this.field_146294_l - 52) / 2, this.field_146295_m - 20 - 8);
        this.addUpdatedButton(this.prevBtn, 8, (this.field_146295_m - 20) / 2);
        this.addUpdatedButton(this.nextBtn, this.field_146294_l - 8 - 20, (this.field_146295_m - 20) / 2);
    }

    private void addUpdatedButton(GuiButton button, int x, int y) {
        button.field_146128_h = x;
        button.field_146129_i = y;
        this.func_189646_b(button);
    }

    private void nextScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() + 1) < this.imageList.size()) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void previousScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() - 1) >= 0) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void updateButtonsState() {
        if (this.hasInfo()) {
            int i = this.showing.indexInList();
            this.prevBtn.field_146124_l = i > 0;
            this.nextBtn.field_146124_l = i < this.imageList.size() - 1;
        }
    }

    private boolean hasInfo() {
        return this.showing != null && this.imageList != null;
    }

    boolean renders() {
        return this.hasInfo();
    }

    public void func_146270_b(int tint) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        if (this.showing != null) {
            int spacing = 8;
            BufferedImage image = this.showing.image();
            if (image != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179144_i((int)this.showing.imageId());
                GlStateManager.func_179147_l();
                float imgRatio = (float)image.getWidth() / (float)image.getHeight();
                int texHeight = this.field_146295_m - 24 - 20;
                int texWidth = (int)((float)texHeight * imgRatio);
                EnlargedScreenshotScreen.func_152125_a((int)((this.field_146294_l - texWidth) / 2), (int)8, (float)0.0f, (float)0.0f, (int)image.getWidth(), (int)image.getHeight(), (int)texWidth, (int)texHeight, (float)image.getWidth(), (float)image.getHeight());
                GlStateManager.func_179084_k();
            }
            super.func_73863_a(mouseX, mouseY, delta);
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) {
        if (button instanceof ButtonAction) {
            ((ButtonAction)button).onPress(button);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll > 0) {
            this.nextScreenshot();
        }
        if (scroll < 0) {
            this.previousScreenshot();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 203) {
            this.previousScreenshot();
            return;
        }
        if (keyCode == 205) {
            this.nextScreenshot();
            return;
        }
        if (keyCode == 1) {
            this.close();
        }
    }

    public void close() {
        this.showing = null;
        this.imageList = null;
    }
}

