/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer;

import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.ConfigGuiHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="screenshot_viewer")
public class ScreenshotViewer {
    public static final String MODID = "screenshot_viewer";
    private static ScreenshotViewer instance;
    private final List<ScreenshotViewerConfigListener> configListeners = new ArrayList<ScreenshotViewerConfigListener>();
    private final ScreenshotViewerConfig config;
    private final IModInfo modInfo;
    private KeyBinding openScreenshotsScreenKey;
    private static final ResourceLocation MANAGE_SCREENSHOTS_BUTTON_TEXTURE;

    public ScreenshotViewer() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onConfigReloaded);
        this.registerKeyMappings();
        ModLoadingContext mlc = ModLoadingContext.get();
        this.config = ScreenshotViewerConfig.registerConfig(mlc);
        this.modInfo = mlc.getActiveContainer().getModInfo();
        mlc.registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "client only mod", (version, bool) -> bool));
        MinecraftForge.EVENT_BUS.register((Object)this);
        instance = this;
    }

    private void registerKeyMappings() {
        this.openScreenshotsScreenKey = (KeyBinding)Util.func_200696_a((Object)new KeyBinding(ScreenshotViewer.translation("key", "open_screenshots_screen"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "key.categories.misc"), ClientRegistry::registerKeyBinding);
    }

    private void onConfigReloaded(ModConfig.Reloading event) {
        this.configListeners.forEach(ScreenshotViewerConfigListener::onConfigReloaded);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft client = Minecraft.func_71410_x();
        KeyBinding openScreenshotsScreenKey = ScreenshotViewer.getInstance().getOpenScreenshotsScreenKey();
        if (client.field_71441_e != null && client.field_71462_r == null && event.getAction() == 1 && openScreenshotsScreenKey != null && openScreenshotsScreenKey.getKey().func_197937_c() == event.getKey()) {
            client.func_147108_a((Screen)new ManageScreenshotsScreen(null));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onScreenPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        Minecraft client = screen.getMinecraft();
        List buttons = event.getWidgetList();
        if (((Boolean)this.config.showButtonInGamePauseMenu.get()).booleanValue() && screen instanceof IngameMenuScreen) {
            Widget topButton = (Widget)buttons.get(0);
            event.addWidget((Widget)new ImageButton(topButton.field_230690_l_ + topButton.func_230998_h_() + 8, topButton.field_230691_m_, topButton.func_238483_d_(), topButton.func_238483_d_(), 0, 0, 20, MANAGE_SCREENSHOTS_BUTTON_TEXTURE, 32, 64, button -> client.func_147108_a((Screen)new ManageScreenshotsScreen(screen)), (button, matrices, mouseX, mouseY) -> screen.func_238654_b_(matrices, client.field_71466_p.func_238425_b_((ITextProperties)ScreenshotViewer.translatable("screen", "manage_screenshots"), Math.max(screen.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY), ScreenshotViewer.translatable("screen", "manage_screenshots")));
        }
        if (((Boolean)this.config.showButtonOnTitleScreen.get()).booleanValue() && screen instanceof MainMenuScreen) {
            Optional<ImageButton> accessibilityWidgetOpt = buttons.stream().filter(ImageButton.class::isInstance).map(ImageButton.class::cast).filter(widget -> widget.func_230458_i_().equals(new TranslationTextComponent("narrator.button.accessibility"))).findFirst();
            int x = accessibilityWidgetOpt.map(widget -> widget.field_230690_l_).orElse(screen.field_230708_k_ / 2 + 104);
            int y = accessibilityWidgetOpt.map(widget -> widget.field_230691_m_).orElse(screen.field_230709_l_ / 4 + 132);
            int width = accessibilityWidgetOpt.map(Widget::func_230998_h_).orElse(20);
            int height = accessibilityWidgetOpt.map(Widget::func_238483_d_).orElse(20);
            event.addWidget((Widget)new ImageButton(x + width + 4, y, width, height, 0, 0, 20, MANAGE_SCREENSHOTS_BUTTON_TEXTURE, 32, 64, button -> client.func_147108_a((Screen)new ManageScreenshotsScreen(screen)), (button, matrices, mouseX, mouseY) -> screen.func_238654_b_(matrices, client.field_71466_p.func_238425_b_((ITextProperties)ScreenshotViewer.translatable("screen", "manage_screenshots"), Math.max(screen.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY), ScreenshotViewer.translatable("screen", "manage_screenshots")));
        }
    }

    public ScreenshotViewerConfig getConfig() {
        return this.config;
    }

    public KeyBinding getOpenScreenshotsScreenKey() {
        return this.openScreenshotsScreenKey;
    }

    public Optional<BiFunction<Minecraft, Screen, Screen>> getConfigScreenFactory() {
        return ConfigGuiHandler.getGuiFactoryFor((ModInfo)((ModInfo)this.modInfo));
    }

    public void registerConfigListener(ScreenshotViewerConfigListener listener) {
        this.configListeners.add(listener);
    }

    public void unregisterConfigListener(ScreenshotViewerConfigListener listener) {
        this.configListeners.remove(listener);
    }

    @Nonnull
    public static ScreenshotViewer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Screenshot Viewer is not loaded yet!");
        }
        return instance;
    }

    public static String translation(String prefix, String suffix) {
        return prefix + '.' + MODID + '.' + suffix;
    }

    public static ITextComponent translatable(String prefix, String suffix) {
        return new TranslationTextComponent(ScreenshotViewer.translation(prefix, suffix));
    }

    static {
        MANAGE_SCREENSHOTS_BUTTON_TEXTURE = new ResourceLocation(MODID, "textures/gui/screenshots_button.png");
    }
}

