/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

class EnlargedScreenshotScreen
extends Screen {
    @Nullable
    private ScreenshotImageHolder showing;
    @Nullable
    private ScreenshotImageList imageList;
    private final Button doneBtn = new Button(0, 0, 52, 20, DialogTexts.field_240632_c_, btn -> this.func_231175_as__());
    private final Button nextBtn;
    private final Button prevBtn = new Button(0, 0, 20, 20, (ITextComponent)new StringTextComponent("<"), btn -> this.previousScreenshot());

    EnlargedScreenshotScreen() {
        super(StringTextComponent.field_240750_d_);
        this.nextBtn = new Button(0, 0, 20, 20, (ITextComponent)new StringTextComponent(">"), btn -> this.nextScreenshot());
    }

    void show(ScreenshotImageHolder showing, ScreenshotImageList imageList) {
        this.showing = showing;
        this.imageList = imageList;
        this.updateButtonsState();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.addUpdatedButton(this.doneBtn, (this.field_230708_k_ - 52) / 2, this.field_230709_l_ - 20 - 8);
        this.addUpdatedButton(this.prevBtn, 8, (this.field_230709_l_ - 20) / 2);
        this.addUpdatedButton(this.nextBtn, this.field_230708_k_ - 8 - 20, (this.field_230709_l_ - 20) / 2);
    }

    private void addUpdatedButton(Button button, int x, int y) {
        button.field_230690_l_ = x;
        button.field_230691_m_ = y;
        this.func_230480_a_((Widget)button);
    }

    private void nextScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() + 1) < this.imageList.size()) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void previousScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() - 1) >= 0) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void updateButtonsState() {
        if (this.hasInfo()) {
            int i = this.showing.indexInList();
            this.prevBtn.field_230693_o_ = i > 0;
            this.nextBtn.field_230693_o_ = i < this.imageList.size() - 1;
        }
    }

    private boolean hasInfo() {
        return this.showing != null && this.imageList != null;
    }

    boolean renders() {
        return this.hasInfo();
    }

    public void func_230446_a_(MatrixStack matrices) {
        this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.showing != null) {
            int spacing = 8;
            NativeImage image = this.showing.image();
            if (image != null) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.bindTexture((int)this.showing.imageId());
                RenderSystem.enableBlend();
                float imgRatio = (float)image.func_195702_a() / (float)image.func_195714_b();
                int texHeight = this.field_230709_l_ - 24 - 20;
                int texWidth = (int)((float)texHeight * imgRatio);
                EnlargedScreenshotScreen.func_238466_a_((MatrixStack)matrices, (int)((this.field_230708_k_ - texWidth) / 2), (int)8, (int)texWidth, (int)texHeight, (float)0.0f, (float)0.0f, (int)image.func_195702_a(), (int)image.func_195714_b(), (int)image.func_195702_a(), (int)image.func_195714_b());
                RenderSystem.disableBlend();
            }
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.nextScreenshot();
        }
        if (amount < 0.0) {
            this.previousScreenshot();
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousScreenshot();
            return true;
        }
        if (keyCode == 262) {
            this.nextScreenshot();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_231175_as__() {
        this.showing = null;
        this.imageList = null;
    }
}

