/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotWidget;
import java.io.File;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManageScreenshotsScreen
extends Screen
implements ScreenshotViewerConfigListener {
    static final ScreenshotViewerConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CONFIG_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/config_button.png");
    private static final ResourceLocation REFRESH_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/refresh_button.png");
    private static final ResourceLocation ASCENDING_ORDER_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/ascending_order_button.png");
    private static final ResourceLocation DESCENDING_ORDER_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/descending_order_button.png");
    private static final ResourceLocation OPEN_FOLDER_BUTTON_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/open_folder_button.png");
    private final Screen parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    private float screenshotScaleAnimation;
    private boolean isCtrlDown;

    public ManageScreenshotsScreen(Screen parent) {
        super(ScreenshotViewer.translatable("screen", "manage_screenshots"));
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen();
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client, () -> this.field_230708_k_, () -> this.field_230709_l_);
        ScreenshotViewer.getInstance().registerConfigListener(this);
    }

    Minecraft client() {
        return this.field_230706_i_;
    }

    public void func_231023_e_() {
        if (this.screenshotProperties != null) {
            this.screenshotProperties.tick();
        }
    }

    protected void func_231160_c_() {
        if (this.field_230706_i_ == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        int contentWidth = this.field_230708_k_ - 24;
        int contentHeight = this.field_230709_l_ - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.field_230708_k_ - 24, this.field_230709_l_ - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren();
        }
        this.func_230481_d_((IGuiEventListener)this.list);
        int btnY = this.field_230709_l_ - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        Optional<BiFunction<Minecraft, Screen, Screen>> configScreenFactory = ScreenshotViewer.getInstance().getConfigScreenFactory();
        ExtendedTexturedButtonWidget configButton = new ExtendedTexturedButtonWidget(2, 2, 20, 20, 0, 0, 20, CONFIG_BUTTON_TEXTURE, 32, 64, button -> configScreenFactory.ifPresent(f -> this.field_230706_i_.func_147108_a((Screen)f.apply(this.field_230706_i_, this))), (button, matrices, x, y) -> this.func_238654_b_(matrices, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ScreenshotViewer.translatable("screen", configScreenFactory.isPresent() ? "button.config" : "no_config"), Math.max(this.field_230708_k_ / 2 - 43, 170)), x, y + 20), ScreenshotViewer.translatable("screen", configScreenFactory.isPresent() ? "button.config" : "no_config"));
        ((Button)configButton).field_230693_o_ = configScreenFactory.isPresent();
        this.func_230480_a_((Widget)configButton);
        this.func_230480_a_((Widget)new ExtendedTexturedButtonWidget(8, btnY, 20, 20, 0, 0, 20, null, 32, 64, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, (button, matrices, x, y) -> {
            if (this.list != null) {
                this.func_238654_b_(matrices, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ScreenshotViewer.translatable("screen", this.list.isInvertedOrder() ? "button.order.descending" : "button.order.ascending"), Math.max(this.field_230708_k_ / 2 - 43, 170)), x, y);
            }
        }, ScreenshotViewer.translatable("screen", "button.order")){

            @Override
            @Nullable
            public ResourceLocation getTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_BUTTON_TEXTURE : ASCENDING_ORDER_BUTTON_TEXTURE);
            }
        });
        this.func_230480_a_((Widget)new ExtendedTexturedButtonWidget(36, btnY, 20, 20, 0, 0, 20, OPEN_FOLDER_BUTTON_TEXTURE, 32, 64, btn -> Util.func_110647_a().func_195641_a(new File(this.field_230706_i_.field_71412_D, "screenshots")), (button, matrices, x, y) -> this.func_238654_b_(matrices, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ScreenshotViewer.translatable("screen", "button.screenshot_folder"), Math.max(this.field_230708_k_ / 2 - 43, 170)), x, y), ScreenshotViewer.translatable("screen", "button.screenshot_folder")));
        this.func_230480_a_((Widget)new ExtendedButtonWidget((this.field_230708_k_ - 200) / 2, btnY, 200, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
        this.func_230480_a_((Widget)new ExtendedTexturedButtonWidget(this.field_230708_k_ - 8 - 20, btnY, 20, 20, 0, 0, 20, REFRESH_BUTTON_TEXTURE, 32, 64, button -> this.list.init(), (btn, matrices, x, y) -> this.func_238654_b_(matrices, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ScreenshotViewer.translatable("screen", "button.refresh"), Math.max(this.field_230708_k_ / 2 - 43, 170)), x, y), ScreenshotViewer.translatable("screen", "button.refresh")));
    }

    public void func_231152_a_(Minecraft client, int width, int height) {
        super.func_231152_a_(client, width, height);
        this.enlargedScreenshot.func_231152_a_(client, width, height);
        this.screenshotProperties.hide();
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        if (this.list != null) {
            this.list.render(matrices, mouseX, mouseY, delta, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders());
        }
        ManageScreenshotsScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        ITextComponent text = ScreenshotViewer.translatable("screen", "screenshot_manager.zoom");
        ManageScreenshotsScreen.func_238475_b_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)text, (int)(this.field_230708_k_ - this.field_230712_o_.func_238414_a_((ITextProperties)text) - 8), (int)8, (int)(this.isCtrlDown ? 1629753 : 15780386));
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.screenshotProperties.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (((Boolean)ManageScreenshotsScreen.CONFIG.enableScreenshotEnlargementAnimation.get()).booleanValue() && this.screenshotScaleAnimation < 1.0f) {
                this.screenshotScaleAnimation = (float)((double)this.screenshotScaleAnimation + 0.03);
                animationTime = (float)(1.0 - Math.pow(1.0f - this.screenshotScaleAnimation, 3.0));
            }
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 1.0);
            this.enlargedScreenshot.func_230446_a_(matrices);
            matrices.func_227861_a_((double)((float)this.enlargedScreenshot.field_230708_k_ / 2.0f * (1.0f - animationTime)), (double)((float)this.enlargedScreenshot.field_230709_l_ / 2.0f * (1.0f - animationTime)), 0.0);
            matrices.func_227862_a_(animationTime, animationTime, animationTime);
            this.enlargedScreenshot.func_230430_a_(matrices, mouseX, mouseY, delta);
            matrices.func_227865_b_();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders()) {
                for (IGuiEventListener element : this.func_231039_at__()) {
                    if (!(element instanceof CustomHoverState)) continue;
                    ((CustomHoverState)element).updateHoveredState(mouseX, mouseY);
                }
            }
        }
    }

    void enlargeScreenshot(ScreenshotImageHolder showing) {
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotWidget widget) {
        this.screenshotProperties.show((int)mouseX, (int)mouseY, () -> this.list.removeEntry(widget), widget.getScreenshotFile(), widget::updateScreenshotFile);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_231046_a_(keyCode, scanCode, modifiers);
        }
        this.isCtrlDown = keyCode == 341 || keyCode == 345;
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_223281_a_(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_223281_a_(keyCode, scanCode, modifiers);
        }
        if (this.isCtrlDown) {
            this.isCtrlDown = false;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char chr, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_231042_a_(chr, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_231042_a_(chr, modifiers);
        }
        return super.func_231042_a_(chr, modifiers);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_231043_a_(mouseX, mouseY, amount);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_231043_a_(mouseX, mouseY, amount);
        }
        if (this.list != null) {
            if (this.isCtrlDown) {
                this.list.updateScreenshotsPerRow(amount);
                return true;
            }
            return this.list.func_231043_a_(mouseX, mouseY, amount);
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_231044_a_(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_231044_a_(mouseX, mouseY, button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public Optional<IGuiEventListener> func_212930_a(double mouseX, double mouseY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.func_212930_a(mouseX, mouseY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.func_212930_a(mouseX, mouseY);
        }
        return super.func_212930_a(mouseX, mouseY);
    }

    public void func_231175_as__() {
        if (this.field_230706_i_ != null) {
            this.field_230706_i_.func_147108_a(this.parent);
        }
        ScreenshotViewer.getInstance().unregisterConfigListener(this);
    }

    public void func_231164_f_() {
        this.list.close();
    }

    @Override
    public void onConfigReloaded() {
        this.list.configUpdated();
    }

    private static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }

    private static class ExtendedTexturedButtonWidget
    extends ImageButton
    implements CustomHoverState {
        @Nullable
        private final ResourceLocation texture;
        private final int u;
        private final int v;
        private final int hoveredVOffset;
        private final int textureWidth;
        private final int textureHeight;

        ExtendedTexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, @Nullable ResourceLocation texture, int textureWidth, int textureHeight, Button.IPressable pressAction, Button.ITooltip tooltipSupplier, ITextComponent text) {
            super(x, y, width, height, u, v, hoveredVOffset, Button.field_230687_i_, textureWidth, textureHeight, pressAction, tooltipSupplier, text);
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.u = u;
            this.v = v;
            this.hoveredVOffset = hoveredVOffset;
            this.texture = texture;
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            if (!this.field_230694_p_) {
                return;
            }
            this.func_230431_b_(matrices, mouseX, mouseY, delta);
        }

        @Nullable
        public ResourceLocation getTexture() {
            return this.texture;
        }

        public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            ResourceLocation texture = this.getTexture();
            if (texture == null) {
                ExtendedTexturedButtonWidget.func_238467_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)0xFFFFFF);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                int vOffset = this.v;
                if (!this.field_230693_o_) {
                    vOffset += this.hoveredVOffset * 2;
                } else if (this.func_230449_g_()) {
                    vOffset += this.hoveredVOffset;
                }
                RenderSystem.enableDepthTest();
                ExtendedTexturedButtonWidget.func_238463_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.u, (float)vOffset, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
                if (this.field_230692_n_) {
                    this.func_230443_a_(matrices, mouseX, mouseY);
                }
            }
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        }
    }

    private static final class ExtendedButtonWidget
    extends Button
    implements CustomHoverState {
        ExtendedButtonWidget(int x, int y, int width, int height, ITextComponent message, Button.IPressable onPress) {
            super(x, y, width, height, message, onPress);
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            if (!this.field_230694_p_) {
                return;
            }
            this.func_230431_b_(matrices, mouseX, mouseY, delta);
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        }
    }
}

