/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageList;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotWidget;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

final class ScreenshotList
extends FocusableGui
implements IRenderable,
ScreenshotImageList {
    private final ManageScreenshotsScreen mainScreen;
    private final Minecraft client;
    private final int x;
    private final int y;
    private final List<ScreenshotWidget> screenshotWidgets = new ArrayList<ScreenshotWidget>();
    private final List<IGuiEventListener> elements = new ArrayList<IGuiEventListener>();
    private final Scrollbar scrollbar = new Scrollbar();
    private int width;
    private int height;
    private int scrollY;
    private int scrollSpeedFactor;
    private int screenshotsPerRow;
    private int spacing;
    private int childWidth;
    private int childHeight;
    private boolean invertedOrder;

    ScreenshotList(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height) {
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scrollSpeedFactor = (Integer)ManageScreenshotsScreen.CONFIG.screenScrollSpeed.get();
        this.screenshotsPerRow = (Integer)ManageScreenshotsScreen.CONFIG.initialScreenshotAmountPerRow.get();
        this.updateVariables();
    }

    void updateSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    void configUpdated() {
        this.scrollSpeedFactor = (Integer)ManageScreenshotsScreen.CONFIG.screenScrollSpeed.get();
        this.screenshotsPerRow = (Integer)ManageScreenshotsScreen.CONFIG.initialScreenshotAmountPerRow.get();
        this.updateChildren();
    }

    void init() {
        this.clearChildren();
        File[] files = new File(this.client.field_71412_D, "screenshots").listFiles();
        if (files != null) {
            this.updateVariables();
            int maxXOff = this.screenshotsPerRow - 1;
            int childX = this.x + this.spacing;
            int childY = this.y + this.spacing;
            int xOff = 0;
            ScreenshotWidget.Context context = ScreenshotWidget.Context.create(() -> this.screenshotsPerRow, this.screenshotWidgets::indexOf);
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".png")) continue;
                ScreenshotWidget widget = new ScreenshotWidget(this.mainScreen, childX, childY, this.childWidth, this.childHeight, context, file);
                this.screenshotWidgets.add(widget);
                this.elements.add((IGuiEventListener)widget);
                if (xOff == maxXOff) {
                    xOff = 0;
                    childX = this.x + this.spacing;
                    childY += this.childHeight + this.spacing;
                    continue;
                }
                ++xOff;
                childX += this.childWidth + this.spacing;
            }
        }
        this.scrollbar.repositionScrollbar(this.x, this.y, this.width, this.height, this.spacing, this.getTotalHeightOfChildren());
    }

    void updateScreenshotsPerRow(double scrollAmount) {
        if (scrollAmount > 0.0) {
            if (this.screenshotsPerRow < 8) {
                this.screenshotsPerRow = Math.min(8, this.screenshotsPerRow + 1);
            }
        } else if (scrollAmount < 0.0 && this.screenshotsPerRow > 2) {
            this.screenshotsPerRow = Math.max(2, this.screenshotsPerRow - 1);
        }
        this.updateChildren();
    }

    void updateChildren() {
        this.scrollY = 0;
        this.updateVariables();
        int maxXOff = this.screenshotsPerRow - 1;
        int childX = this.x + this.spacing;
        int childY = this.y + this.spacing;
        int xOff = 0;
        for (ScreenshotWidget widget : this.screenshotWidgets) {
            widget.field_230690_l_ = childX;
            widget.updateBaseY(childY);
            widget.func_230991_b_(this.childWidth);
            widget.setHeight(this.childHeight);
            if (xOff == maxXOff) {
                xOff = 0;
                childX = this.x + this.spacing;
                childY += this.childHeight + this.spacing;
                continue;
            }
            ++xOff;
            childX += this.childWidth + this.spacing;
        }
        this.scrollbar.repositionScrollbar(this.x, this.y, this.width, this.height, this.spacing, this.getTotalHeightOfChildren());
    }

    void removeEntry(ScreenshotWidget widget) {
        this.screenshotWidgets.remove(widget);
        this.elements.remove(widget);
        this.updateChildren();
    }

    private void updateVariables() {
        float windowAspect = (float)this.client.func_228018_at_().func_198105_m() / (float)this.client.func_228018_at_().func_198083_n();
        int scrollbarWidth = 6;
        int scrollbarSpacing = 2;
        this.spacing = 4;
        this.childWidth = (this.width - (this.screenshotsPerRow + 1) * this.spacing - 6 - 2) / this.screenshotsPerRow;
        this.childHeight = (int)(1.08 * (double)this.childWidth / (double)windowAspect);
    }

    private void clearChildren() {
        this.close();
        this.screenshotWidgets.clear();
        this.elements.clear();
    }

    public void close() {
        this.screenshotWidgets.forEach(ScreenshotWidget::close);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
    }

    void render(MatrixStack matrices, int mouseX, int mouseY, float delta, boolean updateHoverState) {
        ScreenshotList.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)ColorHelper.PackedColor.func_233006_a_((int)178, (int)0, (int)0, (int)0));
        if (this.screenshotWidgets.isEmpty()) {
            ScreenshotList.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.client.field_71466_p, (ITextComponent)ScreenshotViewer.translatable("screen", "screenshot_manager.no_screenshots"), (int)((this.x + this.width) / 2), (int)((this.y + this.height + 8) / 2), (int)0xFFFFFF);
        }
        for (ScreenshotWidget screenshotWidget : this.screenshotWidgets) {
            screenshotWidget.updateY(this.scrollY);
            int viewportY = this.y + this.spacing;
            int viewportBottom = this.y + this.height - this.spacing;
            screenshotWidget.updateHoverState(mouseX, mouseY, viewportY, viewportBottom, updateHoverState);
            if (screenshotWidget.field_230691_m_ + screenshotWidget.func_238483_d_() < this.y || screenshotWidget.field_230691_m_ > this.y + this.height) continue;
            screenshotWidget.render(matrices, mouseX, mouseY, delta, viewportY, viewportBottom);
        }
        if (this.canScroll()) {
            this.scrollbar.render(matrices, mouseX, mouseY, this.scrollY);
        }
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.elements;
    }

    @Override
    public ScreenshotImageHolder getScreenshot(int index) {
        return this.screenshotWidgets.get(index);
    }

    @Override
    public int size() {
        return this.screenshotWidgets.size();
    }

    void invertOrder() {
        Collections.reverse(this.screenshotWidgets);
        this.invertedOrder = !this.invertedOrder;
        int previousScrollY = this.scrollY;
        this.updateChildren();
        this.scrollY = previousScrollY;
    }

    boolean isInvertedOrder() {
        return this.invertedOrder;
    }

    private boolean canScroll() {
        int viewHeight;
        int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
        return totalHeightOfTheChildrens > (viewHeight = this.height - 2 * this.spacing);
    }

    private boolean canScrollDown() {
        int viewHeight;
        int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
        int leftOver = totalHeightOfTheChildrens - (viewHeight = this.height - 2 * this.spacing);
        return this.scrollY < leftOver;
    }

    private int getTotalHeightOfChildren() {
        int rows = MathHelper.func_76123_f((float)((float)this.screenshotWidgets.size() / (float)this.screenshotsPerRow));
        return rows * this.childHeight + this.spacing * (rows - 1);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.canScroll()) {
            int scrollSpeed = Math.abs((int)((double)((float)this.scrollSpeedFactor * (6.0f / (float)this.screenshotsPerRow)) * amount));
            if (this.scrollY > 0 && amount > 0.0) {
                this.scrollY = Math.max(0, this.scrollY - scrollSpeed);
            }
            if (this.canScrollDown() && amount < 0.0) {
                int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
                int viewHeight = this.height - 2 * this.spacing;
                int leftOver = totalHeightOfTheChildrens - viewHeight;
                this.scrollY = Math.min(leftOver, this.scrollY + scrollSpeed);
            }
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    private static class Scrollbar {
        private final int spacing = 2;
        private final int width = 6;
        private final int trackWidth = 2;
        private int x;
        private int height;
        private int trackX;
        private int trackY;
        private int trackHeight;
        private IntUnaryOperator scrollbarYGetter;

        private Scrollbar() {
        }

        void repositionScrollbar(int listX, int listY, int listWith, int listHeight, int listSpacing, int totalHeightOfTheChildrens) {
            this.x = listX + listWith - 2 - 6;
            this.trackX = this.x + 2;
            this.trackY = listY + listSpacing;
            this.trackHeight = listHeight - 2 * listSpacing;
            int scrollbarSpacedTrackHeight = this.trackHeight + 4;
            this.scrollbarYGetter = scrollOffset -> MathHelper.func_76123_f((float)((float)(scrollOffset * scrollbarSpacedTrackHeight) / (float)totalHeightOfTheChildrens)) + listY + 2;
            this.height = this.trackHeight * scrollbarSpacedTrackHeight / totalHeightOfTheChildrens;
        }

        void render(MatrixStack matrices, double mouseX, double mouseY, int scrollOffset) {
            int y = this.scrollbarYGetter.applyAsInt(scrollOffset);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)this.trackX, (int)this.trackY, (int)(this.trackX + 2), (int)(this.trackY + this.trackHeight), (int)-1);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)y, (int)(this.x + 6), (int)(y + this.height), (int)(this.isHovered(mouseX, mouseY, y) ? -9605779 : -14803426));
        }

        private boolean isHovered(double mouseX, double mouseY, int y) {
            return mouseX >= (double)this.x && mouseY >= (double)y && mouseX < (double)(this.x + 6) && mouseY < (double)(y + this.height);
        }
    }
}

