/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

class ScreenshotPropertiesMenu
extends FocusableGui
implements IRenderable {
    private static final int BUTTON_SIZE = 19;
    private final Supplier<Minecraft> mcSupplier;
    private final IntSupplier parentWidth;
    private final IntSupplier parentHeight;
    private final List<Widget> buttons = new ArrayList<Widget>();
    private int x;
    private int y;
    private int width;
    private int height;
    @Nonnull
    private String fileName = "";
    private boolean shouldRender;
    @Nullable
    private Screen childScreen;

    ScreenshotPropertiesMenu(Supplier<Minecraft> mcSupplier, IntSupplier parentWidth, IntSupplier parentHeight) {
        this.mcSupplier = mcSupplier;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
    }

    void tick() {
        if (this.childScreen != null) {
            this.childScreen.func_231023_e_();
        }
    }

    void show(int x, int y, Runnable remover, File screenshotFile, Consumer<File> fileUpdater) {
        this.buttons.clear();
        this.fileName = screenshotFile.getName();
        int spacing = 2;
        BooleanConsumer deleteAction = value -> {
            if (value) {
                if (screenshotFile.exists() && !screenshotFile.delete()) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to delete 'screenshot' file at location '{}'", (Object)screenshotFile.toPath().toAbsolutePath());
                    return;
                }
                remover.run();
            }
            this.hide();
        };
        ArrayList buttonInfo = Lists.newArrayList((Object[])new Triple[]{Triple.of((Object)0, (Object)ScreenshotViewer.translatable("screen", "button.delete_screenshot"), btn -> {
            if (((Boolean)ManageScreenshotsScreen.CONFIG.promptWhenDeletingScreenshot.get()).booleanValue()) {
                this.childScreen = new ConfirmationScreen(deleteAction, screenshotFile.getName());
                this.childScreen.func_231158_b_(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
            } else {
                deleteAction.accept(true);
            }
        }), Triple.of((Object)1, (Object)ScreenshotViewer.translatable("screen", "button.open_file"), btn -> Util.func_110647_a().func_195641_a(screenshotFile)), Triple.of((Object)3, (Object)ScreenshotViewer.translatable("screen", "button.rename_file"), btn -> {
            this.childScreen = new RenameScreen(this.fileName.substring(0, this.fileName.lastIndexOf(46)), s -> {
                try {
                    Path moved = Files.move(screenshotFile.toPath(), screenshotFile.toPath().resolveSibling((String)s), new CopyOption[0]);
                    fileUpdater.accept(moved.toFile());
                }
                catch (IOException e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to rename 'screenshot' file at '" + screenshotFile.toPath().toAbsolutePath() + "' from '" + screenshotFile.getName() + "' to '" + s + "'", (Throwable)e);
                }
            }, this::hide);
            this.childScreen.func_231158_b_(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
        }), Triple.of((Object)2, (Object)ScreenshotViewer.translatable("screen", "button.close_properties_menu"), btn -> this.hide())});
        FontRenderer font = this.mcSupplier.get().field_71466_p;
        int largestTextWidth = buttonInfo.stream().map(Triple::getMiddle).mapToInt(arg_0 -> ((FontRenderer)font).func_238414_a_(arg_0)).max().orElse(0);
        this.width = 4 + Math.max(font.func_78256_a(this.fileName), 19 + largestTextWidth + 2);
        font.getClass();
        this.height = 6 + 9 + 19 * buttonInfo.size();
        this.x = x + this.width > this.parentWidth.getAsInt() ? x - this.width : x;
        this.y = y + this.height > this.parentHeight.getAsInt() ? y - this.height : y;
        for (int i = 0; i < buttonInfo.size(); ++i) {
            Triple pair = (Triple)buttonInfo.get(i);
            font.getClass();
            this.buttons.add((Widget)new ScreenButton(this.x + 2, this.y + 4 + 9 + 19 * i, 19 * (Integer)pair.getLeft(), 19, (ITextComponent)pair.getMiddle(), (Button.IPressable)pair.getRight()));
        }
        this.shouldRender = true;
    }

    void hide() {
        this.buttons.clear();
        this.shouldRender = false;
        this.childScreen = null;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
        this.fileName = "";
    }

    boolean renders() {
        return this.shouldRender;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.shouldRender) {
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 1.0);
            if (this.childScreen == null) {
                int spacing = 2;
                ScreenshotPropertiesMenu.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-12434878);
                this.mcSupplier.get().field_71466_p.func_238405_a_(matrices, this.fileName, (float)(this.x + 2), (float)(this.y + 2), -1);
                for (Widget widget : this.buttons) {
                    widget.func_230430_a_(matrices, mouseX, mouseY, delta);
                    this.mcSupplier.get().field_71466_p.func_243246_a(matrices, widget.func_230458_i_(), (float)(widget.field_230690_l_ + widget.func_230998_h_() + 2), (float)widget.field_230691_m_ + (float)(widget.func_238483_d_() - 9) / 2.0f + 2.0f, -1);
                }
            } else {
                this.childScreen.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
            matrices.func_227865_b_();
        }
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.buttons;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.childScreen != null) {
            return this.childScreen.func_231044_a_(mouseX, mouseY, button);
        }
        if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX > (double)(this.x + this.width) || mouseY > (double)(this.y + this.height)) {
            this.hide();
            return false;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.hide();
            return true;
        }
        if (this.childScreen instanceof RenameScreen) {
            return this.childScreen.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean func_231042_a_(char chr, int modifiers) {
        if (this.childScreen instanceof RenameScreen) {
            return this.childScreen.func_231042_a_(chr, modifiers);
        }
        return super.func_231042_a_(chr, modifiers);
    }

    private static final class RenameScreen
    extends Screen {
        private final String previousName;
        private final Consumer<String> newNameConsumer;
        private final Runnable closeAction;
        private TextFieldWidget textField;
        private Button doneBtn;

        private RenameScreen(String previousName, Consumer<String> newNameConsumer, Runnable closeAction) {
            super(ScreenshotViewer.translatable("screen", "rename_screenshot"));
            this.previousName = previousName;
            this.newNameConsumer = newNameConsumer;
            this.closeAction = closeAction;
        }

        public void func_231023_e_() {
            if (this.textField != null) {
                this.textField.func_146178_a();
            }
        }

        protected void func_231160_c_() {
            super.func_231160_c_();
            this.textField = new TextFieldWidget(this.field_230712_o_, (this.field_230708_k_ - 150) / 2, (this.field_230709_l_ - 20) / 2, 150, 20, ScreenshotViewer.translatable("screen", "field.screenshot_name"));
            this.textField.func_146203_f(128);
            this.textField.func_200675_a(RenameScreen::checkInvalidCharacters);
            this.doneBtn = new Button(this.field_230708_k_ / 2 - 4 - 150, this.field_230709_l_ / 2 + 50, 150, 20, DialogTexts.field_240632_c_, btn -> {
                this.newNameConsumer.accept(this.textField.func_146179_b().trim().concat(".png"));
                this.closeAction.run();
            });
            this.doneBtn.field_230693_o_ = false;
            this.textField.func_212954_a(s -> {
                this.doneBtn.field_230693_o_ = !StringUtils.isBlank((CharSequence)s) && !s.trim().equals(this.previousName) && !s.endsWith(".");
            });
            this.textField.func_146180_a(this.previousName);
            this.func_230480_a_((Widget)this.textField);
            this.func_230480_a_((Widget)this.doneBtn);
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ / 2 + 50, 150, 20, DialogTexts.field_240637_h_, btn -> this.closeAction.run()));
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
            RenameScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 70), (int)0xFFFFFF);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }

        public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 && this.doneBtn != null && this.doneBtn.field_230693_o_) {
                this.doneBtn.func_230930_b_();
                return true;
            }
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }

        public void func_231175_as__() {
            this.closeAction.run();
        }

        private static boolean checkInvalidCharacters(String s) {
            return s.chars().noneMatch(c -> c == 92 || c == 47 || c == 58 || c == 42 || c == 63 || c == 34 || c == 60 || c == 62 || c == 124);
        }
    }

    private static final class ConfirmationScreen
    extends ConfirmScreen {
        public ConfirmationScreen(BooleanConsumer callback, String fileName) {
            super(callback, (ITextComponent)new TranslationTextComponent("screen.screenshot_viewer.delete_prompt", new Object[]{fileName}), ScreenshotViewer.translatable("screen", "delete_prompt.message"));
        }

        public void func_238651_a_(MatrixStack matrices, int vOffset) {
            this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        }
    }

    private static final class ScreenButton
    extends ImageButton {
        private static final ResourceLocation TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/screenshot_viewer_icons.png");
        private final int imgU;
        private final int imgV;

        public ScreenButton(int x, int y, int imgU, int imgV, ITextComponent title, Button.IPressable pressAction) {
            super(x, y, 19, 19, 0, 0, 0, field_230687_i_, 128, 128, pressAction, title);
            this.imgU = imgU;
            this.imgV = imgV;
        }

        public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            RenderSystem.enableDepthTest();
            ImageButton.func_238463_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)(this.func_230449_g_() ? 19.0f : 38.0f), (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)128, (int)128);
            ImageButton.func_238463_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.imgU, (float)this.imgV, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)128, (int)128);
        }
    }
}

