/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

final class ScreenshotWidget
extends Widget
implements AutoCloseable,
ScreenshotImageHolder {
    private final ManageScreenshotsScreen mainScreen;
    private final Minecraft client;
    private final Context ctx;
    private File screenshotFile;
    private CompletableFuture<NativeImage> image;
    @Nullable
    private DynamicTexture texture;
    private float bgOpacity = 0.0f;
    private int baseY;

    public ScreenshotWidget(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height, Context ctx, File screenshotFile) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(screenshotFile.getName()));
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.baseY = y;
        this.ctx = ctx;
        this.screenshotFile = screenshotFile;
        this.image = this.getImage(screenshotFile);
    }

    void updateBaseY(int baseY) {
        this.field_230691_m_ = this.baseY = baseY;
    }

    void updateY(int scrollY) {
        this.field_230691_m_ = this.baseY - scrollY;
    }

    void updateScreenshotFile(File screenshotFile) {
        this.screenshotFile = screenshotFile;
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.texture = null;
        this.image = this.getImage(screenshotFile);
    }

    File getScreenshotFile() {
        return this.screenshotFile;
    }

    void updateHoverState(int mouseX, int mouseY, int viewportY, int viewportBottom, boolean updateHoverState) {
        this.field_230692_n_ = updateHoverState && mouseX >= this.field_230690_l_ && mouseY >= Math.max(this.field_230691_m_, viewportY) && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < Math.min(this.field_230691_m_ + this.field_230689_k_, viewportBottom);
        int maxOpacity = (Integer)ManageScreenshotsScreen.CONFIG.screenshotElementBackgroundOpacity.get();
        if (maxOpacity > 0 && this.field_230692_n_) {
            if (this.bgOpacity < (float)maxOpacity / 100.0f) {
                this.bgOpacity = Math.min((float)maxOpacity / 100.0f, this.bgOpacity + 0.05f);
            }
        } else if (this.bgOpacity > 0.0f) {
            this.bgOpacity = Math.max(0.0f, this.bgOpacity - 0.05f);
        }
    }

    void render(MatrixStack matrices, int mouseX, int mouseY, float delta, int viewportY, int viewportBottom) {
        this.renderBackground(matrices, mouseX, mouseY, viewportY, viewportBottom);
        int spacing = 2;
        DynamicTexture image = this.texture();
        if (image != null && image.func_195414_e() != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.bindTexture((int)image.func_110552_b());
            RenderSystem.enableBlend();
            int renderY = Math.max(this.field_230691_m_ + 2, viewportY);
            int imgHeight = (int)((double)this.field_230689_k_ / 1.08 - 6.0);
            int topOffset = Math.max(0, viewportY - this.field_230691_m_ - 2);
            int bottomOffset = Math.max(0, this.field_230691_m_ + 2 + imgHeight - viewportBottom);
            int topV = topOffset * image.func_195414_e().func_195714_b() / imgHeight;
            int bottomV = bottomOffset * image.func_195414_e().func_195714_b() / imgHeight;
            ScreenshotWidget.func_238466_a_((MatrixStack)matrices, (int)(this.field_230690_l_ + 2), (int)renderY, (int)(this.field_230688_j_ - 4), (int)(imgHeight - topOffset - bottomOffset), (float)0.0f, (float)topV, (int)image.func_195414_e().func_195702_a(), (int)(image.func_195414_e().func_195714_b() - topV - bottomV), (int)image.func_195414_e().func_195702_a(), (int)image.func_195414_e().func_195714_b());
            RenderSystem.disableBlend();
        }
        float scaleFactor = (float)(this.client.func_228018_at_().func_198087_p() / 96) / (float)this.ctx.screenshotsPerRow();
        int textY = this.field_230691_m_ + (int)((double)this.field_230689_k_ / 1.08) - 2;
        if (textY > viewportY) {
            float f = textY;
            this.client.field_71466_p.getClass();
            if (f + scaleFactor * 9.0f < (float)viewportBottom) {
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)((float)this.field_230690_l_ + (float)this.field_230688_j_ / 2.0f), (double)textY, 0.0);
                matrices.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
                ITextComponent message = this.func_230458_i_();
                float centerX = -this.client.field_71466_p.func_238414_a_((ITextProperties)this.func_230458_i_()) / 2;
                int textColor = Optional.ofNullable(Color.func_240745_a_((String)((String)ManageScreenshotsScreen.CONFIG.screenshotElementTextColor.get()))).map(Color::func_240742_a_).orElse(0xFFFFFF);
                if (((Boolean)ManageScreenshotsScreen.CONFIG.renderScreenshotElementFontShadow.get()).booleanValue()) {
                    this.client.field_71466_p.func_243246_a(matrices, message, centerX, 0.0f, textColor);
                } else {
                    this.client.field_71466_p.func_243248_b(matrices, message, centerX, 0.0f, textColor);
                }
                matrices.func_227865_b_();
            }
        }
    }

    public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
    }

    private void renderBackground(MatrixStack matrices, int mouseX, int mouseY, int viewportY, int viewportBottom) {
        int renderY = Math.max(this.field_230691_m_, viewportY);
        int renderHeight = Math.min(this.field_230691_m_ + this.field_230689_k_, viewportBottom);
        ScreenshotWidget.func_238467_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)renderY, (int)(this.field_230690_l_ + this.field_230688_j_), (int)renderHeight, (int)ColorHelper.PackedColor.func_233006_a_((int)((int)(this.bgOpacity * 255.0f)), (int)255, (int)255, (int)255));
    }

    private void onClick() {
        this.mainScreen.enlargeScreenshot(this);
    }

    private void onRightClick(double mouseX, double mouseY) {
        this.mainScreen.showScreenshotProperties(mouseX, mouseY, this);
    }

    private CompletableFuture<NativeImage> getImage(File file) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                NativeImage nativeImage = NativeImage.func_195713_a((InputStream)inputStream);
                return nativeImage;
            }
            catch (Exception e) {
                ManageScreenshotsScreen.LOGGER.error("Failed to load screenshot: {}", (Object)file.getName(), (Object)e);
                return null;
            }
        }, Util.func_215072_e());
    }

    @Nullable
    public DynamicTexture texture() {
        if (this.texture != null) {
            return this.texture;
        }
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        if (this.image.isDone()) {
            this.texture = new DynamicTexture(this.image.join());
            return this.texture;
        }
        return null;
    }

    @Override
    public int indexInList() {
        return this.ctx.currentIndex(this);
    }

    @Override
    public int imageId() {
        DynamicTexture texture = this.texture();
        return texture != null ? texture.func_110552_b() : 0;
    }

    @Override
    @Nullable
    public NativeImage image() {
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        return this.image.getNow(null);
    }

    public ITextComponent func_230458_i_() {
        return this.screenshotFile == null ? super.func_230458_i_() : new StringTextComponent(this.screenshotFile.getName());
    }

    public void func_230988_a_(SoundHandler soundManager) {
        soundManager.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_230449_g_()) {
            this.func_230988_a_(this.client.func_147118_V());
            if (button == 0) {
                this.onClick();
            }
            if (button == 1) {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        return false;
    }

    public boolean func_230449_g_() {
        return this.field_230692_n_;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return this.func_230449_g_();
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.image = null;
        this.texture = null;
    }

    static interface Context {
        public int screenshotsPerRow();

        public int currentIndex(ScreenshotWidget var1);

        public static Context create(final IntSupplier screenshotsPerRow, final ToIntFunction<ScreenshotWidget> currentIndex) {
            return new Context(){

                @Override
                public int screenshotsPerRow() {
                    return screenshotsPerRow.getAsInt();
                }

                @Override
                public int currentIndex(ScreenshotWidget widget) {
                    return currentIndex.applyAsInt(widget);
                }
            };
        }
    }
}

