/*
 * Decompiled with CFR 0.152.
 */
package me.ethius.viewmodel.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import me.ethius.viewmodel.Viewmodel;
import me.ethius.viewmodel.settings.BooleanSetting;
import me.ethius.viewmodel.settings.FloatSetting;
import me.ethius.viewmodel.settings.Setting;
import me.ethius.viewmodel.util.Stopwatch;

public class SaveConfig {
    private Gson gson;
    public static Stopwatch saveTimer;
    public static String folderName;

    public SaveConfig() {
        try {
            this.gson = new GsonBuilder().setPrettyPrinting().create();
            this.saveConfig();
            this.saveAllSettings();
            saveTimer = new Stopwatch();
            this.timedSave();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() throws IOException {
        if (!Files.exists(Paths.get(folderName, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(folderName, new String[0]), new FileAttribute[0]);
        }
    }

    public void saveAllSettings() {
        try {
            this.makeFile(null, "Viewmodel");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            OutputStreamWriter fileOutputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(folderName + "Viewmodel.json"), StandardCharsets.UTF_8);
            JsonObject viewmodelObj = new JsonObject();
            for (Setting value : Viewmodel.SETTINGS) {
                if (value instanceof BooleanSetting) {
                    viewmodelObj.add(value.getName(), (JsonElement)new JsonPrimitive((Boolean)value.getValue()));
                    continue;
                }
                if (!(value instanceof FloatSetting)) continue;
                viewmodelObj.add(value.getName(), (JsonElement)new JsonPrimitive((Number)((Float)value.getValue())));
            }
            String jsonString = gson.toJson(new JsonParser().parse(viewmodelObj.toString()));
            fileOutputStreamWriter.write(jsonString);
            fileOutputStreamWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void makeFile(String location, String name) throws IOException {
        if (location != null) {
            if (!Files.exists(Paths.get(folderName + location + name + ".json", new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(folderName + location + name + ".json", new String[0]), new FileAttribute[0]);
            } else {
                File file = new File(folderName + location + name + ".json");
                if (file.delete()) {
                    Files.createFile(Paths.get(folderName + location + name + ".json", new String[0]), new FileAttribute[0]);
                }
            }
        } else if (!Files.exists(Paths.get(folderName + name + ".json", new String[0]), new LinkOption[0])) {
            Files.createFile(Paths.get(folderName + name + ".json", new String[0]), new FileAttribute[0]);
        } else {
            File file = new File(folderName + name + ".json");
            file.delete();
            Files.createFile(Paths.get(folderName + name + ".json", new String[0]), new FileAttribute[0]);
        }
    }

    public void timedSave() {
        if (saveTimer.passed(5000.0)) {
            this.saveAllSettings();
            saveTimer.reset();
        }
    }

    static {
        folderName = "Viewmodel/";
    }
}

