/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageList;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

class EnlargedScreenshotScreen
extends class_437 {
    @Nullable
    private ScreenshotImageHolder showing;
    @Nullable
    private ScreenshotImageList imageList;
    private final class_4185 doneBtn = new class_4185(0, 0, 52, 20, class_5244.field_24334, btn -> this.method_25419());
    private final class_4185 nextBtn;
    private final class_4185 prevBtn = new class_4185(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"<"), btn -> this.previousScreenshot());

    EnlargedScreenshotScreen() {
        super((class_2561)class_2561.method_43473());
        this.nextBtn = new class_4185(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)">"), btn -> this.nextScreenshot());
    }

    void show(ScreenshotImageHolder showing, ScreenshotImageList imageList) {
        this.showing = showing;
        this.imageList = imageList;
        this.updateButtonsState();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.addUpdatedButton(this.doneBtn, (this.field_22789 - 52) / 2, this.field_22790 - 20 - 8);
        this.addUpdatedButton(this.prevBtn, 8, (this.field_22790 - 20) / 2);
        this.addUpdatedButton(this.nextBtn, this.field_22789 - 8 - 20, (this.field_22790 - 20) / 2);
    }

    private void addUpdatedButton(class_4185 button, int x, int y) {
        button.field_22760 = x;
        button.field_22761 = y;
        this.method_37063((class_364)button);
    }

    private void nextScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() + 1) < this.imageList.size()) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void previousScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() - 1) >= 0) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void updateButtonsState() {
        if (this.hasInfo()) {
            int i = this.showing.indexInList();
            this.prevBtn.field_22763 = i > 0;
            this.nextBtn.field_22763 = i < this.imageList.size() - 1;
        }
    }

    private boolean hasInfo() {
        return this.showing != null && this.imageList != null;
    }

    boolean renders() {
        return this.hasInfo();
    }

    public void method_25420(class_4587 matrices) {
        this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.showing != null) {
            int spacing = 8;
            class_1011 image = this.showing.image();
            if (image != null) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (int)this.showing.imageId());
                RenderSystem.enableBlend();
                float imgRatio = (float)image.method_4307() / (float)image.method_4323();
                int texHeight = this.field_22790 - 24 - 20;
                int texWidth = (int)((float)texHeight * imgRatio);
                class_332.method_25293((class_4587)matrices, (int)((this.field_22789 - texWidth) / 2), (int)8, (int)texWidth, (int)texHeight, (float)0.0f, (float)0.0f, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4307(), (int)image.method_4323());
                RenderSystem.disableBlend();
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.nextScreenshot();
        }
        if (amount < 0.0) {
            this.previousScreenshot();
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousScreenshot();
            return true;
        }
        if (keyCode == 262) {
            this.nextScreenshot();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.showing = null;
        this.imageList = null;
    }
}

