/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.github.lgatodu47.catconfig.CatConfig;
import io.github.lgatodu47.catconfigmc.screen.ConfigListener;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerConfigScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotWidget;
import java.io.File;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ManageScreenshotsScreen
extends class_437
implements ConfigListener {
    static final CatConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 CONFIG_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/config_button.png");
    private static final class_2960 REFRESH_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/refresh_button.png");
    private static final class_2960 ASCENDING_ORDER_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/ascending_order_button.png");
    private static final class_2960 DESCENDING_ORDER_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/descending_order_button.png");
    private static final class_2960 OPEN_FOLDER_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/open_folder_button.png");
    private final class_437 parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    private float screenshotScaleAnimation;
    private boolean isCtrlDown;

    public ManageScreenshotsScreen(class_437 parent) {
        super(ScreenshotViewer.translatable("screen", "manage_screenshots"));
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen();
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client, () -> this.field_22789, () -> this.field_22790);
    }

    class_310 client() {
        return this.field_22787;
    }

    public void method_25393() {
        if (this.screenshotProperties != null) {
            this.screenshotProperties.tick();
        }
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.method_25423(this.field_22787, this.field_22789, this.field_22790);
        int contentWidth = this.field_22789 - 24;
        int contentHeight = this.field_22790 - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.field_22789 - 24, this.field_22790 - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren();
        }
        this.method_25429((class_364)this.list);
        int btnY = this.field_22790 - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(2, 2, 20, 20, 0, 0, 20, CONFIG_BUTTON_TEXTURE, 32, 64, button -> this.field_22787.method_1507((class_437)new ScreenshotViewerConfigScreen(this)), (button, matrices, x, y) -> this.method_25417(matrices, this.field_22787.field_1772.method_1728((class_5348)ScreenshotViewer.translatable("screen", "button.config"), Math.max(this.field_22789 / 2 - 43, 170)), x, y + 20), ScreenshotViewer.translatable("screen", "button.config")));
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(8, btnY, 20, 20, 0, 0, 20, null, 32, 64, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, (button, matrices, x, y) -> {
            if (this.list != null) {
                this.method_25417(matrices, this.field_22787.field_1772.method_1728((class_5348)ScreenshotViewer.translatable("screen", this.list.isInvertedOrder() ? "button.order.descending" : "button.order.ascending"), Math.max(this.field_22789 / 2 - 43, 170)), x, y);
            }
        }, ScreenshotViewer.translatable("screen", "button.order")){

            @Override
            @Nullable
            public class_2960 getTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_BUTTON_TEXTURE : ASCENDING_ORDER_BUTTON_TEXTURE);
            }
        });
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(36, btnY, 20, 20, 0, 0, 20, OPEN_FOLDER_BUTTON_TEXTURE, 32, 64, btn -> class_156.method_668().method_672(new File(this.field_22787.field_1697, "screenshots")), (button, matrices, x, y) -> this.method_25417(matrices, this.field_22787.field_1772.method_1728((class_5348)ScreenshotViewer.translatable("screen", "button.screenshot_folder"), Math.max(this.field_22789 / 2 - 43, 170)), x, y), ScreenshotViewer.translatable("screen", "button.screenshot_folder")));
        this.method_37063((class_364)new ExtendedButtonWidget((this.field_22789 - 200) / 2, btnY, 200, 20, class_5244.field_24334, button -> this.method_25419()));
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(this.field_22789 - 8 - 20, btnY, 20, 20, 0, 0, 20, REFRESH_BUTTON_TEXTURE, 32, 64, button -> this.list.init(), (btn, matrices, x, y) -> this.method_25417(matrices, this.field_22787.field_1772.method_1728((class_5348)ScreenshotViewer.translatable("screen", "button.refresh"), Math.max(this.field_22789 / 2 - 43, 170)), x, y), ScreenshotViewer.translatable("screen", "button.refresh")));
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.enlargedScreenshot.method_25410(client, width, height);
        this.screenshotProperties.hide();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        if (this.list != null) {
            this.list.render(matrices, mouseX, mouseY, delta, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders());
        }
        ManageScreenshotsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)8, (int)0xFFFFFF);
        class_2561 text = ScreenshotViewer.translatable("screen", "screenshot_manager.zoom");
        ManageScreenshotsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)text, (int)(this.field_22789 - this.field_22793.method_27525((class_5348)text) - 8), (int)8, (int)(this.isCtrlDown ? 1629753 : 15780386));
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.screenshotProperties.method_25394(matrices, mouseX, mouseY, delta);
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (((Boolean)CONFIG.getOrFallback(ScreenshotViewerOptions.ENABLE_SCREENSHOT_ENLARGEMENT_ANIMATION, (Object)true)).booleanValue() && this.screenshotScaleAnimation < 1.0f) {
                this.screenshotScaleAnimation = (float)((double)this.screenshotScaleAnimation + 0.03);
                animationTime = (float)(1.0 - Math.pow(1.0f - this.screenshotScaleAnimation, 3.0));
            }
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 1.0);
            this.enlargedScreenshot.method_25420(matrices);
            matrices.method_22904((double)((float)this.enlargedScreenshot.field_22789 / 2.0f * (1.0f - animationTime)), (double)((float)this.enlargedScreenshot.field_22790 / 2.0f * (1.0f - animationTime)), 0.0);
            matrices.method_22905(animationTime, animationTime, animationTime);
            this.enlargedScreenshot.method_25394(matrices, mouseX, mouseY, delta);
            matrices.method_22909();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders()) {
                for (class_364 element : this.method_25396()) {
                    if (!(element instanceof CustomHoverState)) continue;
                    CustomHoverState hover = (CustomHoverState)element;
                    hover.updateHoveredState(mouseX, mouseY);
                }
            }
        }
    }

    void enlargeScreenshot(ScreenshotImageHolder showing) {
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotWidget widget) {
        this.screenshotProperties.show((int)mouseX, (int)mouseY, () -> this.list.removeEntry(widget), widget.getScreenshotFile(), widget::updateScreenshotFile);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25404(keyCode, scanCode, modifiers);
        }
        this.isCtrlDown = keyCode == 341 || keyCode == 345;
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.isCtrlDown) {
            this.isCtrlDown = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25400(chr, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25401(mouseX, mouseY, amount);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25401(mouseX, mouseY, amount);
        }
        if (this.list != null) {
            if (this.isCtrlDown) {
                this.list.updateScreenshotsPerRow(amount);
                return true;
            }
            return this.list.method_25401(mouseX, mouseY, amount);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25402(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25406(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_19355(mouseX, mouseY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_19355(mouseX, mouseY);
        }
        return super.method_19355(mouseX, mouseY);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25432() {
        this.list.close();
    }

    public void configUpdated() {
        this.list.onConfigUpdate();
    }

    private static class ExtendedTexturedButtonWidget
    extends class_344
    implements CustomHoverState {
        @Nullable
        private final class_2960 texture;
        private final int u;
        private final int v;
        private final int hoveredVOffset;
        private final int textureWidth;
        private final int textureHeight;

        ExtendedTexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, @Nullable class_2960 texture, int textureWidth, int textureHeight, class_4185.class_4241 pressAction, class_4185.class_5316 tooltipSupplier, class_2561 text) {
            super(x, y, width, height, u, v, hoveredVOffset, class_4185.field_22757, textureWidth, textureHeight, pressAction, tooltipSupplier, text);
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.u = u;
            this.v = v;
            this.hoveredVOffset = hoveredVOffset;
            this.texture = texture;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            this.method_25359(matrices, mouseX, mouseY, delta);
        }

        @Nullable
        public class_2960 getTexture() {
            return this.texture;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_2960 texture = this.getTexture();
            if (texture == null) {
                class_332.method_25294((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)0xFFFFFF);
            } else {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)texture);
                int vOffset = this.v;
                if (!this.method_37303()) {
                    vOffset += this.hoveredVOffset * 2;
                } else if (this.method_25367()) {
                    vOffset += this.hoveredVOffset;
                }
                RenderSystem.enableDepthTest();
                class_332.method_25290((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (float)this.u, (float)vOffset, (int)this.field_22758, (int)this.field_22759, (int)this.textureWidth, (int)this.textureHeight);
                if (this.field_22762) {
                    this.method_25352(matrices, mouseX, mouseY);
                }
            }
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
        }
    }

    private static final class ExtendedButtonWidget
    extends class_4185
    implements CustomHoverState {
        ExtendedButtonWidget(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            this.method_25359(matrices, mouseX, mouseY, delta);
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
        }
    }

    private static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }
}

