/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScreenshotPropertiesMenu
extends AbstractContainerEventHandler
implements Widget {
    private static final int BUTTON_SIZE = 19;
    private final Supplier<Minecraft> mcSupplier;
    private final IntSupplier parentWidth;
    private final IntSupplier parentHeight;
    private final List<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
    private int x;
    private int y;
    private int width;
    private int height;
    @NotNull
    private String fileName = "";
    private boolean shouldRender;
    @Nullable
    private Screen childScreen;

    ScreenshotPropertiesMenu(Supplier<Minecraft> mcSupplier, IntSupplier parentWidth, IntSupplier parentHeight) {
        this.mcSupplier = mcSupplier;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
    }

    void tick() {
        if (this.childScreen != null) {
            this.childScreen.m_86600_();
        }
    }

    void show(int x, int y, Runnable remover, File screenshotFile, Consumer<File> fileUpdater) {
        this.buttons.clear();
        this.fileName = screenshotFile.getName();
        int spacing = 2;
        BooleanConsumer deleteAction = value -> {
            if (value) {
                if (screenshotFile.exists() && !screenshotFile.delete()) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to delete 'screenshot' file at location '{}'", (Object)screenshotFile.toPath().toAbsolutePath());
                    return;
                }
                remover.run();
            }
            this.hide();
        };
        List<Triple> buttonInfo = List.of(Triple.of((Object)0, (Object)ScreenshotViewer.translatable("screen", "button.delete_screenshot"), btn -> {
            if (((Boolean)ManageScreenshotsScreen.CONFIG.promptWhenDeletingScreenshot.get()).booleanValue()) {
                this.childScreen = new ConfirmScreen(deleteAction, screenshotFile.getName());
                this.childScreen.m_6575_(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
            } else {
                deleteAction.accept(true);
            }
        }), Triple.of((Object)1, (Object)ScreenshotViewer.translatable("screen", "button.open_file"), btn -> Util.m_137581_().m_137644_(screenshotFile)), Triple.of((Object)3, (Object)ScreenshotViewer.translatable("screen", "button.rename_file"), btn -> {
            this.childScreen = new RenameScreen(this.fileName.substring(0, this.fileName.lastIndexOf(46)), s -> {
                try {
                    Path moved = Files.move(screenshotFile.toPath(), screenshotFile.toPath().resolveSibling((String)s), new CopyOption[0]);
                    fileUpdater.accept(moved.toFile());
                }
                catch (IOException e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to rename 'screenshot' file at '" + screenshotFile.toPath().toAbsolutePath() + "' from '" + screenshotFile.getName() + "' to '" + s + "'", (Throwable)e);
                }
            }, this::hide);
            this.childScreen.m_6575_(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
        }), Triple.of((Object)2, (Object)ScreenshotViewer.translatable("screen", "button.close_properties_menu"), btn -> this.hide()));
        Font font = this.mcSupplier.get().f_91062_;
        int largestTextWidth = buttonInfo.stream().map(Triple::getMiddle).mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0);
        this.width = 4 + Math.max(font.m_92895_(this.fileName), 19 + largestTextWidth + 2);
        Objects.requireNonNull(font);
        this.height = 6 + 9 + 19 * buttonInfo.size();
        this.x = x + this.width > this.parentWidth.getAsInt() ? x - this.width : x;
        this.y = y + this.height > this.parentHeight.getAsInt() ? y - this.height : y;
        for (int i = 0; i < buttonInfo.size(); ++i) {
            Triple pair = buttonInfo.get(i);
            Objects.requireNonNull(font);
            this.buttons.add((AbstractWidget)new Button(this.x + 2, this.y + 4 + 9 + 19 * i, 19 * (Integer)pair.getLeft(), 19, (Component)pair.getMiddle(), (Button.OnPress)pair.getRight()));
        }
        this.shouldRender = true;
    }

    void hide() {
        this.buttons.clear();
        this.shouldRender = false;
        this.childScreen = null;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
        this.fileName = "";
    }

    boolean renders() {
        return this.shouldRender;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.shouldRender) {
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 1.0);
            if (this.childScreen == null) {
                int spacing = 2;
                ScreenshotPropertiesMenu.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-12434878);
                this.mcSupplier.get().f_91062_.m_92750_(matrices, this.fileName, (float)(this.x + 2), (float)(this.y + 2), -1);
                for (AbstractWidget widget : this.buttons) {
                    widget.m_6305_(matrices, mouseX, mouseY, delta);
                    this.mcSupplier.get().f_91062_.m_92763_(matrices, widget.m_6035_(), (float)(widget.f_93620_ + widget.m_5711_() + 2), (float)widget.f_93621_ + (float)(widget.m_93694_() - 9) / 2.0f + 2.0f, -1);
                }
            } else {
                this.childScreen.m_6305_(matrices, mouseX, mouseY, delta);
            }
            matrices.m_85849_();
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.buttons;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.childScreen != null) {
            return this.childScreen.m_6375_(mouseX, mouseY, button);
        }
        if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX > (double)(this.x + this.width) || mouseY > (double)(this.y + this.height)) {
            this.hide();
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.hide();
            return true;
        }
        if (this.childScreen instanceof RenameScreen) {
            return this.childScreen.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.childScreen instanceof RenameScreen) {
            return this.childScreen.m_5534_(chr, modifiers);
        }
        return super.m_5534_(chr, modifiers);
    }

    private static final class Button
    extends ImageButton {
        private static final ResourceLocation TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/screenshot_viewer_icons.png");
        private final int imgU;
        private final int imgV;

        public Button(int x, int y, int imgU, int imgV, Component title, Button.OnPress pressAction) {
            super(x, y, 19, 19, 0, 0, 0, f_93617_, 128, 128, pressAction, title);
            this.imgU = imgU;
            this.imgV = imgV;
        }

        public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_69482_();
            ImageButton.m_93133_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (float)(this.m_198029_() ? 19.0f : 38.0f), (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)128, (int)128);
            ImageButton.m_93133_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (float)this.imgU, (float)this.imgV, (int)this.f_93618_, (int)this.f_93619_, (int)128, (int)128);
        }
    }

    private static final class RenameScreen
    extends Screen {
        private final String previousName;
        private final Consumer<String> newNameConsumer;
        private final Runnable closeAction;
        private EditBox textField;
        private net.minecraft.client.gui.components.Button doneBtn;

        private RenameScreen(String previousName, Consumer<String> newNameConsumer, Runnable closeAction) {
            super(ScreenshotViewer.translatable("screen", "rename_screenshot"));
            this.previousName = previousName;
            this.newNameConsumer = newNameConsumer;
            this.closeAction = closeAction;
        }

        public void m_86600_() {
            if (this.textField != null) {
                this.textField.m_94120_();
            }
        }

        protected void m_7856_() {
            super.m_7856_();
            this.textField = new EditBox(this.f_96547_, (this.f_96543_ - 150) / 2, (this.f_96544_ - 20) / 2, 150, 20, ScreenshotViewer.translatable("screen", "field.screenshot_name"));
            this.textField.m_94199_(128);
            this.textField.m_94153_(RenameScreen::checkInvalidCharacters);
            this.doneBtn = new net.minecraft.client.gui.components.Button(this.f_96543_ / 2 - 4 - 150, this.f_96544_ / 2 + 50, 150, 20, CommonComponents.f_130655_, btn -> {
                this.newNameConsumer.accept(this.textField.m_94155_().trim().concat(".png"));
                this.closeAction.run();
            });
            this.doneBtn.f_93623_ = false;
            this.textField.m_94151_(s -> {
                this.doneBtn.f_93623_ = !s.isBlank() && !s.trim().equals(this.previousName) && !s.endsWith(".");
            });
            this.textField.m_94144_(this.previousName);
            this.m_142416_((GuiEventListener)this.textField);
            this.m_142416_((GuiEventListener)this.doneBtn);
            this.m_142416_((GuiEventListener)new net.minecraft.client.gui.components.Button(this.f_96543_ / 2 + 4, this.f_96544_ / 2 + 50, 150, 20, CommonComponents.f_130660_, btn -> this.closeAction.run()));
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            this.m_93179_(matrices, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            RenameScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 70), (int)0xFFFFFF);
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 && this.doneBtn != null && this.doneBtn.f_93623_) {
                this.doneBtn.m_5691_();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public void m_7379_() {
            this.closeAction.run();
        }

        private static boolean checkInvalidCharacters(String s) {
            return s.chars().noneMatch(c -> c == 92 || c == 47 || c == 58 || c == 42 || c == 63 || c == 34 || c == 60 || c == 62 || c == 124);
        }
    }

    private static final class ConfirmScreen
    extends net.minecraft.client.gui.screens.ConfirmScreen {
        public ConfirmScreen(BooleanConsumer callback, String fileName) {
            super(callback, (Component)Component.m_237110_((String)"screen.screenshot_viewer.delete_prompt", (Object[])new Object[]{fileName}), ScreenshotViewer.translatable("screen", "delete_prompt.message"));
        }

        public void m_96558_(PoseStack matrices, int vOffset) {
            this.m_93179_(matrices, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        }
    }
}

