/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_757;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScreenshotPropertiesMenu
extends class_362
implements class_4068 {
    private static final int BUTTON_SIZE = 19;
    private final Supplier<class_310> mcSupplier;
    private final IntSupplier parentWidth;
    private final IntSupplier parentHeight;
    private final List<class_339> buttons = new ArrayList<class_339>();
    private int x;
    private int y;
    private int width;
    private int height;
    @NotNull
    private String fileName = "";
    private boolean shouldRender;
    @Nullable
    private class_437 childScreen;

    ScreenshotPropertiesMenu(Supplier<class_310> mcSupplier, IntSupplier parentWidth, IntSupplier parentHeight) {
        this.mcSupplier = mcSupplier;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
    }

    void tick() {
        if (this.childScreen != null) {
            this.childScreen.method_25393();
        }
    }

    void show(int x, int y, Runnable remover, File screenshotFile, Consumer<File> fileUpdater) {
        this.buttons.clear();
        this.fileName = screenshotFile.getName();
        int spacing = 2;
        BooleanConsumer deleteAction = value -> {
            if (value) {
                if (screenshotFile.exists() && !screenshotFile.delete()) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to delete 'screenshot' file at location '{}'", (Object)screenshotFile.toPath().toAbsolutePath());
                    return;
                }
                remover.run();
            }
            this.hide();
        };
        List<Triple> buttonInfo = List.of(Triple.of((Object)0, (Object)ScreenshotViewer.translatable("screen", "button.delete_screenshot"), btn -> {
            if (((Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.PROMPT_WHEN_DELETING_SCREENSHOT, (Object)true)).booleanValue()) {
                this.childScreen = new ConfirmScreen(deleteAction, screenshotFile.getName());
                this.childScreen.method_25423(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
            } else {
                deleteAction.accept(true);
            }
        }), Triple.of((Object)1, (Object)ScreenshotViewer.translatable("screen", "button.open_file"), btn -> class_156.method_668().method_672(screenshotFile)), Triple.of((Object)3, (Object)ScreenshotViewer.translatable("screen", "button.rename_file"), btn -> {
            this.childScreen = new RenameScreen(this.fileName.substring(0, this.fileName.lastIndexOf(46)), s -> {
                try {
                    Path moved = Files.move(screenshotFile.toPath(), screenshotFile.toPath().resolveSibling((String)s), new CopyOption[0]);
                    fileUpdater.accept(moved.toFile());
                }
                catch (IOException e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to rename 'screenshot' file at '" + screenshotFile.toPath().toAbsolutePath() + "' from '" + screenshotFile.getName() + "' to '" + s + "'", (Throwable)e);
                }
            }, this::hide);
            this.childScreen.method_25423(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
        }), Triple.of((Object)2, (Object)ScreenshotViewer.translatable("screen", "button.close_properties_menu"), btn -> this.hide()));
        class_327 font = this.mcSupplier.get().field_1772;
        int largestTextWidth = buttonInfo.stream().map(Triple::getMiddle).mapToInt(arg_0 -> ((class_327)font).method_27525(arg_0)).max().orElse(0);
        this.width = 4 + Math.max(font.method_1727(this.fileName), 19 + largestTextWidth + 2);
        Objects.requireNonNull(font);
        this.height = 6 + 9 + 19 * buttonInfo.size();
        this.x = x + this.width > this.parentWidth.getAsInt() ? x - this.width : x;
        this.y = y + this.height > this.parentHeight.getAsInt() ? y - this.height : y;
        for (int i = 0; i < buttonInfo.size(); ++i) {
            Triple pair = buttonInfo.get(i);
            Objects.requireNonNull(font);
            this.buttons.add((class_339)new Button(this.x + 2, this.y + 4 + 9 + 19 * i, 19 * (Integer)pair.getLeft(), 19, (class_2561)pair.getMiddle(), (class_4185.class_4241)pair.getRight()));
        }
        this.shouldRender = true;
    }

    void hide() {
        this.buttons.clear();
        this.shouldRender = false;
        this.childScreen = null;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
        this.fileName = "";
    }

    boolean renders() {
        return this.shouldRender;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.shouldRender) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 1.0f);
            if (this.childScreen == null) {
                int spacing = 2;
                ScreenshotPropertiesMenu.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-12434878);
                this.mcSupplier.get().field_1772.method_1720(matrices, this.fileName, (float)(this.x + 2), (float)(this.y + 2), -1);
                for (class_339 widget : this.buttons) {
                    widget.method_25394(matrices, mouseX, mouseY, delta);
                    this.mcSupplier.get().field_1772.method_30881(matrices, widget.method_25369(), (float)(widget.method_46426() + widget.method_25368() + 2), (float)widget.method_46427() + (float)(widget.method_25364() - 9) / 2.0f + 2.0f, -1);
                }
            } else {
                this.childScreen.method_25394(matrices, mouseX, mouseY, delta);
            }
            matrices.method_22909();
        }
    }

    public List<? extends class_364> method_25396() {
        return this.buttons;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.childScreen != null) {
            return this.childScreen.method_25402(mouseX, mouseY, button);
        }
        if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX > (double)(this.x + this.width) || mouseY > (double)(this.y + this.height)) {
            this.hide();
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.hide();
            return true;
        }
        if (this.childScreen instanceof RenameScreen) {
            return this.childScreen.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.childScreen instanceof RenameScreen) {
            return this.childScreen.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    private static final class Button
    extends class_344 {
        private static final class_2960 TEXTURE = new class_2960("screenshot_viewer", "textures/gui/screenshot_viewer_icons.png");
        private final int imgU;
        private final int imgV;

        public Button(int x, int y, int imgU, int imgV, class_2561 title, class_4185.class_4241 pressAction) {
            super(x, y, 19, 19, 0, 0, 0, class_4185.field_22757, 128, 128, pressAction, title);
            this.imgU = imgU;
            this.imgV = imgV;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            RenderSystem.enableDepthTest();
            class_344.method_25290((class_4587)matrices, (int)this.method_46426(), (int)this.method_46427(), (float)(this.method_25367() ? 19.0f : 38.0f), (float)0.0f, (int)this.field_22758, (int)this.field_22759, (int)128, (int)128);
            class_344.method_25290((class_4587)matrices, (int)this.method_46426(), (int)this.method_46427(), (float)this.imgU, (float)this.imgV, (int)this.field_22758, (int)this.field_22759, (int)128, (int)128);
        }
    }

    private static final class RenameScreen
    extends class_437 {
        private final String previousName;
        private final Consumer<String> newNameConsumer;
        private final Runnable closeAction;
        private class_342 textField;
        private class_4185 doneBtn;

        private RenameScreen(String previousName, Consumer<String> newNameConsumer, Runnable closeAction) {
            super(ScreenshotViewer.translatable("screen", "rename_screenshot"));
            this.previousName = previousName;
            this.newNameConsumer = newNameConsumer;
            this.closeAction = closeAction;
        }

        public void method_25393() {
            if (this.textField != null) {
                this.textField.method_1865();
            }
        }

        protected void method_25426() {
            super.method_25426();
            this.textField = new class_342(this.field_22793, (this.field_22789 - 150) / 2, (this.field_22790 - 20) / 2, 150, 20, ScreenshotViewer.translatable("screen", "field.screenshot_name"));
            this.textField.method_1880(128);
            this.textField.method_1890(RenameScreen::checkInvalidCharacters);
            this.doneBtn = class_4185.method_46430((class_2561)class_5244.field_24334, btn -> {
                this.newNameConsumer.accept(this.textField.method_1882().trim().concat(".png"));
                this.closeAction.run();
            }).method_46433(this.field_22789 / 2 - 4 - 150, this.field_22790 / 2 + 50).method_46431();
            this.doneBtn.field_22763 = false;
            this.textField.method_1863(s -> {
                this.doneBtn.field_22763 = !s.isBlank() && !s.trim().equals(this.previousName) && !s.endsWith(".");
            });
            this.textField.method_1852(this.previousName);
            this.method_37063((class_364)this.textField);
            this.method_37063((class_364)this.doneBtn);
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, btn -> this.closeAction.run()).method_46433(this.field_22789 / 2 + 4, this.field_22790 / 2 + 50).method_46431());
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            RenameScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 - 70), (int)0xFFFFFF);
            super.method_25394(matrices, mouseX, mouseY, delta);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 && this.doneBtn != null && this.doneBtn.field_22763) {
                this.doneBtn.method_25306();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void method_25419() {
            this.closeAction.run();
        }

        private static boolean checkInvalidCharacters(String s) {
            return s.chars().noneMatch(c -> c == 92 || c == 47 || c == 58 || c == 42 || c == 63 || c == 34 || c == 60 || c == 62 || c == 124);
        }
    }

    private static final class ConfirmScreen
    extends class_410 {
        public ConfirmScreen(BooleanConsumer callback, String fileName) {
            super(callback, (class_2561)class_2561.method_43469((String)"screen.screenshot_viewer.delete_prompt", (Object[])new Object[]{fileName}), ScreenshotViewer.translatable("screen", "delete_prompt.message"));
        }

        public void method_25433(class_4587 matrices, int vOffset) {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        }
    }
}

