/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

final class ScreenshotWidget
extends AbstractWidget
implements AutoCloseable,
ScreenshotImageHolder {
    private final ManageScreenshotsScreen mainScreen;
    private final Minecraft client;
    private final Context ctx;
    private File screenshotFile;
    private CompletableFuture<NativeImage> image;
    @Nullable
    private DynamicTexture texture;
    private float bgOpacity = 0.0f;
    private int baseY;

    public ScreenshotWidget(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height, Context ctx, File screenshotFile) {
        super(x, y, width, height, (Component)Component.m_237113_((String)screenshotFile.getName()));
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.baseY = y;
        this.ctx = ctx;
        this.screenshotFile = screenshotFile;
        this.image = this.getImage(screenshotFile);
    }

    void updateBaseY(int baseY) {
        this.baseY = baseY;
        this.m_252888_(this.baseY);
    }

    void updateY(int scrollY) {
        this.m_252888_(this.baseY - scrollY);
    }

    void updateScreenshotFile(File screenshotFile) {
        this.screenshotFile = screenshotFile;
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.texture = null;
        this.image = this.getImage(screenshotFile);
    }

    File getScreenshotFile() {
        return this.screenshotFile;
    }

    void updateHoverState(int mouseX, int mouseY, int viewportY, int viewportBottom, boolean updateHoverState) {
        this.f_93622_ = updateHoverState && mouseX >= this.m_252754_() && mouseY >= Math.max(this.m_252907_(), viewportY) && mouseX < this.m_252754_() + this.f_93618_ && mouseY < Math.min(this.m_252907_() + this.f_93619_, viewportBottom);
        int maxOpacity = (Integer)ManageScreenshotsScreen.CONFIG.screenshotElementBackgroundOpacity.get();
        if (maxOpacity > 0 && this.f_93622_) {
            if (this.bgOpacity < (float)maxOpacity / 100.0f) {
                this.bgOpacity = Math.min((float)maxOpacity / 100.0f, this.bgOpacity + 0.05f);
            }
        } else if (this.bgOpacity > 0.0f) {
            this.bgOpacity = Math.max(0.0f, this.bgOpacity - 0.05f);
        }
    }

    void render(PoseStack matrices, int mouseX, int mouseY, float delta, int viewportY, int viewportBottom) {
        this.renderBackground(matrices, mouseX, mouseY, viewportY, viewportBottom);
        int spacing = 2;
        DynamicTexture image = this.texture();
        if (image != null && image.m_117991_() != null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157453_((int)0, (int)image.m_117963_());
            RenderSystem.m_69478_();
            int renderY = Math.max(this.m_252907_() + 2, viewportY);
            int imgHeight = (int)((double)this.f_93619_ / 1.08 - 6.0);
            int topOffset = Math.max(0, viewportY - this.m_252907_() - 2);
            int bottomOffset = Math.max(0, this.m_252907_() + 2 + imgHeight - viewportBottom);
            int topV = topOffset * image.m_117991_().m_85084_() / imgHeight;
            int bottomV = bottomOffset * image.m_117991_().m_85084_() / imgHeight;
            GuiComponent.m_93160_((PoseStack)matrices, (int)(this.m_252754_() + 2), (int)renderY, (int)(this.f_93618_ - 4), (int)(imgHeight - topOffset - bottomOffset), (float)0.0f, (float)topV, (int)image.m_117991_().m_84982_(), (int)(image.m_117991_().m_85084_() - topV - bottomV), (int)image.m_117991_().m_84982_(), (int)image.m_117991_().m_85084_());
            RenderSystem.m_69461_();
        }
        float scaleFactor = (float)(this.client.m_91268_().m_85446_() / 96) / (float)this.ctx.screenshotsPerRow();
        int textY = this.m_252907_() + (int)((double)this.f_93619_ / 1.08) - 2;
        if (textY > viewportY) {
            float f = textY;
            Objects.requireNonNull(this.client.f_91062_);
            if (f + scaleFactor * 9.0f < (float)viewportBottom) {
                matrices.m_85836_();
                matrices.m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)textY, 0.0f);
                matrices.m_85841_(scaleFactor, scaleFactor, scaleFactor);
                Component message = this.m_6035_();
                float centerX = -this.client.f_91062_.m_92852_((FormattedText)this.m_6035_()) / 2;
                int textColor = Optional.ofNullable(TextColor.m_131268_((String)((String)ManageScreenshotsScreen.CONFIG.screenshotElementTextColor.get()))).map(TextColor::m_131265_).orElse(0xFFFFFF);
                if (((Boolean)ManageScreenshotsScreen.CONFIG.renderScreenshotElementFontShadow.get()).booleanValue()) {
                    this.client.f_91062_.m_92763_(matrices, message, centerX, 0.0f, textColor);
                } else {
                    this.client.f_91062_.m_92889_(matrices, message, centerX, 0.0f, textColor);
                }
                matrices.m_85849_();
            }
        }
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
    }

    private void renderBackground(PoseStack matrices, int mouseX, int mouseY, int viewportY, int viewportBottom) {
        int renderY = Math.max(this.m_252907_(), viewportY);
        int renderHeight = Math.min(this.m_252907_() + this.f_93619_, viewportBottom);
        GuiComponent.m_93172_((PoseStack)matrices, (int)this.m_252754_(), (int)renderY, (int)(this.m_252754_() + this.f_93618_), (int)renderHeight, (int)FastColor.ARGB32.m_13660_((int)((int)(this.bgOpacity * 255.0f)), (int)255, (int)255, (int)255));
    }

    private void onClick() {
        this.mainScreen.enlargeScreenshot(this);
    }

    private void onRightClick(double mouseX, double mouseY) {
        this.mainScreen.showScreenshotProperties(mouseX, mouseY, this);
    }

    private CompletableFuture<NativeImage> getImage(File file) {
        return CompletableFuture.supplyAsync(() -> {
            NativeImage nativeImage;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to load screenshot: {}", (Object)file.getName(), (Object)e);
                    return null;
                }
            }
            ((InputStream)inputStream).close();
            return nativeImage;
        }, Util.m_183991_());
    }

    @Nullable
    public DynamicTexture texture() {
        if (this.texture != null) {
            return this.texture;
        }
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        if (this.image.isDone()) {
            this.texture = new DynamicTexture(this.image.join());
            return this.texture;
        }
        return null;
    }

    @Override
    public int indexInList() {
        return this.ctx.currentIndex(this);
    }

    @Override
    public int imageId() {
        DynamicTexture texture = this.texture();
        return texture != null ? texture.m_117963_() : 0;
    }

    @Override
    @Nullable
    public NativeImage image() {
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        return this.image.getNow(null);
    }

    public Component m_6035_() {
        return this.screenshotFile == null ? super.m_6035_() : Component.m_237113_((String)this.screenshotFile.getName());
    }

    public void m_7435_(SoundManager soundManager) {
        soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_198029_()) {
            this.m_7435_(this.client.m_91106_());
            if (button == 0) {
                this.onClick();
            }
            if (button == 1) {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return false;
    }

    public boolean m_198029_() {
        return this.f_93622_;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.m_198029_();
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.image = null;
        this.texture = null;
    }

    static interface Context {
        public int screenshotsPerRow();

        public int currentIndex(ScreenshotWidget var1);

        public static Context create(final IntSupplier screenshotsPerRow, final ToIntFunction<ScreenshotWidget> currentIndex) {
            return new Context(){

                @Override
                public int screenshotsPerRow() {
                    return screenshotsPerRow.getAsInt();
                }

                @Override
                public int currentIndex(ScreenshotWidget widget) {
                    return currentIndex.applyAsInt(widget);
                }
            };
        }
    }
}

