/*
 * Decompiled with CFR 0.152.
 */
package me.ethius.viewmodel.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import me.ethius.viewmodel.Viewmodel;
import me.ethius.viewmodel.config.SaveConfig;
import me.ethius.viewmodel.settings.BooleanSetting;
import me.ethius.viewmodel.settings.FloatSetting;
import me.ethius.viewmodel.settings.Setting;

public class LoadConfig {
    public static String folderName = SaveConfig.folderName;

    public LoadConfig() {
        try {
            this.loadAllSettings();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllSettings() throws IOException {
        try (InputStreamReader inputStreamReader = null;){
            if (!Files.exists(Paths.get(folderName + "Viewmodel.json", new String[0]), new LinkOption[0])) {
                return;
            }
            InputStream inputStream = Files.newInputStream(Paths.get(folderName + "Viewmodel.json", new String[0]), new OpenOption[0]);
            inputStreamReader = new InputStreamReader(inputStream);
            JsonObject viewmodelObj = new JsonParser().parse((Reader)inputStreamReader).getAsJsonObject();
            for (Setting<?> value : Viewmodel.SETTINGS) {
                JsonElement valueElement = viewmodelObj.get(value.getName());
                if (valueElement == null) continue;
                if (value instanceof BooleanSetting) {
                    value.setValue(valueElement.getAsBoolean());
                    continue;
                }
                if (!(value instanceof FloatSetting)) continue;
                value.setValue(Float.valueOf(valueElement.getAsFloat()));
            }
            inputStream.close();
        }
    }
}

