/*
 * Decompiled with CFR 0.152.
 */
package me.ethius.viewmodel.gui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.ethius.viewmodel.Viewmodel;
import me.ethius.viewmodel.settings.BooleanSetting;
import me.ethius.viewmodel.settings.FloatSetting;
import me.ethius.viewmodel.settings.Setting;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ViewmodelScreen
extends class_437 {
    final class_310 mc = class_310.method_1551();
    final List<ViewmodelGuiObj> objs = new ArrayList<ViewmodelGuiObj>();

    public ViewmodelScreen() {
        super(class_2561.method_30163((String)"Viewmodel"));
    }

    public void method_25426() {
        int settingCount = 0;
        for (Setting<?> setting : Viewmodel.SETTINGS) {
            ++settingCount;
            if (setting instanceof BooleanSetting) {
                this.objs.add(new Switch((BooleanSetting)setting, 80, 50 + settingCount * 16, 12));
                continue;
            }
            if (!(setting instanceof FloatSetting)) continue;
            this.objs.add(new Slider((FloatSetting)setting, 80, 50 + settingCount * 16, 80, 12));
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrices);
        for (ViewmodelGuiObj obj : this.objs) {
            obj.render(matrices, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (ViewmodelGuiObj obj : this.objs) {
            if (!obj.isWithin(mouseX, mouseY)) continue;
            obj.mouseClicked(mouseX, mouseY);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double multiplier) {
        for (ViewmodelGuiObj obj : this.objs) {
            if (!obj.isWithin(mouseX, mouseY)) continue;
            obj.mouseScrolled(mouseX, mouseY, (float)multiplier);
        }
        return super.method_25401(mouseX, mouseY, multiplier);
    }

    public float round(float value, int places) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.floatValue();
    }

    class Switch
    implements ViewmodelGuiObj {
        private final BooleanSetting setting;
        private final int x;
        private final int y;
        private final int height;

        public Switch(BooleanSetting setting, int x, int y, int height) {
            this.setting = setting;
            this.x = x;
            this.y = y;
            this.height = height;
        }

        @Override
        public void mouseScrolled(double mx, double my, float inc) {
        }

        @Override
        public void mouseClicked(double mx, double my) {
            this.setting.setValue(this.setting.getValue() == false);
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY) {
            class_327 class_3272 = ViewmodelScreen.this.mc.field_1772;
            String string = this.setting.getName();
            float f = this.x - ViewmodelScreen.this.mc.field_1772.method_1727(this.setting.getName()) - 1;
            float f2 = (float)this.y + (float)this.height / 2.0f;
            Objects.requireNonNull(ViewmodelScreen.this.mc.field_1772);
            class_3272.method_1720(matrices, string, f, f2 - 9.0f / 2.0f, -1);
            class_332.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.height * 2), (int)(this.y + this.height), (int)-2028990448);
            if (this.setting.getValue().booleanValue()) {
                class_332.method_25294((class_4587)matrices, (int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.height - 1), (int)(this.y + this.height - 1), (int)-1);
            } else {
                class_332.method_25294((class_4587)matrices, (int)(this.x + this.height + 1), (int)(this.y + 1), (int)(this.x + this.height * 2 - 1), (int)(this.y + this.height - 1), (int)-1);
            }
            class_327 class_3273 = ViewmodelScreen.this.mc.field_1772;
            String string2 = this.setting.getValue().toString();
            float f3 = this.x + this.height * 2 + 1;
            float f4 = (float)this.y + (float)this.height / 2.0f;
            Objects.requireNonNull(ViewmodelScreen.this.mc.field_1772);
            class_3273.method_1720(matrices, string2, f3, f4 - 9.0f / 2.0f, -1);
        }

        @Override
        public boolean isWithin(double mouseX, double mouseY) {
            return mouseX > (double)this.x && mouseY > (double)this.y && mouseX < (double)(this.x + this.height * 2) && mouseY < (double)(this.y + this.height);
        }
    }

    class Slider
    implements ViewmodelGuiObj {
        private final FloatSetting setting;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final float min;
        private final float max;

        public Slider(FloatSetting setting, int x, int y, int width, int height) {
            this.setting = setting;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.min = setting.min;
            this.max = setting.max;
        }

        @Override
        public void mouseScrolled(double mx, double my, float inc) {
            this.setting.setValue(class_3532.method_15363((float)(this.setting.getValue().floatValue() + inc * 0.1f), (float)this.min, (float)this.max));
        }

        @Override
        public void mouseClicked(double mx, double my) {
            this.setting.setValue(this.min + (float)((double)((this.max - this.min) / (float)this.width) * (mx - (double)this.x)));
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY) {
            class_327 class_3272 = ViewmodelScreen.this.mc.field_1772;
            String string = this.setting.getName();
            float f = this.x - ViewmodelScreen.this.mc.field_1772.method_1727(this.setting.getName()) - 1;
            float f2 = (float)this.y + (float)this.height / 2.0f;
            Objects.requireNonNull(ViewmodelScreen.this.mc.field_1772);
            class_3272.method_1720(matrices, string, f, f2 - 9.0f / 2.0f, -1);
            class_332.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)((int)((float)this.x + (this.setting.getValue().floatValue() - this.min) / (this.max - this.min) * (float)this.width)), (int)(this.y + this.height), (int)-1);
            class_327 class_3273 = ViewmodelScreen.this.mc.field_1772;
            String string2 = "" + ViewmodelScreen.this.round(this.setting.getValue().floatValue(), 1);
            float f3 = this.x + this.width + 1;
            float f4 = (float)this.y + (float)this.height / 2.0f;
            Objects.requireNonNull(ViewmodelScreen.this.mc.field_1772);
            class_3273.method_1720(matrices, string2, f3, f4 - 9.0f / 2.0f, -1);
        }

        @Override
        public boolean isWithin(double mouseX, double mouseY) {
            return mouseX > (double)this.x && mouseY > (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
        }
    }

    static interface ViewmodelGuiObj {
        public void mouseScrolled(double var1, double var3, float var5);

        public void mouseClicked(double var1, double var3);

        public void render(class_4587 var1, int var2, int var3);

        public boolean isWithin(double var1, double var3);
    }
}

