/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;

public class BrazierBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0));
    protected static final VoxelShape HANGING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final int fireDamage;

    public BrazierBlock(int fireDamage, BlockBehaviour.Properties properties) {
        super(properties);
        this.fireDamage = fireDamage;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPE : SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(DamageSource.f_19305_, (float)this.fireDamage);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemStack = player.m_21120_(hand);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && itemStack.canPerformAction(ToolActions.SHOVEL_FLATTEN)) {
            level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223717_((Entity)player));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            itemStack.m_41622_(1, (LivingEntity)player, levelHand -> levelHand.m_21190_(hand));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && itemStack.m_150930_(Items.f_42409_)) {
            level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223717_((Entity)player));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            itemStack.m_41622_(1, (LivingEntity)player, levelHand -> levelHand.m_21190_(hand));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && itemStack.m_150930_(Items.f_42613_)) {
            level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223717_((Entity)player));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && source.m_188503_(10) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + source.m_188501_(), source.m_188501_() * 0.7f + 0.6f, false);
        }
    }

    public boolean m_7361_(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            boolean flag = (Boolean)state.m_61143_((Property)LIT);
            if (flag && !accessor.m_5776_()) {
                accessor.m_5594_((Player)null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            accessor.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            accessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)accessor));
            return true;
        }
        return false;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        BlockPos blockpos = result.m_82425_();
        if (!level.f_46443_ && projectile.m_6060_() && projectile.m_142265_(level, blockpos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_7731_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction direction = BrazierBlock.getConnectedDirection(state).m_122424_();
        return Block.m_49863_((LevelReader)reader, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState altstate, LevelAccessor accessor, BlockPos pos, BlockPos altpos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return BrazierBlock.getConnectedDirection(state).m_122424_() == direction && !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, altstate, accessor, pos, altpos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED, HANGING});
    }
}

