/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.sheddmer.abundant_atmosphere.init.AABlocks;

public class CaveFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public CaveFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState altstate, LevelAccessor accessor, BlockPos pos, BlockPos altpos) {
        if (direction == Direction.UP && !state.m_60710_((LevelReader)accessor, pos)) {
            accessor.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, altstate, accessor, pos, altpos);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        BlockState blockstate = reader.m_8055_(pos.m_7494_());
        return !blockstate.m_60767_().m_76333_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)AABlocks.CAVE_SOIL.get()).m_49966_() : super.m_5573_(context);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            CaveFarmlandBlock.turnToDirt(state, (Level)level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        int i = (Integer)state.m_61143_((Property)MOISTURE);
        if (!CaveFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!CaveFarmlandBlock.isUnderCrops((BlockGetter)level, pos)) {
                CaveFarmlandBlock.turnToDirt(state, (Level)level, pos);
            }
        } else if (i < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float trample) {
        if (!level.f_46443_ && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)((Block)AABlocks.CAVE_SOIL.get()).m_49966_(), (float)trample, (Entity)entity)) {
            CaveFarmlandBlock.turnToDirt(state, level, pos);
        }
        super.m_142072_(level, state, pos, entity, trample);
    }

    public static void turnToDirt(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, CaveFarmlandBlock.m_49897_((BlockState)state, (BlockState)((Block)AABlocks.CAVE_SOIL.get()).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
    }

    private static boolean isUnderCrops(BlockGetter getter, BlockPos pos) {
        BlockState plant = getter.m_8055_(pos.m_7494_());
        BlockState state = getter.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(getter, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader reader, BlockPos pos) {
        BlockState state = reader.m_8055_(pos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)reader, pos, reader.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)reader, (BlockPos)pos);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }
}

