/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.sheddmer.abundant_atmosphere.AbundantAtmosphere;
import net.sheddmer.abundant_atmosphere.init.AABlocks;
import net.sheddmer.abundant_atmosphere.init.AATags;

public class MudPotBlock
extends Block
implements Fallable {
    public static final EnumProperty POT_SEGMENT = EnumProperty.m_61587_((String)"pot_segment", PotSegment.class);
    private static final VoxelShape POT = Shapes.m_83124_((VoxelShape)MudPotBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{MudPotBlock.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), MudPotBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0)});
    private static final VoxelShape POT_TOP = Shapes.m_83110_((VoxelShape)MudPotBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape)MudPotBlock.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static final VoxelShape POT_MIDDLE = MudPotBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape POT_LOWER = Shapes.m_83110_((VoxelShape)MudPotBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)MudPotBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0));

    public MudPotBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POT_SEGMENT, (Comparable)((Object)PotSegment.FULL)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((PotSegment)((Object)pState.m_61143_((Property)POT_SEGMENT))) {
            case FULL: {
                return POT;
            }
            case TOP: {
                return POT_TOP;
            }
            case MIDDLE: {
                return POT_MIDDLE;
            }
            case BOTTOM: {
                return POT_LOWER;
            }
        }
        return POT;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        if (pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_()).m_204336_(AATags.MUD_POTS)) {
            return (BlockState)this.m_49966_().m_61124_((Property)POT_SEGMENT, (Comparable)((Object)PotSegment.TOP));
        }
        if (!pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_()).m_60659_((BlockGetter)pContext.m_43725_(), pContext.m_8083_(), Direction.UP, SupportType.CENTER)) {
            if (!pContext.m_43725_().m_5776_()) {
                AbundantAtmosphere.LOGGER.info("fall");
                pContext.m_43725_().m_186460_(pContext.m_8083_(), (Block)AABlocks.MUD_POT.get(), 1);
            }
        } else if (!pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_()).m_60659_((BlockGetter)pContext.m_43725_(), pContext.m_8083_(), Direction.UP, SupportType.CENTER)) {
            if (!pContext.m_43725_().m_5776_()) {
                AbundantAtmosphere.LOGGER.info("fall");
                pContext.m_43725_().m_186460_(pContext.m_8083_(), (Block)AABlocks.CARVED_MUD_POT.get(), 1);
            }
        } else if (!pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_()).m_60659_((BlockGetter)pContext.m_43725_(), pContext.m_8083_(), Direction.UP, SupportType.CENTER) && !pContext.m_43725_().m_5776_()) {
            AbundantAtmosphere.LOGGER.info("fall");
            pContext.m_43725_().m_186460_(pContext.m_8083_(), (Block)AABlocks.CRACKED_MUD_POT.get(), 1);
        }
        return (BlockState)this.m_49966_().m_61124_((Property)POT_SEGMENT, (Comparable)((Object)PotSegment.FULL));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState aboveState;
        super.m_213897_(pState, pLevel, pPos, pRandom);
        BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
        if (MudPotBlock.shouldFall(pLevel, pPos, pState, belowState)) {
            MudPotBlock.spawnFallingPot(pState, pLevel, pPos);
        }
        if (!MudPotBlock.validPotPlacement(pLevel, pPos, pState, belowState, aboveState = pLevel.m_8055_(pPos.m_7494_()))) {
            BlockState blockstate;
            boolean updateBelow;
            pLevel.m_46961_(pPos, true);
            BlockPos.MutableBlockPos position = pPos.m_122032_();
            boolean updateAbove = pState.m_61143_((Property)POT_SEGMENT) == PotSegment.BOTTOM || pState.m_61143_((Property)POT_SEGMENT) == PotSegment.MIDDLE;
            boolean bl = updateBelow = pState.m_61143_((Property)POT_SEGMENT) == PotSegment.TOP || pState.m_61143_((Property)POT_SEGMENT) == PotSegment.MIDDLE;
            if (updateAbove) {
                blockstate = pState;
                while (MudPotBlock.isPot(blockstate)) {
                    pLevel.m_46961_((BlockPos)position, true);
                    if (MudPotBlock.isTop(blockstate)) break;
                    position.m_122173_(Direction.UP);
                    blockstate = pLevel.m_8055_((BlockPos)position);
                }
            }
            if (updateBelow) {
                position.m_122190_((Vec3i)(pState.m_61143_((Property)POT_SEGMENT) == PotSegment.MIDDLE ? pPos.m_7495_() : pPos));
                blockstate = pState;
                while (MudPotBlock.isPot(blockstate)) {
                    pLevel.m_46961_((BlockPos)position, true);
                    if (MudPotBlock.isBottom(blockstate)) break;
                    position.m_122173_(Direction.DOWN);
                    blockstate = pLevel.m_8055_((BlockPos)position);
                }
            }
        }
    }

    private static boolean validPotPlacement(ServerLevel level, BlockPos pos, BlockState state, BlockState belowBlockState, BlockState aboveBlockState) {
        switch ((PotSegment)((Object)state.m_61143_((Property)POT_SEGMENT))) {
            case FULL: {
                return belowBlockState.m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.CENTER);
            }
            case TOP: {
                return MudPotBlock.isPot(belowBlockState);
            }
            case MIDDLE: {
                return MudPotBlock.isPot(belowBlockState) && MudPotBlock.isPot(aboveBlockState);
            }
            case BOTTOM: {
                return belowBlockState.m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.CENTER) && MudPotBlock.isPot(aboveBlockState);
            }
        }
        return true;
    }

    private static boolean shouldFall(ServerLevel level, BlockPos pos, BlockState state, BlockState belowBlockState) {
        return !belowBlockState.m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.CENTER) && MudPotBlock.isBottom(state);
    }

    private static void spawnFallingPot(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos position = pPos.m_122032_();
        BlockState blockstate = pState;
        while (MudPotBlock.isPot(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)position, (BlockState)blockstate);
            fallingblockentity.m_149656_(2.0f, 40);
            if (MudPotBlock.isTop(blockstate)) break;
            position.m_122173_(Direction.UP);
            blockstate = pLevel.m_8055_((BlockPos)position);
        }
    }

    public void m_48792_(Level pLevel, BlockPos pPos, BlockState pState, BlockState pReplaceableState, FallingBlockEntity pFallingBlock) {
        super.m_48792_(pLevel, pPos, pState, pReplaceableState, pFallingBlock);
        pLevel.m_46961_(pPos, true);
        pLevel.m_5594_(null, pPos, SoundEvents.f_11983_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    static boolean isBottom(BlockState state) {
        return state.m_61143_((Property)POT_SEGMENT) == PotSegment.FULL || state.m_61143_((Property)POT_SEGMENT) == PotSegment.BOTTOM;
    }

    static boolean isTop(BlockState state) {
        return state.m_61143_((Property)POT_SEGMENT) == PotSegment.FULL || state.m_61143_((Property)POT_SEGMENT) == PotSegment.TOP;
    }

    public static boolean isPot(BlockState state) {
        return state.m_60734_() instanceof MudPotBlock;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP && MudPotBlock.isPot(pNeighborState)) {
            if (MudPotBlock.isPot(pLevel.m_8055_(pCurrentPos.m_7495_()))) {
                return (BlockState)pState.m_61124_((Property)POT_SEGMENT, (Comparable)((Object)PotSegment.MIDDLE));
            }
            return (BlockState)pState.m_61124_((Property)POT_SEGMENT, (Comparable)((Object)PotSegment.BOTTOM));
        }
        if (pDirection == Direction.UP || pDirection == Direction.DOWN) {
            pLevel.m_186460_(pCurrentPos, (Block)AABlocks.MUD_POT.get(), 1);
        }
        if (pDirection == Direction.UP || pDirection == Direction.DOWN) {
            pLevel.m_186460_(pCurrentPos, (Block)AABlocks.CARVED_MUD_POT.get(), 1);
        }
        if (pDirection == Direction.UP || pDirection == Direction.DOWN) {
            pLevel.m_186460_(pCurrentPos, (Block)AABlocks.CRACKED_MUD_POT.get(), 1);
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POT_SEGMENT});
    }

    public static enum PotSegment implements StringRepresentable
    {
        FULL("full"),
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private PotSegment(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

