/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.sheddmer.abundant_atmosphere.util.AABlockStateProperties;

public class StoneDoorBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final IntegerProperty OPEN = AABlockStateProperties.OPENING;
    public static final BooleanProperty CLOSE = AABlockStateProperties.CLOSING;
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape SOUTH_AL_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)1.0, (double)12.0, (double)16.0, (double)5.0), StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)8.0, (double)16.0, (double)6.0), StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)7.0)});
    protected static final VoxelShape SOUTH_AR_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)8.0, (double)16.0, (double)5.0), StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)6.0), StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)7.0)});
    protected static final VoxelShape SOUTH_MID_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0), StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0), StoneDoorBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0)});
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AL_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0, (double)14.0), StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)11.0, (double)8.0, (double)16.0, (double)15.0), StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape NORTH_AR_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)4.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)14.0), StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0), StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape NORTH_MID_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0), StoneDoorBlock.m_49796_((double)10.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)6.0), StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)});
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AL_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)9.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)10.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)8.0), StoneDoorBlock.m_49796_((double)11.0, (double)0.0, (double)8.0, (double)15.0, (double)16.0, (double)12.0), StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape WEST_AR_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0, (double)8.0), StoneDoorBlock.m_49796_((double)10.0, (double)0.0, (double)8.0, (double)14.0, (double)16.0, (double)12.0), StoneDoorBlock.m_49796_((double)9.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape WEST_MID_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0), StoneDoorBlock.m_49796_((double)10.0, (double)0.0, (double)10.0, (double)14.0, (double)16.0, (double)14.0), StoneDoorBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AL_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)8.0), StoneDoorBlock.m_49796_((double)2.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0), StoneDoorBlock.m_49796_((double)3.0, (double)0.0, (double)12.0, (double)7.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape EAST_AR_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0), StoneDoorBlock.m_49796_((double)1.0, (double)0.0, (double)8.0, (double)5.0, (double)16.0, (double)12.0), StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape EAST_MID_AABB = Shapes.m_83124_((VoxelShape)StoneDoorBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{StoneDoorBlock.m_49796_((double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0, (double)14.0), StoneDoorBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0), StoneDoorBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), StoneDoorBlock.m_49796_((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0)});

    public StoneDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Integer.valueOf(0))).m_61124_((Property)CLOSE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean right;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean bl = right = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        if ((Integer)state.m_61143_((Property)OPEN) == 0) {
            switch (direction) {
                default: {
                    return EAST_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case NORTH: 
            }
            return NORTH_AABB;
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 1) {
            switch (direction) {
                default: {
                    return right ? EAST_AR_AABB : EAST_AL_AABB;
                }
                case SOUTH: {
                    return right ? SOUTH_AR_AABB : SOUTH_AL_AABB;
                }
                case WEST: {
                    return right ? WEST_AR_AABB : WEST_AL_AABB;
                }
                case NORTH: 
            }
            return right ? NORTH_AR_AABB : NORTH_AL_AABB;
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 2) {
            switch (direction) {
                default: {
                    return right ? EAST_MID_AABB : SOUTH_MID_AABB;
                }
                case SOUTH: {
                    return right ? SOUTH_MID_AABB : NORTH_MID_AABB;
                }
                case WEST: {
                    return right ? NORTH_MID_AABB : WEST_MID_AABB;
                }
                case NORTH: 
            }
            return right ? WEST_MID_AABB : EAST_MID_AABB;
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 3) {
            switch (direction) {
                default: {
                    return right ? NORTH_AL_AABB : SOUTH_AR_AABB;
                }
                case SOUTH: {
                    return right ? EAST_AL_AABB : WEST_AR_AABB;
                }
                case WEST: {
                    return right ? SOUTH_AL_AABB : NORTH_AR_AABB;
                }
                case NORTH: 
            }
            return right ? WEST_AL_AABB : EAST_AR_AABB;
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 4) {
            switch (direction) {
                default: {
                    return right ? NORTH_AABB : SOUTH_AABB;
                }
                case SOUTH: {
                    return right ? EAST_AABB : WEST_AABB;
                }
                case WEST: {
                    return right ? SOUTH_AABB : NORTH_AABB;
                }
                case NORTH: 
            }
            return right ? WEST_AABB : EAST_AABB;
        }
        return super.m_5940_(state, getter, pos, context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState altstate, LevelAccessor accessor, BlockPos pos, BlockPos altpos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return altstate.m_60713_((Block)this) && altstate.m_61143_(HALF) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)altstate.m_61143_((Property)FACING)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)altstate.m_61143_(HINGE)))).m_61124_((Property)OPEN, (Comparable)((Integer)altstate.m_61143_((Property)OPEN)))).m_61124_((Property)CLOSE, (Comparable)((Boolean)altstate.m_61143_((Property)CLOSE))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, altstate, accessor, pos, altpos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand p_52773_, BlockHitResult p_52774_) {
        boolean shouldCycleClosing;
        boolean bl = shouldCycleClosing = (Integer)state.m_61143_((Property)OPEN) == ((Boolean)state.m_61143_((Property)CLOSE) != false ? 0 : 4);
        boolean newClosingValue = shouldCycleClosing ? !((Boolean)state.m_61143_((Property)CLOSE)).booleanValue() : (Boolean)state.m_61143_((Property)CLOSE);
        int newOpenValue = (Integer)state.m_61143_((Property)OPEN) + (newClosingValue ? -1 : 1);
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(newOpenValue))).m_61124_((Property)CLOSE, (Comparable)Boolean.valueOf(newClosingValue)), 2);
        level.m_5594_(null, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.0f);
        BlockPos adjacentPos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
        BlockState adjacentState = level.m_8055_(adjacentPos);
        if (adjacentState.m_61138_((Property)OPEN)) {
            level.m_7731_(adjacentPos, (BlockState)((BlockState)adjacentState.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(newOpenValue))).m_61124_((Property)CLOSE, (Comparable)Boolean.valueOf(newClosingValue)), 2);
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 3 && !((Boolean)state.m_61143_((Property)CLOSE)).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 1 && ((Boolean)state.m_61143_((Property)CLOSE)).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if ((Integer)state.m_61143_((Property)OPEN) >= 0 && (Integer)state.m_61143_((Property)OPEN) <= 4 && !level.m_46753_(pos)) {
            this.locking(level, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void locking(Level level, BlockPos pos) {
        level.m_186460_(pos, (Block)this, this.getOpenDuration());
    }

    private int getOpenDuration() {
        return 60;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if ((Integer)state.m_61143_((Property)OPEN) == 1 && !level.m_46753_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(0)), 3);
            level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)null, GameEvent.f_157793_, pos);
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 2 && !level.m_46753_(pos)) {
            if (((Boolean)state.m_61143_((Property)CLOSE)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(4)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)null, GameEvent.f_157793_, pos);
            }
            if (!((Boolean)state.m_61143_((Property)CLOSE)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(0)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)null, GameEvent.f_157793_, pos);
            }
        }
        if ((Integer)state.m_61143_((Property)OPEN) == 3 && !level.m_46753_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(4)), 3);
            level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)null, GameEvent.f_157793_, pos);
            if (((Boolean)state.m_61143_((Property)CLOSE)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Integer.valueOf(4)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)null, GameEvent.f_157793_, pos);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState p_52880_, Player p_52881_) {
        if (!level.f_46443_) {
            if (p_52881_.m_7500_()) {
                StoneDoorBlock.preventCreativeDropFromBottomPart(level, pos, p_52880_, p_52881_);
            } else {
                StoneDoorBlock.m_49881_((BlockState)p_52880_, (Level)level, (BlockPos)pos, (BlockEntity)null, (Entity)p_52881_, (ItemStack)p_52881_.m_21205_());
            }
        }
        super.m_5707_(level, pos, p_52880_, p_52881_);
    }

    public void m_6240_(Level level, Player p_52866_, BlockPos pos, BlockState p_52868_, @Nullable BlockEntity p_52869_, ItemStack p_52870_) {
        super.m_6240_(level, p_52866_, pos, Blocks.f_50016_.m_49966_(), p_52869_, p_52870_);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState p_52906_, Player p_52907_) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)p_52906_.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60713_(p_52906_.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockpos, blockstate1, 35);
            level.m_5898_(p_52907_, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            boolean flag = level.m_46753_(blockpos) || level.m_46753_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        boolean flag1;
        Level blockgetter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = blockgetter.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_121945_(direction1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_121945_(direction2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.m_60713_((Block)this) && blockstate2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = context.m_43720_();
                double d0 = vec3.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public boolean m_7898_(BlockState state, LevelReader p_52784_, BlockPos p_52785_) {
        BlockPos blockpos = p_52785_.m_7495_();
        BlockState blockstate = p_52784_.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)p_52784_, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation p_52791_) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)p_52791_.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? state : (BlockState)state.m_60717_(p_52788_.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public long m_7799_(BlockState state, BlockPos p_52794_) {
        return Mth.m_14130_((int)p_52794_.m_123341_(), (int)p_52794_.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)p_52794_.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.m_61104_(new Property[]{HALF, FACING, HINGE, OPEN, CLOSE});
    }
}

