/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.sheddmer.abundant_atmosphere.init.AABlocks;
import net.sheddmer.abundant_atmosphere.init.AAEntityTypes;
import net.sheddmer.abundant_atmosphere.init.AAItems;

public class AABoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(AABoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AABoatEntity(EntityType<? extends AABoatEntity> entityType, Level world) {
        super(entityType, world);
    }

    public AABoatEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends AABoatEntity>)((EntityType)AAEntityTypes.BOAT.get()), world);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)BOAT_TYPE.m_135015_());
    }

    public Item m_38369_() {
        return this.getAABoatType() == BoatType.ASH ? (Item)AAItems.ASH_BOAT.get() : (Item)AAItems.GOURDROT_BOAT.get();
    }

    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Type", 8)) {
            this.setAABoatType(BoatType.byName(nbt.m_128461_("Type")));
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Type", this.getAABoatType().getName());
    }

    public BoatType getAABoatType() {
        return BoatType.byId((Integer)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    public void setAABoatType(BoatType type) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)type.ordinal());
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            int i;
                            for (i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getAABoatType().getPlanks());
                            }
                            for (i = 0; i < 2; ++i) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.canBoatInFluid(this.f_19853_.m_6425_(this.m_20183_().m_7495_())) && heightDifference < 0.0) {
                this.f_19789_ -= (float)heightDifference;
            }
        }
    }

    public static enum BoatType {
        ASH((Block)AABlocks.ASH_PLANKS.get(), "ash"),
        GOURDROT((Block)AABlocks.GOURDROT_PLANKS.get(), "gourdrot");

        private final String name;
        private final Block planks;

        private BoatType(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            BoatType[] aboat$type = BoatType.values();
            if (id < 0 || id >= aboat$type.length) {
                id = 0;
            }
            return aboat$type[id];
        }

        public static BoatType byName(String name) {
            BoatType[] types;
            for (BoatType type : types = BoatType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }
    }
}

