/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.events;

import java.util.Arrays;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.sheddmer.abundant_atmosphere.client.particles.FireflyParticle;
import net.sheddmer.abundant_atmosphere.client.renderer.AABoatEntityRenderer;
import net.sheddmer.abundant_atmosphere.entities.AABoatEntity;
import net.sheddmer.abundant_atmosphere.init.AABlockEntityTypes;
import net.sheddmer.abundant_atmosphere.init.AABlocks;
import net.sheddmer.abundant_atmosphere.init.AAEntityTypes;
import net.sheddmer.abundant_atmosphere.init.AAModelLayers;
import net.sheddmer.abundant_atmosphere.init.AAParticleTypes;
import net.sheddmer.abundant_atmosphere.init.AASignTypes;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="abundant_atmosphere", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(AASignTypes::init);
    }

    @SubscribeEvent
    public static void registerEntityModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        Arrays.stream(AABoatEntity.BoatType.values()).forEach(type -> {
            event.registerLayerDefinition(AAModelLayers.createBoat(type), () -> BoatModel.m_233347_((boolean)false));
            event.registerLayerDefinition(AAModelLayers.createChestBoat(type), () -> BoatModel.m_233347_((boolean)true));
        });
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)AABlockEntityTypes.AA_SIGN.get(), SignRenderer::new);
        event.registerEntityRenderer((EntityType)AAEntityTypes.BOAT.get(), ctx -> new AABoatEntityRenderer(ctx, false));
        event.registerEntityRenderer((EntityType)AAEntityTypes.CHEST_BOAT.get(), ctx -> new AABoatEntityRenderer(ctx, true));
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return FoliageColor.m_46113_();
            }
            return BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
        }, new Block[]{(Block)AABlocks.HANGING_MANGROVE_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)AABlocks.HANGING_MANGROVE_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)AAParticleTypes.FIREFLY.get(), FireflyParticle.Provider::new);
    }
}

