/*
 * Decompiled with CFR 0.152.
 */
package net.sheddmer.abundant_atmosphere.init;

import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.sheddmer.abundant_atmosphere.init.AAPlacedFeatures;

@Mod.EventBusSubscriber(modid="abundant_atmosphere", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AABiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"abundant_atmosphere");
    public static final RegistryObject<Biome> MARSH_FLATLANDS = BIOMES.register("marsh_flatlands", AABiomes::marshFlatlands);
    public static final RegistryObject<Biome> BASALT_OASIS = BIOMES.register("basalt_oasis", AABiomes::basaltOasis);
    public static final ResourceKey<Biome> MARSH_FLATLANDS_KEY = AABiomes.registerResourceKey("marsh_flatlands");
    public static final ResourceKey<Biome> BASALT_OASIS_KEY = AABiomes.registerResourceKey("basalt_oasis");

    public static Biome marshFlatlands() {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        mobspawnsettings$builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 6, 2, 5));
        mobspawnsettings$builder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 16, 8, 8));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_236470_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AAPlacedFeatures.MANGROVE_SWAMP_DRIPLEAF);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        Music music = Musics.m_11653_((SoundEvent)SoundEvents.f_215730_);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(3832426).m_48037_(5077600).m_48019_(12638463).m_48040_(AABiomes.getSkyColor(0.8f)).m_48043_(9285927).m_48031_(BiomeSpecialEffects.GrassColorModifier.SWAMP).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(biomegenerationsettings$builder.m_47831_()).m_47592_();
    }

    public static Biome basaltOasis() {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_236470_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195469_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195419_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.LAKES, AAPlacedFeatures.BASALT_SPRING_POOL);
        Music music = Musics.m_11653_((SoundEvent)SoundEvents.f_184220_);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.6f).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4445678).m_48037_(270131).m_48019_(12638463).m_48040_(AABiomes.getSkyColor(0.6f)).m_48043_(9285927).m_48031_(BiomeSpecialEffects.GrassColorModifier.NONE).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(biomegenerationsettings$builder.m_47831_()).m_47592_();
    }

    protected static int getSkyColor(float temperature) {
        float value = temperature / 3.0f;
        value = Mth.m_14036_((float)value, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - value * 0.05f), (float)(0.5f + value * 0.1f), (float)1.0f);
    }

    private static ResourceKey<Biome> registerResourceKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("abundant_atmosphere", name));
    }
}

