/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.hekatelib.animations;

import com.obscuria.hekatelib.animations.AnimatedPart;
import com.obscuria.hekatelib.animations.HekateAnimation;
import com.obscuria.hekatelib.animations.HekateProvider;
import com.obscuria.hekatelib.animations.IHekateProvider;
import com.obscuria.hekatelib.animations.KeyFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;

public class HekateLib {
    public static void updateScale(Entity entity, float scale, float speed) {
        float scaleIn = entity.getPersistentData().func_74760_g("HScale");
        entity.getPersistentData().func_74776_a("HScaleLerp", scaleIn);
        scaleIn = scale != scaleIn ? MathHelper.func_219799_g((float)speed, (float)scaleIn, (float)scale) : scaleIn;
        entity.getPersistentData().func_74776_a("HScale", scaleIn);
    }

    public static void i(ModelRenderer part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer) {
        part.field_78795_f += render.idle(x, baseX * -1.0f, speed, offset, timer);
        part.field_78796_g += render.idle(y, baseY * -1.0f, speed, offset, timer);
        part.field_78808_h += render.idle(z, baseZ, speed, offset, timer);
    }

    public static void i(ModelRenderer part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod2) {
        part.field_78795_f += render.idle(x, baseX * -1.0f, speed, offset, timer, mod2);
        part.field_78796_g += render.idle(y, baseY * -1.0f, speed, offset, timer, mod2);
        part.field_78808_h += render.idle(z, baseZ, speed, offset, timer, mod2);
    }

    public static void i(ModelRenderer part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod1, float mod2) {
        part.field_78795_f += render.idle(x, baseX * -1.0f, speed, offset, timer, mod1, mod2);
        part.field_78796_g += render.idle(y, baseY * -1.0f, speed, offset, timer, mod1, mod2);
        part.field_78808_h += render.idle(z, baseZ, speed, offset, timer, mod1, mod2);
    }

    public static void m(ModelRenderer part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod2) {
        part.field_78795_f += render.move(x, baseX * -1.0f, speed, offset, timer, mod2);
        part.field_78796_g += render.move(y, baseY * -1.0f, speed, offset, timer, mod2);
        part.field_78808_h += render.move(z, baseZ, speed, offset, timer, mod2);
    }

    public static void m(ModelRenderer part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod1, float mod2) {
        part.field_78795_f += render.move(x, baseX * -1.0f, speed, offset, timer, mod1, mod2);
        part.field_78796_g += render.move(y, baseY * -1.0f, speed, offset, timer, mod1, mod2);
        part.field_78808_h += render.move(z, baseZ, speed, offset, timer, mod1, mod2);
    }

    public static void m(ModelRenderer part, boolean invert, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod2) {
        part.field_78795_f += render.move(invert, x, baseX * -1.0f, speed, offset, timer, mod2);
        part.field_78796_g += render.move(invert, y, baseY * -1.0f, speed, offset, timer, mod2);
        part.field_78808_h += render.move(invert, z, baseZ, speed, offset, timer, mod2);
    }

    public static void k(ModelRenderer part, float x, float y, float z, float mod2) {
        part.field_78795_f += render.keyFrame(x * -1.0f, mod2);
        part.field_78796_g += render.keyFrame(y * -1.0f, mod2);
        part.field_78808_h += render.keyFrame(z, mod2);
    }

    public static void k(ModelRenderer part, float x, float y, float z, float mod1, float mod2) {
        part.field_78795_f += render.keyFrame(x * -1.0f, mod1, mod2);
        part.field_78796_g += render.keyFrame(y * -1.0f, mod1, mod2);
        part.field_78808_h += render.keyFrame(z, mod1, mod2);
    }

    public static void r(ModelRenderer part, float mod2) {
        mod2 = 1.0f - mod2;
        part.field_78795_f *= mod2;
        part.field_78796_g *= mod2;
        part.field_78808_h *= mod2;
    }

    public static float translate(float value, float target, float speed) {
        return value + (target - value) * speed;
    }

    public static float convert(float value) {
        return value * ((float)Math.PI / 180);
    }

    public static class effect {
        public static float cyclicPause(float f1, float f2, float f3) {
            return 0.5f + MathHelper.func_76134_b((float)(f1 * f2 + f3 * 6.283f)) * 0.5f;
        }
    }

    public static class render {
        public static void tick(Entity entity) {
            if (entity instanceof IHekateProvider) {
                IHekateProvider iProvider = (IHekateProvider)entity;
                HekateProvider provider = iProvider.getHekateProvider();
                float lastTime = provider.currentTime;
                provider.currentTime = (float)Util.func_211178_c() / 1.0E9f;
                provider.deltaTime = provider.currentTime - lastTime;
            }
        }

        public static void prepare(ModelRenderer ... parts) {
            for (ModelRenderer part : parts) {
                part.field_78795_f = 0.0f;
                part.field_78796_g = 0.0f;
                part.field_78808_h = 0.0f;
            }
        }

        public static void animation(Entity entity, String animation, float timer, KeyFrame ... frames) {
            if (entity instanceof IHekateProvider) {
                IHekateProvider iProvider = (IHekateProvider)entity;
                HekateProvider provider = iProvider.getHekateProvider();
                int tick = provider.getTick(animation);
                int i = 0;
                for (KeyFrame frame : frames) {
                    boolean active;
                    float mod2 = provider.getModifier(animation + ++i);
                    boolean bl = active = tick > 0 && tick > frame.TICK_END && tick <= frame.TICK_START;
                    if (!Minecraft.func_71410_x().func_147113_T()) {
                        mod2 += active ? (1.0f - mod2) * Math.min(1.0f, frame.SPEED_IN * provider.deltaTime) : (0.0f - mod2) * Math.min(1.0f, frame.SPEED_OUT * provider.deltaTime);
                    }
                    provider.getModifiers().put(animation + i, Float.valueOf(mod2));
                    for (AnimatedPart part : frame.PARTS) {
                        HekateLib.r(part.PART, mod2);
                        if (part.SWING) {
                            HekateLib.i(part.PART, part.X, part.XBase, part.Y, part.YBase, part.Z, part.ZBase, part.SPEED, part.OFFSET, timer, mod2);
                            continue;
                        }
                        HekateLib.k(part.PART, part.X, part.Y, part.Z, mod2);
                    }
                }
            }
        }

        public static float idle(float deg1, float deg2, float speed, float offset, float timer) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (deg1 *= (float)Math.PI / 180) * MathHelper.func_76134_b((float)(timer * speed + offset * 6.283f)) + (deg2 *= (float)Math.PI / 180);
        }

        public static float idle(float deg1, float deg2, float speed, float offset, float timer, float mod1) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return mod1 <= 0.0f ? 0.0f : render.idle(deg1, deg2, speed, offset, timer) * mod1;
        }

        public static float idle(float deg1, float deg2, float speed, float offset, float timer, float mod1, float mod2) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (mod2 = 1.0f - mod2) <= 0.0f ? 0.0f : render.idle(deg1, deg2, speed, offset, timer, mod1) * mod2;
        }

        public static float move(float deg1, float deg2, float speed, float offset, float timer, float mod1) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (mod1 * (deg1 *= (float)Math.PI / 180) * MathHelper.func_76134_b((float)(timer * speed + offset * 6.283f)) + (deg2 *= (float)Math.PI / 180)) * mod1;
        }

        public static float move(float deg1, float deg2, float speed, float offset, float timer, float mod1, float mod2) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (mod2 = 1.0f - mod2) <= 0.0f ? 0.0f : render.move(deg1, deg2, speed, offset, timer, mod1) * mod2;
        }

        public static float move(boolean invert, float deg1, float deg2, float speed, float offset, float timer, float mod1) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            float result = mod1 * (deg1 *= (float)Math.PI / 180) * MathHelper.func_76134_b((float)(timer * speed + offset * 6.283f));
            return ((!invert && result < 0.0f ? -result : (invert && result > 0.0f ? -result : result)) + (deg2 *= (float)Math.PI / 180)) * mod1;
        }

        public static float spawn(float p, float mod2, float deg) {
            return p * mod2 + (deg *= (float)Math.PI / 180) * (1.0f - mod2);
        }

        public static float headYaw(float yaw, float mod2) {
            return yaw / 57.295776f * mod2;
        }

        public static float spin(float timer, float speed, float mod2) {
            return timer * speed % 6.282f * mod2;
        }

        public static float keyFrame(float deg, float mod2) {
            if (deg == 0.0f) {
                return 0.0f;
            }
            return (deg *= (float)Math.PI / 180) * mod2;
        }

        public static float keyFrame(float deg, float mod1, float mod2) {
            if (deg == 0.0f) {
                return 0.0f;
            }
            mod2 = Math.max(mod2, 0.0f);
            mod2 = Math.min(mod2, 1.0f);
            return (deg *= (float)Math.PI / 180) * mod1 * mod2;
        }
    }

    public static class mod {
        public static float idle(float f1, float f2) {
            return Math.max(1.0f - f1 * f2, 0.0f);
        }

        public static float move(float f1, float f2) {
            return Math.min(f1 * f2, 1.0f);
        }

        public static float get(Entity entity, String animation, float speedIn, float speedOut) {
            if (entity instanceof IHekateProvider) {
                IHekateProvider iProvider = (IHekateProvider)entity;
                HekateProvider provider = iProvider.getHekateProvider();
                int tick = provider.getTick(animation);
                float mod2 = provider.getModifier(animation);
                if (!Minecraft.func_71410_x().func_147113_T()) {
                    mod2 += tick > 0 ? (1.0f - mod2) * Math.min(1.0f, speedIn * provider.deltaTime) : (0.0f - mod2) * Math.min(1.0f, speedOut * provider.deltaTime);
                }
                provider.getModifiers().put(animation, Float.valueOf(mod2));
                return mod2;
            }
            return 0.0f;
        }

        public static float scale(Entity entity) {
            float scale = entity.getPersistentData().func_74760_g("HScale");
            float scaleLerp = entity.getPersistentData().func_74760_g("HScaleLerp");
            return MathHelper.func_219799_g((float)Minecraft.func_71410_x().func_184121_ak(), (float)scaleLerp, (float)scale);
        }
    }

    public static class network {
        public static boolean readPacket(int id, CompoundNBT animations) {
            assert (Minecraft.func_71410_x().field_71439_g != null);
            Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(id);
            if (entity instanceof IHekateProvider) {
                IHekateProvider provider = (IHekateProvider)entity;
                provider.getHekateProvider().getAnimations().clear();
                for (String animation : animations.func_150296_c()) {
                    provider.getHekateProvider().getAnimations().add(new HekateAnimation(animation, animations.func_74762_e(animation)));
                }
            }
            return true;
        }
    }
}

