/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.hekatelib.animations;

import com.obscuria.hekatelib.HekateLibMod;
import com.obscuria.hekatelib.animations.HekateAnimation;
import com.obscuria.hekatelib.network.AnimationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class HekateProvider {
    private final Entity entity;
    private final List<HekateAnimation> animations = new ArrayList<HekateAnimation>();
    private final HashMap<String, Float> modifiers = new HashMap();
    public float currentTime = 0.0f;
    public float deltaTime = 0.0f;

    public HekateProvider(Entity entity) {
        this.entity = entity;
    }

    public List<HekateAnimation> getAnimations() {
        return this.animations;
    }

    public HashMap<String, Float> getModifiers() {
        return this.modifiers;
    }

    public float getModifier(String name) {
        return this.modifiers.containsKey(name) ? this.modifiers.get(name).floatValue() : 0.0f;
    }

    public void play(String animation, int ticks) {
        if (this.entity.field_70170_p.func_201670_d()) {
            return;
        }
        this.prepare(animation);
        this.animations.add(new HekateAnimation(animation, ticks));
        this.sendPacket(this.entity);
    }

    public void stop(Entity entity, String animation) {
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        ArrayList<HekateAnimation> list = new ArrayList<HekateAnimation>(this.animations);
        for (HekateAnimation anim : list) {
            if (!anim.name.equals(animation)) continue;
            this.animations.remove(anim);
        }
        this.sendPacket(entity);
    }

    public boolean isPlaying(String animation) {
        for (HekateAnimation anim : this.animations) {
            if (!anim.name.equals(animation)) continue;
            return true;
        }
        return false;
    }

    public int getTick(String animation) {
        for (HekateAnimation anim : this.animations) {
            if (!anim.name.equals(animation)) continue;
            return anim.ticks;
        }
        return 0;
    }

    public void playSound(String animation, int tick, String sound, SoundCategory source, float volume, float pitch) {
        if (this.entity.field_70170_p.func_201670_d() && this.isPlaying(animation) && this.getTick(animation) == tick - 1) {
            this.entity.field_70170_p.func_184134_a(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), new SoundEvent(new ResourceLocation(sound)), source, volume, pitch, false);
        }
    }

    private void prepare(String animation) {
        ArrayList<HekateAnimation> list = new ArrayList<HekateAnimation>(this.animations);
        for (HekateAnimation anim : list) {
            if (!anim.name.equals(animation)) continue;
            this.animations.remove(anim);
        }
    }

    private void sendPacket(Entity entity) {
        HekateLibMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new AnimationMessage(this.packAnimations(), entity.func_145782_y()));
    }

    private CompoundNBT packAnimations() {
        CompoundNBT packet = new CompoundNBT();
        for (HekateAnimation animation : this.animations) {
            packet.func_74768_a(animation.name, animation.ticks);
        }
        return packet;
    }
}

