/*
 * Decompiled with CFR 0.152.
 */
package castle_and_hustle.init;

import castle_and_hustle.world.features.AncientStatueFeature;
import castle_and_hustle.world.features.Castle1Feature;
import castle_and_hustle.world.features.CastleBossFeature;
import castle_and_hustle.world.features.CellarPlaceFeature;
import castle_and_hustle.world.features.HunterHome1Feature;
import castle_and_hustle.world.features.HunterHome2Feature;
import castle_and_hustle.world.features.HunterHome3Feature;
import castle_and_hustle.world.features.HunterHome4Feature;
import castle_and_hustle.world.features.OceanScrapFeature;
import castle_and_hustle.world.features.PyramidFeature;
import castle_and_hustle.world.features.RaftFeature;
import castle_and_hustle.world.features.Tower1Feature;
import castle_and_hustle.world.features.Tower2Feature;
import castle_and_hustle.world.features.Tower3Feature;
import castle_and_hustle.world.features.Tower4Feature;
import castle_and_hustle.world.features.ores.BigCastleBlockFeature;
import castle_and_hustle.world.features.plants.SmallCactusFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class CastleAndHustleModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"castle_and_hustle");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> TOWER_1 = CastleAndHustleModFeatures.register("tower_1", Tower1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Tower1Feature.GENERATE_BIOMES, Tower1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUNTER_HOME_1 = CastleAndHustleModFeatures.register("hunter_home_1", HunterHome1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HunterHome1Feature.GENERATE_BIOMES, HunterHome1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUNTER_HOME_2 = CastleAndHustleModFeatures.register("hunter_home_2", HunterHome2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HunterHome2Feature.GENERATE_BIOMES, HunterHome2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUNTER_HOME_3 = CastleAndHustleModFeatures.register("hunter_home_3", HunterHome3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HunterHome3Feature.GENERATE_BIOMES, HunterHome3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> HUNTER_HOME_4 = CastleAndHustleModFeatures.register("hunter_home_4", HunterHome4Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HunterHome4Feature.GENERATE_BIOMES, HunterHome4Feature::placedFeature));
    public static final RegistryObject<Feature<?>> SMALL_CACTUS = CastleAndHustleModFeatures.register("small_cactus", SmallCactusFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, SmallCactusFeature.GENERATE_BIOMES, SmallCactusFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CASTLE_1 = CastleAndHustleModFeatures.register("castle_1", Castle1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, Castle1Feature.GENERATE_BIOMES, Castle1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> TOWER_2 = CastleAndHustleModFeatures.register("tower_2", Tower2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Tower2Feature.GENERATE_BIOMES, Tower2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> TOWER_3 = CastleAndHustleModFeatures.register("tower_3", Tower3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Tower3Feature.GENERATE_BIOMES, Tower3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CASTLE_BOSS = CastleAndHustleModFeatures.register("castle_boss", CastleBossFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CastleBossFeature.GENERATE_BIOMES, CastleBossFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TOWER_4 = CastleAndHustleModFeatures.register("tower_4", Tower4Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Tower4Feature.GENERATE_BIOMES, Tower4Feature::placedFeature));
    public static final RegistryObject<Feature<?>> BIG_CASTLE_BLOCK = CastleAndHustleModFeatures.register("big_castle_block", BigCastleBlockFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BigCastleBlockFeature.GENERATE_BIOMES, BigCastleBlockFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RAFT = CastleAndHustleModFeatures.register("raft", RaftFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, RaftFeature.GENERATE_BIOMES, RaftFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ANCIENT_STATUE = CastleAndHustleModFeatures.register("ancient_statue", AncientStatueFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, AncientStatueFeature.GENERATE_BIOMES, AncientStatueFeature::placedFeature));
    public static final RegistryObject<Feature<?>> OCEAN_SCRAP = CastleAndHustleModFeatures.register("ocean_scrap", OceanScrapFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, OceanScrapFeature.GENERATE_BIOMES, OceanScrapFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PYRAMID = CastleAndHustleModFeatures.register("pyramid", PyramidFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, PyramidFeature.GENERATE_BIOMES, PyramidFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CELLAR_PLACE = CastleAndHustleModFeatures.register("cellar_place", CellarPlaceFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CellarPlaceFeature.GENERATE_BIOMES, CellarPlaceFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

