/*
 * Decompiled with CFR 0.152.
 */
package castle_and_hustle.init;

import castle_and_hustle.entity.BoneBreakerEntity;
import castle_and_hustle.entity.DaggerEntity;
import castle_and_hustle.entity.DemonEntity;
import castle_and_hustle.entity.DemonShotEntity;
import castle_and_hustle.entity.DoomEntity;
import castle_and_hustle.entity.LittleskeletonEntity;
import castle_and_hustle.entity.OgreEntity;
import castle_and_hustle.entity.SatyrEntity;
import castle_and_hustle.entity.ShamanEntity;
import castle_and_hustle.entity.ShieldBearerEntity;
import castle_and_hustle.entity.TinyEntity;
import castle_and_hustle.entity.VindEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CastleAndHustleModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"castle_and_hustle");
    public static final RegistryObject<EntityType<DaggerEntity>> DAGGER = CastleAndHustleModEntities.register("dagger", EntityType.Builder.m_20704_(DaggerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(DaggerEntity::new).m_20699_(0.5f, 1.2f));
    public static final RegistryObject<EntityType<BoneBreakerEntity>> BONE_BREAKER = CastleAndHustleModEntities.register("bone_breaker", EntityType.Builder.m_20704_(BoneBreakerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(7).setUpdateInterval(3).setCustomClientFactory(BoneBreakerEntity::new).m_20699_(0.5f, 1.2f));
    public static final RegistryObject<EntityType<ShieldBearerEntity>> SHIELD_BEARER = CastleAndHustleModEntities.register("shield_bearer", EntityType.Builder.m_20704_(ShieldBearerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(15).setUpdateInterval(3).setCustomClientFactory(ShieldBearerEntity::new).m_20699_(0.5f, 1.2f));
    public static final RegistryObject<EntityType<TinyEntity>> TINY = CastleAndHustleModEntities.register("tiny", EntityType.Builder.m_20704_(TinyEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(15).setUpdateInterval(3).setCustomClientFactory(TinyEntity::new).m_20719_().m_20699_(1.8f, 1.8f));
    public static final RegistryObject<EntityType<SatyrEntity>> STALKER = CastleAndHustleModEntities.register("stalker", EntityType.Builder.m_20704_(SatyrEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setUpdateInterval(3).setCustomClientFactory(SatyrEntity::new).m_20719_().m_20699_(0.5f, 1.5f));
    public static final RegistryObject<EntityType<LittleskeletonEntity>> LITTLESKELETON = CastleAndHustleModEntities.register("littleskeleton", EntityType.Builder.m_20704_(LittleskeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).setCustomClientFactory(LittleskeletonEntity::new).m_20699_(0.5f, 1.0f));
    public static final RegistryObject<EntityType<ShamanEntity>> SHAMAN = CastleAndHustleModEntities.register("shaman", EntityType.Builder.m_20704_(ShamanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).setCustomClientFactory(ShamanEntity::new).m_20699_(0.6f, 1.7f));
    public static final RegistryObject<EntityType<DoomEntity>> DOOM = CastleAndHustleModEntities.register("doom", EntityType.Builder.m_20704_(DoomEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(40).setUpdateInterval(3).setCustomClientFactory(DoomEntity::new).m_20719_().m_20699_(1.8f, 2.8f));
    public static final RegistryObject<EntityType<DemonEntity>> DEMON = CastleAndHustleModEntities.register("demon", EntityType.Builder.m_20704_(DemonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(40).setUpdateInterval(3).setCustomClientFactory(DemonEntity::new).m_20719_().m_20699_(0.8f, 1.0f));
    public static final RegistryObject<EntityType<DemonShotEntity>> DEMON_SHOT = CastleAndHustleModEntities.register("projectile_demon_shot", EntityType.Builder.m_20704_(DemonShotEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(DemonShotEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<OgreEntity>> OGRE = CastleAndHustleModEntities.register("ogre", EntityType.Builder.m_20704_(OgreEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).setUpdateInterval(3).setCustomClientFactory(OgreEntity::new).m_20699_(1.8f, 1.9f));
    public static final RegistryObject<EntityType<VindEntity>> VIND = CastleAndHustleModEntities.register("vind", EntityType.Builder.m_20704_(VindEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(30).setUpdateInterval(3).setCustomClientFactory(VindEntity::new).m_20699_(0.5f, 0.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DaggerEntity.init();
            BoneBreakerEntity.init();
            ShieldBearerEntity.init();
            TinyEntity.init();
            SatyrEntity.init();
            LittleskeletonEntity.init();
            ShamanEntity.init();
            DoomEntity.init();
            DemonEntity.init();
            OgreEntity.init();
            VindEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DAGGER.get(), DaggerEntity.createAttributes().m_22265_());
        event.put((EntityType)BONE_BREAKER.get(), BoneBreakerEntity.createAttributes().m_22265_());
        event.put((EntityType)SHIELD_BEARER.get(), ShieldBearerEntity.createAttributes().m_22265_());
        event.put((EntityType)TINY.get(), TinyEntity.createAttributes().m_22265_());
        event.put((EntityType)STALKER.get(), SatyrEntity.createAttributes().m_22265_());
        event.put((EntityType)LITTLESKELETON.get(), LittleskeletonEntity.createAttributes().m_22265_());
        event.put((EntityType)SHAMAN.get(), ShamanEntity.createAttributes().m_22265_());
        event.put((EntityType)DOOM.get(), DoomEntity.createAttributes().m_22265_());
        event.put((EntityType)DEMON.get(), DemonEntity.createAttributes().m_22265_());
        event.put((EntityType)OGRE.get(), OgreEntity.createAttributes().m_22265_());
        event.put((EntityType)VIND.get(), VindEntity.createAttributes().m_22265_());
    }
}

