/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity;

import com.calculusmaster.difficultraids.entity.entities.elite.NuaosEliteEntity;
import com.calculusmaster.difficultraids.items.GMArmorItem;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEnchantments;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="difficultraids", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DREntityEvents {
    @SubscribeEvent
    public static void onEntityDamaged(LivingDamageEvent event) {
        int projectileEvasionLevel;
        Random random = new Random();
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof NuaosEliteEntity) {
            NuaosEliteEntity nuaos = (NuaosEliteEntity)livingEntity;
            if (event.getAmount() > 0.0f) {
                nuaos.increaseChargedDamage(event.getAmount());
                nuaos.resetLastDamageTakenTicks();
            }
        }
        if ((livingEntity = event.getEntityLiving()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getAmount() > 0.0f && event.getSource().m_7639_() instanceof Raider) {
                float damageReduction = 0.0f;
                for (ItemStack armor : player.m_6168_()) {
                    Item item = armor.m_41720_();
                    if (!(item instanceof GMArmorItem)) continue;
                    GMArmorItem gmArmor = (GMArmorItem)item;
                    damageReduction += gmArmor.getRaiderDamageReduction();
                }
                if (damageReduction > 0.0f) {
                    event.setAmount(event.getAmount() * (1.0f - damageReduction));
                }
            }
        }
        if (random.nextFloat() < 0.1f) {
            int totalCritResistLevel = 0;
            for (ItemStack stack : event.getEntityLiving().m_6168_()) {
                totalCritResistLevel += EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DifficultRaidsEnchantments.CRITICAL_RESISTANCE.get()), (ItemStack)stack);
            }
            if ((totalCritResistLevel = Math.min(totalCritResistLevel, 12)) > 0) {
                float reduction = 1.0f - (float)totalCritResistLevel / 12.0f * (event.getSource().m_7639_() instanceof Raider ? 0.8f : 0.7f);
                event.setAmount(event.getAmount() * reduction);
                event.getEntityLiving().m_5496_(SoundEvents.f_11986_, 1.5f, 1.5f);
            }
        }
        if (event.getSource().m_19360_() && !event.getSource().m_19376_() && (projectileEvasionLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DifficultRaidsEnchantments.PROJECTILE_EVASION.get()), (ItemStack)event.getEntityLiving().m_6844_(EquipmentSlot.FEET))) > 0) {
            float chance;
            switch (projectileEvasionLevel) {
                case 1: {
                    float f = 0.05f;
                    break;
                }
                case 2: {
                    float f = 0.1f;
                    break;
                }
                case 3: {
                    float f = 0.2f;
                    break;
                }
                default: {
                    float f = chance = 0.0f;
                }
            }
            if (random.nextFloat() < chance) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity living;
        Random random = new Random();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_21205_().m_41619_()) {
            int strikeLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get()), (ItemStack)living.m_21205_());
            int burstLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DifficultRaidsEnchantments.CRITICAL_BURST.get()), (ItemStack)living.m_21205_());
            if (strikeLevel > 0 || burstLevel > 0) {
                float minimumChance = 0.035f;
                float chance = 0.05f;
                if (strikeLevel > 0) {
                    for (int i = 0; i < 2 && strikeLevel-- > 0; ++i) {
                        chance += 0.1f;
                    }
                    while (strikeLevel-- > 0) {
                        chance += 0.125f;
                    }
                }
                float multiplier = 1.25f;
                if (burstLevel > 0) {
                    int i;
                    for (i = 0; i < 3 && burstLevel-- > 0; ++i) {
                        multiplier += 0.2f;
                    }
                    for (i = 0; i < 4 && burstLevel-- > 0; ++i) {
                        multiplier += 0.3f;
                        if (!(chance - 0.015f >= minimumChance)) continue;
                        chance -= 0.015f;
                    }
                    while (burstLevel-- > 0) {
                        multiplier += 0.45f;
                        if (!(chance - 0.025f >= minimumChance)) continue;
                        chance -= 0.025f;
                    }
                }
                if (random.nextFloat() < chance) {
                    event.setAmount(event.getAmount() * multiplier);
                    living.m_183503_().m_6269_(null, (Entity)living, SoundEvents.f_11983_, SoundSource.HOSTILE, 4.25f, 0.65f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySetTarget(LivingSetAttackTargetEvent event) {
        LivingEntity target = event.getTarget();
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (target != null && target.m_21023_(MobEffects.f_19609_)) {
                for (ItemStack slot : target.m_6168_()) {
                    if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DifficultRaidsEnchantments.INVISIBILITY.get()), (ItemStack)slot) <= 0) continue;
                    mob.m_6710_(null);
                }
            }
        }
    }
}

