/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.setup.DifficultRaidsItems;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class ModurEliteEntity
extends AbstractEvokerVariant {
    private final TextComponent ELITE_NAME = new TextComponent("Modur, Harbinger of Thunder");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent((Component)this.ELITE_NAME, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private int stormTicks = 0;
    private AABB stormAABB = new AABB(BlockPos.f_121853_);

    public ModurEliteEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    public static AttributeSupplier.Builder createEliteAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.45f).m_22268_(Attributes.f_22277_, 14.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ModurCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 0.6, 0.75));
        this.f_21345_.m_25352_(3, (Goal)new ModurSummonThunderGoal());
        this.f_21345_.m_25352_(4, (Goal)new ModurLightningStormGoal());
        this.f_21345_.m_25352_(4, (Goal)new ModurLightningZapGoal());
        this.f_21345_.m_25352_(5, (Goal)new ModurShootFireballGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 6.0f, 0.6, 0.75));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        HashMap<Enchantment, Integer> generalEnchants = new HashMap<Enchantment, Integer>();
        generalEnchants.put(Enchantments.f_44965_, 2);
        generalEnchants.put(Enchantments.f_44963_, 1);
        generalEnchants.put(Enchantments.f_44972_, 1);
        generalEnchants.put(Enchantments.f_44966_, 5);
        ItemStack helm = new ItemStack((ItemLike)Items.f_42480_);
        ItemStack chest = new ItemStack((ItemLike)Items.f_42473_);
        ItemStack legs = new ItemStack((ItemLike)Items.f_42482_);
        ItemStack boots = new ItemStack((ItemLike)Items.f_42475_);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)helm);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)chest);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)legs);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)boots);
        this.m_8061_(EquipmentSlot.HEAD, helm);
        this.m_8061_(EquipmentSlot.CHEST, chest);
        this.m_8061_(EquipmentSlot.LEGS, legs);
        this.m_8061_(EquipmentSlot.FEET, boots);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        if (pSource.m_7639_() instanceof IronGolem || DifficultRaidsUtil.isGuardVillagersLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount = (float)((double)pAmount * 0.4);
        }
        if ((entity = pSource.m_7640_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.isStormActive() && this.f_19796_.nextFloat() < 0.15f) {
                this.spawnCustomBolt(living.m_142538_().m_142022_(0.0, 0.5, 0.0), this.f_19796_.nextFloat() * 3.0f);
            }
        }
        if (pSource.m_7640_() instanceof Projectile) {
            pAmount *= 0.8f;
        }
        if (this.isStormActive()) {
            pAmount = (float)((double)pAmount * 1.2);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        this.spawnCustomBolt(this.m_142538_().m_142022_(0.0, 0.2, 0.0), 15.0f);
        if (!this.f_19853_.f_46443_) {
            ((ServerLevel)this.f_19853_).m_8606_(6000, 0, false, false);
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("StormTicks", this.stormTicks);
        pCompound.m_128385_("StormAABB", new int[]{(int)this.stormAABB.f_82288_, (int)this.stormAABB.f_82291_, (int)this.stormAABB.f_82289_, (int)this.stormAABB.f_82292_, (int)this.stormAABB.f_82290_, (int)this.stormAABB.f_82293_});
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.stormTicks = pCompound.m_128451_("StormTicks");
        int[] dataAABB = pCompound.m_128465_("StormAABB");
        this.stormAABB = dataAABB.length == 6 ? new AABB((double)dataAABB[0], (double)dataAABB[1], (double)dataAABB[2], (double)dataAABB[3], (double)dataAABB[4], (double)dataAABB[5]) : new AABB(BlockPos.f_121853_);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        this.m_19983_(new ItemStack((ItemLike)DifficultRaidsItems.TOTEM_OF_LIGHTNING.get()));
    }

    public boolean isStormActive() {
        return this.stormTicks > 0;
    }

    private void spawnCustomBolt(BlockPos spawn, float damage) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
        if (bolt == null) {
            return;
        }
        bolt.m_6593_((Component)new TextComponent("DifficultRaids_Electro_Bolt"));
        bolt.setDamage(damage);
        bolt.m_20035_(spawn, 0.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)bolt);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isStormActive()) {
            int strikes = this.f_19853_.m_46791_().equals((Object)Difficulty.HARD) ? 2 : 1;
            for (int i = 0; i < strikes; ++i) {
                BlockPos strikePos = new BlockPos((double)this.f_19796_.nextInt((int)this.stormAABB.f_82288_, (int)(this.stormAABB.f_82291_ + 1.0)), this.stormAABB.f_82289_, (double)this.f_19796_.nextInt((int)this.stormAABB.f_82290_, (int)this.stormAABB.f_82293_));
                int tries = 0;
                while (!this.f_19853_.m_8055_(strikePos).m_60795_() && tries++ < 20) {
                    strikePos = strikePos.m_6630_(1);
                }
                this.spawnCustomBolt(strikePos, switch (this.f_19853_.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> 0.0f;
                    case Difficulty.EASY -> 3.0f;
                    case Difficulty.NORMAL -> 7.5f;
                    case Difficulty.HARD -> 10.0f;
                });
            }
            --this.stormTicks;
            if (this.stormTicks == 0) {
                this.stormAABB = new AABB(BlockPos.f_121853_);
            }
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.ELITE_EVENT.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    private class ModurCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private ModurCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (ModurEliteEntity.this.m_5448_() != null) {
                ModurEliteEntity.this.m_21563_().m_24960_((Entity)ModurEliteEntity.this.m_5448_(), (float)ModurEliteEntity.this.m_8085_(), (float)ModurEliteEntity.this.m_8132_());
            }
        }
    }

    private class ModurSummonThunderGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurSummonThunderGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ((ServerLevel)ModurEliteEntity.this.f_19853_).m_8606_(0, 6000, true, true);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !ModurEliteEntity.this.f_19853_.m_6106_().m_6534_();
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 300;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12090_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_SUMMON_THUNDER;
        }
    }

    private class ModurLightningStormGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurLightningStormGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            double d;
            ModurEliteEntity modur = ModurEliteEntity.this;
            Random random = modur.f_19796_;
            modur.stormTicks = random.nextInt(40, switch (modur.f_19853_.m_46791_()) {
                default -> throw new IncompatibleClassChangeError();
                case Difficulty.PEACEFUL -> 41;
                case Difficulty.EASY -> 81;
                case Difficulty.NORMAL -> 101;
                case Difficulty.HARD -> 161;
            });
            AABB aABB = new AABB(modur.m_142538_());
            if (modur.isInRaid()) {
                switch (modur.getRaidDifficulty()) {
                    case HERO: {
                        d = 18.0;
                        break;
                    }
                    case LEGEND: {
                        d = 24.0;
                        break;
                    }
                    case MASTER: {
                        d = 30.0;
                        break;
                    }
                    case GRANDMASTER: {
                        d = 50.0;
                        break;
                    }
                    default: {
                        d = 0.0;
                        break;
                    }
                }
            } else {
                d = 10.0;
            }
            modur.stormAABB = aABB.m_82400_(d).m_165893_(modur.m_20188_() + 4.0).m_165887_((double)modur.m_142538_().m_123342_() + 0.4);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && ModurEliteEntity.this.f_19853_.m_6106_().m_6534_() && !ModurEliteEntity.this.isStormActive();
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 700;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12089_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_LIGHTNING_STORM;
        }
    }

    private class ModurLightningZapGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private BlockPos targetPos;

        private ModurLightningZapGoal() {
            super(new Goal.Flag[0]);
            this.targetPos = BlockPos.f_121853_;
        }

        @Override
        protected void castSpell() {
            if (!this.targetPos.equals((Object)BlockPos.f_121853_)) {
                BlockPos pos = this.targetPos.m_142082_(ModurEliteEntity.this.f_19796_.nextInt(3) - 1, 0, ModurEliteEntity.this.f_19796_.nextInt(3) - 1);
                int times = ModurEliteEntity.this.f_19796_.nextInt(2, 6);
                for (int i = 0; i < times; ++i) {
                    ModurEliteEntity.this.spawnCustomBolt(pos, 15.0f);
                }
            }
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            if (ModurEliteEntity.this.m_5448_() != null) {
                this.targetPos = new BlockPos((Vec3i)ModurEliteEntity.this.m_5448_().m_142538_());
            }
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12521_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_LIGHTNING_ZAP;
        }
    }

    private class ModurShootFireballGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurShootFireballGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ModurEliteEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ModurEliteEntity.this.f_19853_;
            ModurEliteEntity modur = ModurEliteEntity.this;
            if (target != null) {
                int count = switch (level.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> 0;
                    case Difficulty.EASY -> 2;
                    case Difficulty.NORMAL -> 4;
                    case Difficulty.HARD -> 6;
                };
                double dX = target.m_20185_() - modur.m_20185_();
                double dY = target.m_20227_(0.5) - modur.m_20227_(0.5);
                double dZ = target.m_20189_() - modur.m_20189_();
                for (int i = 0; i < count; ++i) {
                    Supplier<Double> modifier_dX = () -> Math.sqrt(Math.sqrt(dX)) * 0.5 * modur.f_19796_.nextGaussian();
                    SmallFireball fireball = new SmallFireball((Level)level, (LivingEntity)modur, dX + modifier_dX.get(), dY, dZ + modifier_dX.get()){
                        private int life;

                        public void onAddedToWorld() {
                            super.onAddedToWorld();
                            this.life = 0;
                        }

                        public void m_8119_() {
                            super.m_8119_();
                            if (this.life != -1 && this.life < 60) {
                                ++this.life;
                            }
                            if (this.life == 60 && !this.m_146910_()) {
                                this.life = -1;
                                this.m_146870_();
                            }
                        }

                        protected void m_5790_(EntityHitResult pResult) {
                            if (pResult.m_82443_() instanceof Raider) {
                                this.m_146870_();
                            } else {
                                super.m_5790_(pResult);
                            }
                        }
                    };
                    fireball.m_6034_(fireball.m_20185_(), modur.m_20227_(0.5) + 0.5, fireball.m_20189_());
                    level.m_7967_((Entity)fireball);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = ModurEliteEntity.this.m_5448_();
            return super.m_8036_() && target != null && (double)target.m_20270_((Entity)ModurEliteEntity.this) > 3.0;
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 40;
        }

        @Override
        protected int getCastWarmupTime() {
            return 5;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11715_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_FIREBALL;
        }
    }
}

