/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractPillagerVariant;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class AssassinIllagerEntity
extends AbstractPillagerVariant {
    private int invisibilityCooldown = 0;

    public AssassinIllagerEntity(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.6, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Cow.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7640_() instanceof IronGolem) {
            pAmount = (float)((double)pAmount * 0.1);
        } else if (DifficultRaidsUtil.isGuardVillagersLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount = (float)((double)pAmount * 0.25);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.invisibilityCooldown > 0) {
            --this.invisibilityCooldown;
            if (this.invisibilityCooldown == 0) {
                this.addInvisibilityEffect();
            }
        }
        if ((target = this.m_5448_()) != null) {
            if (this.m_20270_((Entity)target) > 5.0f && this.f_19796_.nextInt(100) < 25) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 1));
                BlockPos targetPos = target.m_146901_();
                this.m_20984_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), true);
            }
            if (this.m_21023_(MobEffects.f_19609_)) {
                this.m_21195_(MobEffects.f_19609_);
                this.invisibilityCooldown = switch (this.f_19853_.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> 0;
                    case Difficulty.EASY -> 6000;
                    case Difficulty.NORMAL -> 3600;
                    case Difficulty.HARD -> 1200;
                };
            }
        }
    }

    private void addInvisibilityEffect() {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 1728000));
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        ItemStack sword = new ItemStack((ItemLike)Items.f_42383_);
        if (this.isInDifficultRaid()) {
            HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            enchants.put(Enchantments.f_44977_, this.getRaidDifficulty().config().assassin().sharpnessLevel());
            enchants.put(Enchantments.f_44963_, 1);
            EnchantmentHelper.m_44865_(enchants, (ItemStack)sword);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, sword);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!this.isInRaid()) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42425_));
        }
        this.addInvisibilityEffect();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }
}

