/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class ElectroIllagerEntity
extends AbstractEvokerVariant {
    public ElectroIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 25.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ElectroIllagerCastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new ElectroIllagerSummonLightningSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new ElectroIllagerSlownessLightningBoltSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new ElectroIllagerConcentratedLightningBoltSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new ElectroIllagerRingLightningSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.7, 1.0));
        }
    }

    @Override
    protected boolean spawnDefaultSpellcastingParticles() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.isCastingSpell()) {
            AbstractEvokerVariant.SpellType spellType = this.getSpellType();
            double d0 = spellType.getColor(0);
            double d1 = spellType.getColor(1);
            double d2 = spellType.getColor(2);
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() + Math.cos(f) * 0.6, this.m_20186_() + 1.8, this.m_20189_() + Math.sin(f) * 0.6, d0, d1, d2);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() - Math.cos(f) * 0.6, this.m_20186_() + 1.8, this.m_20189_() - Math.sin(f) * 0.6, d0, d1, d2);
        }
    }

    public float m_6073_() {
        return 1.2f;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    private class ElectroIllagerCastingSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private ElectroIllagerCastingSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (ElectroIllagerEntity.this.m_5448_() != null) {
                ElectroIllagerEntity.this.m_21563_().m_24960_((Entity)ElectroIllagerEntity.this.m_5448_(), (float)ElectroIllagerEntity.this.m_8085_(), (float)ElectroIllagerEntity.this.m_8132_());
            }
        }
    }

    private class ElectroIllagerSummonLightningSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerSummonLightningSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_183503_();
            boolean raid = ElectroIllagerEntity.this.m_37885_() != null;
            boolean rain = level.m_46758_(ElectroIllagerEntity.this.m_142538_());
            boolean thunder = level.m_46470_();
            if (target != null) {
                BlockPos targetPos = target.m_142538_();
                Random random = new Random();
                int strikes = raid ? ElectroIllagerEntity.this.getRaidDifficulty().config().electro().genericLightningStrikeCount() : RaidDifficulty.DEFAULT.config().electro().genericLightningStrikeCount();
                strikes += (switch (level.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> -strikes;
                    case Difficulty.EASY -> -2;
                    case Difficulty.NORMAL -> 0;
                    case Difficulty.HARD -> 2;
                });
                strikes = random.nextInt(strikes - 1, strikes + 2);
                strikes = Math.max(1, strikes);
                for (int i = 0; i < strikes; ++i) {
                    BlockPos offsetPos = targetPos.m_142082_(-2 + random.nextInt(5), 0, -2 + random.nextInt(5));
                    LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                    lightning.m_6593_((Component)new TextComponent("DifficultRaids_Electro_Bolt"));
                    float damage = (switch (level.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> 0.0f;
                        case Difficulty.EASY -> 6.0f;
                        case Difficulty.NORMAL -> 8.0f;
                        case Difficulty.HARD -> 10.0f;
                    }) + (rain ? 1.0f : 0.0f) + (thunder ? 2.0f : 0.0f);
                    lightning.setDamage(damage);
                    lightning.m_20035_(offsetPos, 0.0f, 0.0f);
                    level.m_7967_((Entity)lightning);
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 10;
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_SUMMON_BASIC_LIGHTNING_BOLTS;
        }
    }

    private class ElectroIllagerSlownessLightningBoltSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerSlownessLightningBoltSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_183503_();
            if (target != null) {
                BlockPos targetPos = target.m_142538_();
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                lightning.m_6593_((Component)new TextComponent("DifficultRaids_Electro_Bolt"));
                lightning.setDamage(2.0f);
                lightning.m_20035_(targetPos, 0.0f, 0.0f);
                level.m_7967_((Entity)lightning);
                if (target.m_6084_()) {
                    boolean rain = level.m_46758_(ElectroIllagerEntity.this.m_142538_());
                    boolean thunder = level.m_46470_();
                    int slownessLevel = 2 + (rain ? 1 : 0) + (thunder ? 2 : 0);
                    int miningFatigueLevel = 1 + (rain ? 1 : 0);
                    MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, 100, slownessLevel);
                    MobEffectInstance miningFatigue = new MobEffectInstance(MobEffects.f_19599_, 100, miningFatigueLevel);
                    target.m_7292_(slowness);
                    target.m_7292_(miningFatigue);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            boolean hasSlowness = target != null && target.m_21023_(MobEffects.f_19597_);
            boolean hasMiningFatigue = target != null && target.m_21023_(MobEffects.f_19599_);
            boolean hasWeakness = target != null && target.m_21023_(MobEffects.f_19613_);
            return super.m_8036_() && (!hasSlowness || !hasMiningFatigue || !hasWeakness);
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12053_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_SLOWNESS_BOLT;
        }
    }

    private class ElectroIllagerConcentratedLightningBoltSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerConcentratedLightningBoltSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_183503_();
            boolean raid = ElectroIllagerEntity.this.isInRaid();
            boolean rain = level.m_46758_(ElectroIllagerEntity.this.m_142538_());
            boolean thunder = level.m_46470_();
            if (target != null) {
                BlockPos targetPos = target.m_142538_();
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                lightning.m_6593_((Component)new TextComponent("DifficultRaids_Electro_Bolt"));
                float damage = raid ? ElectroIllagerEntity.this.getRaidDifficulty().config().electro().concentratedBoltDamage() : RaidDifficulty.DEFAULT.config().electro().concentratedBoltDamage();
                damage += (switch (level.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> -damage;
                    case Difficulty.EASY -> -2.0f;
                    case Difficulty.NORMAL -> 0.0f;
                    case Difficulty.HARD -> 2.0f;
                });
                if (rain) {
                    damage += 1.0f;
                }
                if (thunder) {
                    double d = damage;
                    damage = (float)(d * (switch (level.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> 0.0;
                        case Difficulty.EASY -> 1.05;
                        case Difficulty.NORMAL -> 1.1;
                        case Difficulty.HARD -> 1.2;
                    }));
                }
                lightning.setDamage(damage);
                lightning.m_20035_(targetPos, 0.0f, 0.0f);
                level.m_7967_((Entity)lightning);
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && ElectroIllagerEntity.this.m_21223_() > ElectroIllagerEntity.this.m_21233_() / 2.0f;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_CONCENTRATED_BOLT;
        }
    }

    private class ElectroIllagerRingLightningSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerRingLightningSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_183503_();
            boolean thunder = level.m_46470_();
            if (target != null) {
                BlockPos targetPos = target.m_142538_();
                int dist = 10;
                ArrayList<BlockPos> offsets = new ArrayList<BlockPos>(List.of(targetPos.m_142082_(dist, 0, 0), targetPos.m_142082_(-dist, 0, 0), targetPos.m_142082_(0, 0, dist), targetPos.m_142082_(0, 0, dist), targetPos.m_142082_(dist, 0, dist), targetPos.m_142082_(dist, 0, -dist), targetPos.m_142082_(-dist, 0, dist), targetPos.m_142082_(-dist, 0, -dist)));
                if (ElectroIllagerEntity.this.m_37885_() != null) {
                    ArrayList extraOffsets = new ArrayList();
                    RaidDifficulty raidDifficulty = ElectroIllagerEntity.this.getRaidDifficulty();
                    if (raidDifficulty.config().electro().extraRingBolts()) {
                        offsets.forEach(pos -> {
                            BlockPos farPos = new BlockPos((Vec3i)pos);
                            if (pos.m_123341_() != 0) {
                                farPos = pos.m_142082_(pos.m_123341_(), 0, 0);
                            }
                            if (pos.m_123343_() != 0) {
                                farPos = pos.m_142082_(0, 0, pos.m_123343_());
                            }
                            extraOffsets.add(farPos);
                        });
                    }
                    offsets.addAll(extraOffsets);
                }
                offsets.forEach(pos -> {
                    LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                    lightning.m_6593_((Component)new TextComponent("DifficultRaids_Electro_Bolt"));
                    lightning.m_20035_(pos, 0.0f, 0.0f);
                    lightning.setDamage(thunder ? 3.0f : 1.0f);
                    level.m_7967_((Entity)lightning);
                });
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && ElectroIllagerEntity.this.m_21223_() < ElectroIllagerEntity.this.m_21233_() / 2.0f;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastWarmupTime() {
            return 80;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_LIGHTNING_RING;
        }
    }
}

