/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractVindicatorVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class TankIllagerEntity
extends AbstractVindicatorVariant {
    public TankIllagerEntity(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        RaidDifficulty raidDifficulty = this.getRaidDifficulty();
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        ItemStack helmet = null;
        ItemStack chestplate = null;
        ItemStack leggings = null;
        ItemStack boots = null;
        if (raidDifficulty.is(RaidDifficulty.DEFAULT)) {
            helmet = new ItemStack((ItemLike)Items.f_42407_);
            chestplate = new ItemStack((ItemLike)Items.f_42408_);
            leggings = new ItemStack((ItemLike)Items.f_42462_);
            boots = new ItemStack((ItemLike)Items.f_42463_);
        } else if (raidDifficulty.is(RaidDifficulty.HERO, RaidDifficulty.LEGEND)) {
            helmet = new ItemStack((ItemLike)Items.f_42468_);
            chestplate = new ItemStack((ItemLike)Items.f_42469_);
            leggings = new ItemStack((ItemLike)Items.f_42470_);
            boots = new ItemStack((ItemLike)Items.f_42471_);
        } else if (raidDifficulty.is(RaidDifficulty.MASTER)) {
            helmet = new ItemStack((ItemLike)Items.f_42472_);
            chestplate = new ItemStack((ItemLike)Items.f_42473_);
            leggings = new ItemStack((ItemLike)Items.f_42474_);
            boots = new ItemStack((ItemLike)Items.f_42475_);
        } else if (raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
            helmet = new ItemStack((ItemLike)Items.f_42480_);
            chestplate = new ItemStack((ItemLike)Items.f_42481_);
            leggings = new ItemStack((ItemLike)Items.f_42482_);
            boots = new ItemStack((ItemLike)Items.f_42483_);
        }
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        enchants.put(Enchantments.f_44965_, raidDifficulty.config().tank().protectionLevel());
        if (this.f_19796_.nextInt(100) < 10 && raidDifficulty.config().tank().thornsLevel() > 0) {
            enchants.put(Enchantments.f_44972_, raidDifficulty.config().tank().thornsLevel());
        }
        if (helmet != null && chestplate != null && leggings != null && boots != null) {
            EnchantmentHelper.m_44865_(Map.copyOf(enchants), (ItemStack)helmet);
            EnchantmentHelper.m_44865_(Map.copyOf(enchants), (ItemStack)chestplate);
            EnchantmentHelper.m_44865_(Map.copyOf(enchants), (ItemStack)leggings);
            EnchantmentHelper.m_44865_(Map.copyOf(enchants), (ItemStack)boots);
            this.m_8061_(EquipmentSlot.HEAD, helmet);
            this.m_8061_(EquipmentSlot.CHEST, chestplate);
            this.m_8061_(EquipmentSlot.LEGS, leggings);
            this.m_8061_(EquipmentSlot.FEET, boots);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!this.isInRaid()) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42425_));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }
}

