/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractVindicatorVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class WarriorIllagerEntity
extends AbstractVindicatorVariant {
    public WarriorIllagerEntity(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        RaidDifficulty raidDifficulty = this.getRaidDifficulty();
        List<Item> swordPool = raidDifficulty.config().warrior().possibleSwords();
        ItemStack sword = new ItemStack((ItemLike)swordPool.get(this.f_19796_.nextInt(swordPool.size())));
        if (!raidDifficulty.isDefault()) {
            HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            if (this.f_19796_.nextInt(100) < raidDifficulty.config().warrior().sharpnessChance()) {
                Tuple<Integer, Integer> minMaxLevel = raidDifficulty.config().warrior().sharpnessLevel();
                if ((Integer)minMaxLevel.m_14419_() < (Integer)minMaxLevel.m_14418_()) {
                    minMaxLevel.m_145023_((Object)1);
                    minMaxLevel.m_145025_((Object)1);
                    LogUtils.getLogger().warn("Invalid config option for Warrior Illager Sharpness Level! Minimum is greater than the maximum! Defaulting to a Sharpness Level of 1.");
                }
                int sharpnessLevel = ((Integer)minMaxLevel.m_14418_()).equals(minMaxLevel.m_14419_()) ? ((Integer)minMaxLevel.m_14418_()).intValue() : this.f_19796_.nextInt((Integer)minMaxLevel.m_14418_(), (Integer)minMaxLevel.m_14419_() + 1);
                enchants.put(Enchantments.f_44977_, sharpnessLevel);
            }
            if (this.f_19796_.nextInt(100) < raidDifficulty.config().warrior().fireAspectChance()) {
                enchants.put(Enchantments.f_44981_, raidDifficulty.config().warrior().fireAspectLevel());
            }
            if (this.f_19796_.nextInt(100) < raidDifficulty.config().warrior().knockbackChance()) {
                enchants.put(Enchantments.f_44980_, raidDifficulty.config().warrior().knockbackLevel());
            }
            if (!sword.m_150930_(Items.f_42383_) && !sword.m_150930_(Items.f_42425_)) {
                enchants.put(Enchantments.f_44963_, 1);
            }
            EnchantmentHelper.m_44865_(enchants, (ItemStack)sword);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, sword);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!this.isInRaid()) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42425_));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }
}

