/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.mixins;

import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.raids.RaidEnemyRegistry;
import com.calculusmaster.difficultraids.raids.RaidLoot;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Raid.class})
public abstract class RaidMixin {
    private int players;
    private AABB validRaidArea;
    @Shadow
    @Final
    private int f_37686_;
    @Shadow
    private int f_37681_;
    @Shadow
    @Final
    private ServerLevel f_37675_;
    @Shadow
    @Final
    private Random f_37685_;
    @Shadow
    private BlockPos f_37674_;
    @Shadow
    @Final
    private Set<UUID> f_37672_;
    @Shadow
    private long f_37673_;
    @Shadow
    @Final
    private ServerBossEvent f_37682_;
    private static final Logger LOGGER = LogUtils.getLogger();

    @Shadow
    public abstract boolean m_37767_();

    @Shadow
    public abstract boolean m_37768_();

    @Shadow
    public abstract void m_37713_(int var1, Raider var2, @Nullable BlockPos var3, boolean var4);

    @Shadow
    public abstract int m_37771_();

    @Shadow
    public abstract int m_37773_();

    @Shadow
    public abstract int m_37778_();

    @Shadow
    public abstract Set<Raider> m_150221_();

    private void initializeValidRaidArea() {
        this.validRaidArea = new AABB(this.f_37674_).m_82400_(Math.sqrt(9216.0));
        this.players = this.f_37675_.m_45976_(Player.class, this.validRaidArea).size();
    }

    @Inject(at={@At(value="TAIL")}, method={"absorbBadOmen"})
    private void difficultraids_raidStart(Player p_37729_, CallbackInfo callbackInfo) {
        this.initializeValidRaidArea();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void difficultraids_addDifficultyToEventBar(CallbackInfo callback) {
        RaidDifficulty raidDifficulty = RaidDifficulty.get(this.m_37773_());
        String title = this.f_37682_.m_18861_().getString();
        if (title.toLowerCase().contains("raid") && !title.toLowerCase().contains(raidDifficulty.getFormattedName().toLowerCase())) {
            this.f_37682_.m_6456_((Component)new TextComponent(raidDifficulty.getFormattedName() + " " + title));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void difficultraids_highlightRemainingRaiders(CallbackInfo callback) {
        if (this.f_37673_ % 5L == 0L && this.m_37778_() <= (Integer)DifficultRaidsConfig.RAIDER_GLOW_THRESHOLD.get()) {
            this.m_150221_().stream().filter(LivingEntity::m_6084_).filter(r -> !r.m_21023_(MobEffects.f_19619_)).forEach(r -> r.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60, 1, false, false)));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnGroup"})
    private void difficultraids_spawnGroup(BlockPos pos, CallbackInfo callbackInfo) {
        if (this.validRaidArea == null) {
            this.initializeValidRaidArea();
        }
        List participants = this.f_37675_.m_45976_(Player.class, this.validRaidArea);
        this.players = participants.size();
        Difficulty levelDifficulty = this.f_37675_.m_46791_();
        RaidDifficulty raidDifficulty = RaidDifficulty.get(this.m_37773_());
        if (this.f_37685_.nextInt(100) < raidDifficulty.config().reinforcementChance()) {
            Map<EntityType<?>, Integer> reinforcements = RaidEnemyRegistry.getReinforcements(this.f_37681_, raidDifficulty, levelDifficulty);
            String sum = "(" + reinforcements.values().stream().mapToInt(i -> i).sum() + ")";
            List<String> messages = List.of("Reinforcements have arrived!", "Additional mobs have joined!", "An extra group of mobs has appeared!", "The Illagers have called in reinforcements!", "The Illagers have called for backup!");
            participants.forEach(p -> p.m_6352_((Component)new TextComponent((String)messages.get(this.f_37685_.nextInt(messages.size())) + " " + sum), p.m_142081_()));
            for (Map.Entry<EntityType<?>, Integer> entityEntry : reinforcements.entrySet()) {
                for (int i2 = 0; i2 < entityEntry.getValue(); ++i2) {
                    EntityType<?> type = entityEntry.getKey();
                    LivingEntity spawn = (LivingEntity)type.m_20615_((Level)this.f_37675_);
                    if (spawn == null) continue;
                    spawn.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    if (spawn instanceof Monster) {
                        Monster mob = (Monster)spawn;
                        mob.m_6518_((ServerLevelAccessor)this.f_37675_, this.f_37675_.m_6436_(mob.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                    }
                    spawn.m_6853_(true);
                    if (List.of(EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20481_).contains(entityEntry.getKey())) {
                        spawn.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
                    }
                    if (spawn instanceof Monster) {
                        Monster monster = (Monster)spawn;
                        path = monster.m_21573_().m_7864_(this.f_37674_, 10);
                        monster.m_21573_().m_26536_(path, 1.3);
                        monster.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)monster, Villager.class, true));
                        monster.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)monster, IronGolem.class, true));
                        monster.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)monster, Player.class, true));
                        if (raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
                            List<Item> armors = List.of(Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_);
                            monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)armors.get(0)));
                            monster.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)armors.get(1)));
                            monster.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)armors.get(2)));
                            monster.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)armors.get(3)));
                        }
                    } else if (spawn instanceof Animal) {
                        Animal animal = (Animal)spawn;
                        path = animal.m_21573_().m_7864_(this.f_37674_, 15);
                        animal.m_21573_().m_26536_(path, 0.5);
                    }
                    this.f_37675_.m_7967_((Entity)spawn);
                }
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"spawnGroup"})
    private void difficultraids_spawnElite(BlockPos spawnPos, CallbackInfo callback) {
        RaidDifficulty raidDifficulty = RaidDifficulty.get(this.m_37773_());
        if (raidDifficulty.config().areElitesEnabled() && raidDifficulty.is(RaidDifficulty.LEGEND, RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER)) {
            int wave = this.m_37771_();
            int eliteTier = RaidEnemyRegistry.getEliteWaveTier(this.f_37675_.m_46791_(), wave);
            if (raidDifficulty.is(RaidDifficulty.LEGEND) && eliteTier == 2) {
                eliteTier = 1;
            }
            if (eliteTier != -1) {
                EntityType<?> eliteType = RaidEnemyRegistry.getRandomElite(eliteTier);
                Entity elite = eliteType.m_20615_((Level)this.f_37675_);
                if (elite instanceof Raider) {
                    Raider raider = (Raider)elite;
                    this.m_37713_(wave, raider, spawnPos, false);
                } else {
                    LOGGER.error("Failed to spawn Raid Elite! {EntityType: " + eliteType.m_147048_() + "}, Wave {" + wave + "}, Elite Tier: {" + eliteTier + "}, Difficulty {" + this.f_37675_.m_46791_() + "}");
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getDefaultNumSpawns"}, cancellable=true)
    private void difficultraids_getDefaultNumSpawns(Raid.RaiderType raiderType, int groupsSpawned, boolean spawnBonusGroup, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        RaidDifficulty raidDifficulty = RaidDifficulty.get(this.m_37773_());
        boolean isDefault = raidDifficulty.isDefault();
        boolean isRegistered = RaidEnemyRegistry.isRaiderTypeRegistered(raiderType.toString());
        boolean isEnabled = RaidEnemyRegistry.isRaiderTypeEnabled(raiderType.toString());
        if (!isDefault && DifficultRaidsUtil.isGuardVillagersLoaded() && raiderType.toString().equalsIgnoreCase("thebluemengroup")) {
            callbackInfoReturnable.setReturnValue((Object)0);
        } else if (isRegistered && !isEnabled) {
            callbackInfoReturnable.setReturnValue((Object)0);
        } else if (!isDefault && isRegistered) {
            int[] spawnsPerWave = RaidEnemyRegistry.getWaves(raidDifficulty, raiderType.toString());
            int baseSpawnCount = spawnBonusGroup ? spawnsPerWave[this.f_37686_] : spawnsPerWave[groupsSpawned];
            callbackInfoReturnable.setReturnValue((Object)baseSpawnCount);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getPotentialBonusSpawns"}, cancellable=true)
    private void difficultraids_getPotentialBonusSpawns(Raid.RaiderType raiderType, Random random, int groupsSpawned, DifficultyInstance difficultyInstance, boolean shouldSpawnBonusGroup, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        if (!RaidDifficulty.get(this.m_37773_()).isDefault()) {
            callbackInfoReturnable.setReturnValue((Object)0);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stop"})
    public void difficultraids_grantRewards(CallbackInfo callbackInfo) {
        RaidDifficulty raidDifficulty = RaidDifficulty.get(this.m_37773_());
        if (this.m_37767_() && !raidDifficulty.isDefault()) {
            BlockPos rewardPos = new BlockPos(this.f_37674_.m_123341_(), this.f_37674_.m_123342_() + 7, this.f_37674_.m_123343_());
            RaidLoot.RaidLootData data = RaidLoot.RAID_LOOT.get((Object)raidDifficulty);
            int emeralds = this.f_37685_.nextInt(data.emeralds[0], data.emeralds[1] + 1);
            for (int i = 0; i < emeralds; ++i) {
                BlockPos pos = rewardPos.m_142082_(this.f_37685_.nextInt(11) - 5, 0, this.f_37685_.nextInt(11) - 5);
                ItemEntity entityItem = new ItemEntity((Level)this.f_37675_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42616_));
                entityItem.m_32064_();
                this.f_37675_.m_7967_((Entity)entityItem);
            }
            int totems = data.totemsPulls.get(this.f_37675_.m_46791_());
            for (int i = 0; i < totems; ++i) {
                BlockPos pos = rewardPos.m_142082_(this.f_37685_.nextInt(5) - 2, 0, this.f_37685_.nextInt(5) - 2);
                Item totem = data.totemsPool.get(this.f_37685_.nextInt(data.totemsPool.size()));
                ItemEntity entityItem = new ItemEntity((Level)this.f_37675_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)totem));
                entityItem.m_32064_();
                this.f_37675_.m_7967_((Entity)entityItem);
            }
            int valuables = data.valuablesPulls.get(this.f_37675_.m_46791_());
            HashMap<Item, Integer> valuablesLoot = new HashMap<Item, Integer>();
            for (int i = 0; i < valuables; ++i) {
                Item item2 = data.pullValuable(this.f_37685_);
                if (item2 != null) {
                    valuablesLoot.put(item2, valuablesLoot.getOrDefault(item2, 0) + 1);
                    continue;
                }
                LOGGER.error("Error pulling valuables Loot Item from a " + raidDifficulty.getFormattedName() + " Raid!");
            }
            valuablesLoot.forEach((item, count) -> {
                ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
                ItemEntity entityItem = new ItemEntity((Level)this.f_37675_, (double)rewardPos.m_123341_(), (double)rewardPos.m_123342_(), (double)rewardPos.m_123343_(), stack);
                entityItem.m_32064_();
                this.f_37675_.m_7967_((Entity)entityItem);
            });
            List<ItemStack> armor = RaidLoot.generateArmorLoot(raidDifficulty);
            armor.forEach(stack -> {
                ItemEntity entityItem = new ItemEntity((Level)this.f_37675_, (double)rewardPos.m_123341_(), (double)rewardPos.m_123342_(), (double)rewardPos.m_123343_(), stack);
                entityItem.m_32064_();
                this.f_37675_.m_7967_((Entity)entityItem);
            });
            for (int i = 0; i < data.enchantmentCount; ++i) {
                ItemStack book = data.pullEnchantment(this.f_37685_);
                ItemEntity entityItem = new ItemEntity((Level)this.f_37675_, (double)rewardPos.m_123341_(), (double)rewardPos.m_123342_(), (double)rewardPos.m_123343_(), book);
                entityItem.m_32064_();
                this.f_37675_.m_7967_((Entity)entityItem);
            }
            this.f_37672_.stream().map(uuid -> this.f_37675_.m_46003_(uuid)).filter(Objects::nonNull).forEach(p -> p.m_6352_((Component)new TextComponent("Raid Rewards have spawned at X: %s Y: %s Z: %s!".formatted(rewardPos.m_123341_(), rewardPos.m_123342_(), rewardPos.m_123343_())), p.m_142081_()));
        } else if (this.m_37768_() && raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
            WitherBoss wither = (WitherBoss)EntityType.f_20496_.m_20615_((Level)this.f_37675_);
            wither.m_6593_((Component)new TextComponent("The Apocalypse"));
            wither.m_6034_((double)this.f_37674_.m_123341_(), (double)(this.f_37674_.m_123342_() + 10), (double)this.f_37674_.m_123343_());
            this.f_37675_.m_7967_((Entity)wither);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"joinRaid"}, ordinal=0, argsOnly=true)
    private BlockPos difficultraids_randomizeSpawnPos(BlockPos spawnPos) {
        if (spawnPos != null) {
            BlockPos spawnOffset;
            int tries = 0;
            while (!this.f_37675_.m_8055_(spawnOffset = spawnPos.m_142082_(this.f_37685_.nextInt(7) - 3, 0, this.f_37685_.nextInt(7) - 3)).m_60795_() && ++tries < 3) {
            }
            return spawnOffset;
        }
        return spawnPos;
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"joinRaid"}, ordinal=0, argsOnly=true)
    private Raider difficultraids_boostRaiderFromPlayerCount(Raider defaultRaider) {
        float healthBoost = switch (this.players) {
            case 1 -> 0.0f;
            case 2 -> 0.5f;
            case 3 -> 1.0f;
            case 4 -> 1.75f;
            case 5 -> 2.5f;
            case 6 -> 3.5f;
            case 7 -> 5.0f;
            default -> 5.0f + (float)this.players * 1.25f;
        };
        AttributeModifier healthBoostModifier = new AttributeModifier("RAID_PLAYER_COUNT_HEALTH_BOOST", (double)healthBoost, AttributeModifier.Operation.ADDITION);
        AttributeInstance health = defaultRaider.m_21051_(Attributes.f_22276_);
        if (health != null) {
            health.m_22125_(healthBoostModifier);
        }
        return defaultRaider;
    }
}

