/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.raids;

import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEnchantments;
import com.calculusmaster.difficultraids.setup.DifficultRaidsItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;
import net.minecraft.world.Difficulty;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class RaidLoot {
    public static final Map<RaidDifficulty, RaidLootData> RAID_LOOT = new LinkedHashMap<RaidDifficulty, RaidLootData>();

    public static void registerLoot() {
        RaidLootData.forRD(RaidDifficulty.HERO).setEmeralds(16, 64).setValuablesPoolPulls(5, 7, 10).setValuablesPool(LootEntry.of(Items.f_42416_, 0.6f), LootEntry.of(Items.f_42417_, 0.3f), LootEntry.of(Items.f_42415_, 0.1f)).setTotemsPoolPulls(1, 2, 3).setTotemsPool(DifficultRaidsItems.TOTEM_OF_SPEED, DifficultRaidsItems.TOTEM_OF_POISON, DifficultRaidsItems.TOTEM_OF_LEVITATION, DifficultRaidsItems.TOTEM_OF_FREEZING).setArmorLoot(new Tuple((Object)ArmorMaterials.IRON, (Object)3), new Tuple((Object)ArmorMaterials.DIAMOND, (Object)1)).setEnchantmentCount(2).setEnchantmentsLoot(new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.RAIDERS_BANE.get(), 3, 1, 2), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get(), 1, 1, 1), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.PROJECTILE_EVASION.get(), 2, 1, 1)).register();
        RaidLootData.forRD(RaidDifficulty.LEGEND).setEmeralds(64, 128).setValuablesPoolPulls(8, 12, 16).setValuablesPool(LootEntry.of(Items.f_42416_, 0.5f), LootEntry.of(Items.f_42417_, 0.3f), LootEntry.of(Items.f_42415_, 0.15f), LootEntry.of(Items.f_42418_, 0.05f)).setTotemsPoolPulls(3, 5, 7).setTotemsPool(DifficultRaidsItems.TOTEM_OF_SPEED, DifficultRaidsItems.TOTEM_OF_POISON, DifficultRaidsItems.TOTEM_OF_LEVITATION, DifficultRaidsItems.TOTEM_OF_LIGHTNING, DifficultRaidsItems.TOTEM_OF_TELEPORTATION, DifficultRaidsItems.TOTEM_OF_FIREBALLS, DifficultRaidsItems.TOTEM_OF_FREEZING, DifficultRaidsItems.TOTEM_OF_PERSISTENCE).setArmorLoot(new Tuple((Object)ArmorMaterials.IRON, (Object)2), new Tuple((Object)ArmorMaterials.DIAMOND, (Object)2)).setEnchantmentCount(4).setEnchantmentsLoot(new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.RAIDERS_BANE.get(), 5, 1, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.INVISIBILITY.get(), 4, 1, 2), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get(), 2, 1, 1), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_BURST.get(), 2, 1, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_RESISTANCE.get(), 2, 1, 2), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.LIGHTNING_RESISTANCE.get(), 1, 1, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.PROJECTILE_EVASION.get(), 3, 1, 2)).register();
        RaidLootData.forRD(RaidDifficulty.MASTER).setEmeralds(128, 256).setValuablesPoolPulls(12, 16, 20).setValuablesPool(LootEntry.of(Items.f_42416_, 0.3f), LootEntry.of(Items.f_42417_, 0.3f), LootEntry.of(Items.f_42415_, 0.25f), LootEntry.of(Items.f_42418_, 0.15f)).setTotemsPoolPulls(5, 7, 9).setTotemsPool(DifficultRaidsItems.TOTEM_OF_SPEED, DifficultRaidsItems.TOTEM_OF_POISON, DifficultRaidsItems.TOTEM_OF_LEVITATION, DifficultRaidsItems.TOTEM_OF_LIGHTNING, DifficultRaidsItems.TOTEM_OF_TELEPORTATION, DifficultRaidsItems.TOTEM_OF_FIREBALLS, DifficultRaidsItems.TOTEM_OF_FREEZING, DifficultRaidsItems.TOTEM_OF_PERSISTENCE, DifficultRaidsItems.TOTEM_OF_DESTINY, DifficultRaidsItems.TOTEM_OF_PROTECTION).setArmorLoot(new Tuple((Object)ArmorMaterials.DIAMOND, (Object)3), new Tuple((Object)ArmorMaterials.NETHERITE, (Object)1)).setEnchantmentCount(6).setEnchantmentsLoot(new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.RAIDERS_BANE.get(), 4, 2, 4), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.INVISIBILITY.get(), 2, 1, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get(), 2, 1, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_BURST.get(), 2, 2, 5), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_RESISTANCE.get(), 2, 1, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.LIGHTNING_RESISTANCE.get(), 2, 1, 5), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.PROJECTILE_EVASION.get(), 3, 1, 3)).register();
        RaidLootData.forRD(RaidDifficulty.GRANDMASTER).setEmeralds(320, 640).setValuablesPoolPulls(25, 30, 50).setValuablesPool(LootEntry.of(Items.f_42416_, 0.325f), LootEntry.of(Items.f_42417_, 0.25f), LootEntry.of(Items.f_42415_, 0.3f), LootEntry.of(Items.f_42418_, 0.175f)).setTotemsPoolPulls(8, 10, 12).setTotemsPool(DifficultRaidsItems.TOTEM_OF_SPEED, DifficultRaidsItems.TOTEM_OF_POISON, DifficultRaidsItems.TOTEM_OF_LEVITATION, DifficultRaidsItems.TOTEM_OF_LIGHTNING, DifficultRaidsItems.TOTEM_OF_TELEPORTATION, DifficultRaidsItems.TOTEM_OF_FIREBALLS, DifficultRaidsItems.TOTEM_OF_FREEZING, DifficultRaidsItems.TOTEM_OF_PERSISTENCE, DifficultRaidsItems.TOTEM_OF_DESTINY, DifficultRaidsItems.TOTEM_OF_PROTECTION).setArmorLoot(new Tuple((Object)ArmorMaterials.NETHERITE, (Object)1)).setEnchantmentCount(10).setEnchantmentsLoot(new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.RAIDERS_BANE.get(), 1, 3, 5), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.INVISIBILITY.get(), 1, 2, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get(), 1, 2, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_BURST.get(), 1, 3, 6), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.CRITICAL_RESISTANCE.get(), 1, 2, 3), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.LIGHTNING_RESISTANCE.get(), 1, 3, 5), new EnchantmentLootEntry((Enchantment)DifficultRaidsEnchantments.PROJECTILE_EVASION.get(), 1, 2, 3)).register();
    }

    public static List<ItemStack> generateArmorLoot(RaidDifficulty rd) {
        Random r = new Random();
        if (!rd.is(RaidDifficulty.DEFAULT, RaidDifficulty.GRANDMASTER)) {
            int count = switch (rd) {
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                default -> 0;
            };
            RaidLootData data = RAID_LOOT.get((Object)rd);
            ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
            for (int i = 0; i < count; ++i) {
                int[] nArray;
                ItemStack armor = new ItemStack((ItemLike)data.armorMaterials.get(r.nextInt(data.armorMaterials.size())));
                HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                switch (rd) {
                    case HERO: {
                        int[] nArray2 = new int[2];
                        nArray2[0] = 1;
                        nArray = nArray2;
                        nArray2[1] = 3;
                        break;
                    }
                    case LEGEND: {
                        int[] nArray3 = new int[2];
                        nArray3[0] = 1;
                        nArray = nArray3;
                        nArray3[1] = 4;
                        break;
                    }
                    case MASTER: {
                        int[] nArray4 = new int[2];
                        nArray4[0] = 2;
                        nArray = nArray4;
                        nArray4[1] = 5;
                        break;
                    }
                    default: {
                        int[] nArray5 = new int[2];
                        nArray5[0] = 0;
                        nArray = nArray5;
                        nArray5[1] = 0;
                    }
                }
                int[] protectionLevels = nArray;
                int protection = r.nextInt(protectionLevels[0], protectionLevels[1] + 1);
                enchantments.put(Enchantments.f_44965_, protection);
                int unbreaking = switch (rd) {
                    case RaidDifficulty.HERO -> 1;
                    case RaidDifficulty.LEGEND -> 2;
                    case RaidDifficulty.MASTER -> 3;
                    default -> 0;
                };
                enchantments.put(Enchantments.f_44986_, unbreaking);
                if (rd.is(RaidDifficulty.MASTER)) {
                    enchantments.put(Enchantments.f_44962_, 1);
                }
                EnchantmentHelper.m_44865_(enchantments, (ItemStack)armor);
                loot.add(armor);
            }
            return loot;
        }
        if (rd.is(RaidDifficulty.GRANDMASTER)) {
            ArrayList<ItemStack> pieces = new ArrayList<ItemStack>();
            List<Item> pool = List.of((Item)DifficultRaidsItems.GRANDMASTER_HELMET.get(), (Item)DifficultRaidsItems.GRANDMASTER_CHESTPLATE.get(), (Item)DifficultRaidsItems.GRANDMASTER_LEGGINGS.get(), (Item)DifficultRaidsItems.GRANDMASTER_BOOTS.get());
            int count = r.nextInt(2, 4);
            for (int i = 0; i < count; ++i) {
                pieces.add(new ItemStack((ItemLike)pool.get(r.nextInt(pool.size()))));
            }
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            enchantments.put(Enchantments.f_44965_, 6);
            enchantments.put(Enchantments.f_44986_, 5);
            enchantments.put(Enchantments.f_44962_, 1);
            pieces.forEach(stack -> EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack));
            return pieces;
        }
        return new ArrayList<ItemStack>();
    }

    public static class RaidLootData {
        private RaidDifficulty raidDifficulty;
        public int[] emeralds = new int[2];
        public Map<Difficulty, Integer> valuablesPulls = new LinkedHashMap<Difficulty, Integer>();
        public List<LootEntry> valuablesPool = new ArrayList<LootEntry>();
        public Map<Difficulty, Integer> totemsPulls = new LinkedHashMap<Difficulty, Integer>();
        public List<Item> totemsPool = new ArrayList<Item>();
        public List<Item> armorMaterials = new ArrayList<Item>();
        public int enchantmentCount = 0;
        public List<EnchantmentLootEntry> enchantmentsPool = new ArrayList<EnchantmentLootEntry>();

        RaidLootData() {
        }

        static RaidLootData forRD(RaidDifficulty raidDifficulty) {
            RaidLootData data = new RaidLootData();
            data.raidDifficulty = raidDifficulty;
            return data;
        }

        final RaidLootData setEmeralds(int min, int max) {
            this.emeralds = new int[]{min, max};
            return this;
        }

        final RaidLootData setValuablesPoolPulls(int easy, int normal, int hard) {
            this.valuablesPulls.put(Difficulty.EASY, easy);
            this.valuablesPulls.put(Difficulty.NORMAL, normal);
            this.valuablesPulls.put(Difficulty.HARD, hard);
            return this;
        }

        final RaidLootData setValuablesPool(LootEntry ... entries) {
            this.valuablesPool = new ArrayList<LootEntry>(List.of(entries));
            return this;
        }

        final RaidLootData setTotemsPoolPulls(int easy, int normal, int hard) {
            this.totemsPulls.put(Difficulty.EASY, easy);
            this.totemsPulls.put(Difficulty.NORMAL, normal);
            this.totemsPulls.put(Difficulty.HARD, hard);
            return this;
        }

        @SafeVarargs
        final RaidLootData setTotemsPool(RegistryObject<Item> ... totems) {
            this.totemsPool.addAll(Stream.of(totems).map(RegistryObject::get).toList());
            return this;
        }

        @SafeVarargs
        final RaidLootData setArmorLoot(Tuple<ArmorMaterials, Integer> ... armorMaterials) {
            for (Tuple<ArmorMaterials, Integer> pair : armorMaterials) {
                ArmorMaterials a = (ArmorMaterials)pair.m_14418_();
                for (int i = 0; i < (Integer)pair.m_14419_(); ++i) {
                    if (a.equals((Object)ArmorMaterials.IRON)) {
                        this.armorMaterials.addAll(List.of(Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_));
                        continue;
                    }
                    if (a.equals((Object)ArmorMaterials.DIAMOND)) {
                        this.armorMaterials.addAll(List.of(Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_));
                        continue;
                    }
                    if (!a.equals((Object)ArmorMaterials.NETHERITE)) continue;
                    this.armorMaterials.addAll(List.of(Items.f_42480_, Items.f_42481_, Items.f_42482_, Items.f_42483_));
                }
            }
            return this;
        }

        final RaidLootData setEnchantmentCount(int count) {
            this.enchantmentCount = count;
            return this;
        }

        final RaidLootData setEnchantmentsLoot(EnchantmentLootEntry ... enchantments) {
            this.enchantmentsPool.addAll(List.of(enchantments));
            return this;
        }

        public final Item pullValuable(Random rand) {
            float r = rand.nextFloat();
            for (int i = 0; i < this.valuablesPool.size(); ++i) {
                float threshold = this.valuablesPool.get((int)i).chance;
                if (i > 0) {
                    for (int j = i - 1; j >= 0; --j) {
                        threshold += this.valuablesPool.get((int)j).chance;
                    }
                }
                if (!(r < threshold)) continue;
                return this.valuablesPool.get((int)i).item;
            }
            return null;
        }

        public final ItemStack pullEnchantment(Random rand) {
            ArrayList<EnchantmentLootEntry> pool = new ArrayList<EnchantmentLootEntry>();
            for (EnchantmentLootEntry e : this.enchantmentsPool) {
                for (int i = 0; i < e.weight(); ++i) {
                    pool.add(e);
                }
            }
            EnchantmentLootEntry selected = (EnchantmentLootEntry)pool.get(rand.nextInt(pool.size()));
            int level = selected.minLevel() == selected.maxLevel() ? selected.maxLevel() : rand.nextInt(selected.minLevel(), selected.maxLevel() + 1);
            return EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(selected.enchantment(), level));
        }

        void register() {
            RAID_LOOT.put(this.raidDifficulty, this);
        }
    }

    public static class LootEntry {
        public Item item;
        public float chance;

        static LootEntry of(Item item, float chance) {
            LootEntry entry = new LootEntry();
            entry.item = item;
            entry.chance = chance;
            return entry;
        }
    }

    private record EnchantmentLootEntry(Enchantment enchantment, int weight, int minLevel, int maxLevel) {
    }
}

