/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.setup;

import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class DifficultRaidsConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Map<String, ForgeConfigSpec.BooleanValue> ENABLED_RAIDERS;
    public static ForgeConfigSpec.IntValue RAIDER_GLOW_THRESHOLD;
    public static RaidDifficultyConfig DEFAULT_CONFIG;
    public static RaidDifficultyConfig HERO_CONFIG;
    public static RaidDifficultyConfig LEGEND_CONFIG;
    public static RaidDifficultyConfig MASTER_CONFIG;
    public static RaidDifficultyConfig APOCALYPSE_CONFIG;

    public static void register() {
        ForgeConfigSpec.Builder SERVER = new ForgeConfigSpec.Builder();
        SERVER.push("Illagers");
        ENABLED_RAIDERS = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        ENABLED_RAIDERS.put("VINDICATOR", SERVER.comment("Determines if Vindicators will show up in Raids.").define("enableVindicators", true));
        ENABLED_RAIDERS.put("EVOKER", SERVER.comment("Determines if Evokers will show up in Raids.").define("enableEvokers", true));
        ENABLED_RAIDERS.put("PILLAGER", SERVER.comment("Determines if Pillagers will show up in Raids.").define("enablePillagers", true));
        ENABLED_RAIDERS.put("WITCH", SERVER.comment("Determines if Witches will show up in Raids.").define("enableWitches", true));
        ENABLED_RAIDERS.put("RAVAGER", SERVER.comment("Determines if Ravagers will show up in Raids.").define("enableRavagers", true));
        ENABLED_RAIDERS.put("ILLUSIONER", SERVER.comment("Determines if Illusioners will show up in Raids.").define("enableIllusioners", true));
        ENABLED_RAIDERS.put("WARRIOR_ILLAGER", SERVER.comment("Determines if Warriors will show up in Raids.").define("enableWarriors", true));
        ENABLED_RAIDERS.put("DART_ILLAGER", SERVER.comment("Determines if Darts will show up in Raids.").define("enableDarts", true));
        ENABLED_RAIDERS.put("ELECTRO_ILLAGER", SERVER.comment("Determines if Conductors will show up in Raids.").define("enableConductors", true));
        ENABLED_RAIDERS.put("NECROMANCER_ILLAGER", SERVER.comment("Determines if Necromancers will show up in Raids.").define("enableNecromancers", true));
        ENABLED_RAIDERS.put("SHAMAN_ILLAGER", SERVER.comment("Determines if Shamans will show up in Raids.").define("enableShamans", true));
        ENABLED_RAIDERS.put("TANK_ILLAGER", SERVER.comment("Determines if Tanks will show up in Raids.").define("enableTanks", true));
        ENABLED_RAIDERS.put("ASSASSIN_ILLAGER", SERVER.comment("Determines if Assassins will show up in Raids.").define("enableAssassins", true));
        ENABLED_RAIDERS.put("FROST_ILLAGER", SERVER.comment("Determines if Frostmages will show up in Raids.").define("enableFrostmages", true));
        ENABLED_RAIDERS.put("HUNTERILLAGER", SERVER.comment("(IF HunterIllager IS INSTALLED) Determines if Hunters will show up in Raids.").define("enableHunters", true));
        ENABLED_RAIDERS.put("ENCHANTER", SERVER.comment("(IF EnchantWithMob IS INSTALLED) Determines if Enchanters will show up in Raids.").define("enableEnchanters", true));
        SERVER.pop();
        RAIDER_GLOW_THRESHOLD = SERVER.comment("Determines the threshold (number of remaining raiders) for when a permanent glowing effect will be applied to all remaining raiders.").defineInRange("raiderGlowThreshold", 3, 0, Integer.MAX_VALUE);
        for (RaidDifficulty raidDifficulty : RaidDifficulty.values()) {
            RaidDifficultyConfig config = new RaidDifficultyConfig();
            ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
            BUILDER.comment("Adjust settings for " + raidDifficulty.getFormattedName() + " Difficulty Raids.");
            config.elitesEnabled = BUILDER.comment("Toggle whether Elite Raiders will spawn in Raids or not. On Hero, Elites will not spawn regardless of this, and on Legend, only Tier 1 elites will spawn if enabled.").define("elitesEnabled", true);
            int default_reinforcementChance = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 15;
                case RaidDifficulty.LEGEND -> 25;
                case RaidDifficulty.MASTER -> 40;
                case RaidDifficulty.GRANDMASTER -> 80;
                default -> 0;
            };
            config.reinforcementChance = BUILDER.comment("Determines the chance that Reinforcements will spawn on any wave of a Raid.").defineInRange("reinforcementChance", default_reinforcementChance, 0, 100);
            int default_armorChance = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 10;
                case RaidDifficulty.LEGEND -> 25;
                case RaidDifficulty.MASTER -> 40;
                case RaidDifficulty.GRANDMASTER -> 80;
                default -> 0;
            };
            config.armorChance = BUILDER.comment("Determines the chance that an individual Raider will be wearing some armor during a Raid.").defineInRange("armorChance", default_armorChance, 0, 100);
            int default_maxArmorPieces = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 1;
                case RaidDifficulty.GRANDMASTER -> 4;
                default -> 0;
            };
            config.maxArmorPieces = BUILDER.comment("Determines the maximum pieces of armor Raiders can have equipped.").defineInRange("maxArmorPieces", default_maxArmorPieces, 0, 4);
            List default_validArmorTiers = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> List.of("LEATHER", "CHAIN", "IRON");
                case RaidDifficulty.LEGEND -> List.of("CHAIN", "IRON", "DIAMOND");
                case RaidDifficulty.MASTER -> List.of("IRON", "DIAMOND", "NETHERITE");
                case RaidDifficulty.GRANDMASTER -> List.of("DIAMOND", "NETHERITE");
                default -> List.of();
            };
            config.validArmorTiers = BUILDER.comment("Valid tiers of armor that Raiders can have equipped during Raids. Valid values: LEATHER, CHAIN, IRON, DIAMOND, NETHERITE (Case-Sensitive!).").defineList("validArmorTiers", default_validArmorTiers, o -> List.of("LEATHER", "CHAIN", "IRON", "DIAMOND", "NETHERITE").contains(o.toString()));
            int default_protectionChance = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 5;
                case RaidDifficulty.LEGEND -> 10;
                case RaidDifficulty.MASTER -> 15;
                case RaidDifficulty.GRANDMASTER -> 40;
                default -> 0;
            };
            config.protectionChance = BUILDER.comment("Determines the chance that Raider armor will be enchanted with Protection.").defineInRange("protectionChance", default_protectionChance, 0, 100);
            Tuple default_protectionLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> new Tuple((Object)1, (Object)2);
                case RaidDifficulty.LEGEND -> new Tuple((Object)1, (Object)4);
                case RaidDifficulty.MASTER -> new Tuple((Object)3, (Object)4);
                case RaidDifficulty.GRANDMASTER -> new Tuple((Object)4, (Object)5);
                default -> new Tuple((Object)0, (Object)0);
            };
            config.minProtectionLevel = BUILDER.comment("The maximum level of Protection that any Raider's armor will be enchanted with.").defineInRange("minProtectionLevel", ((Integer)default_protectionLevel.m_14418_()).intValue(), 0, 10);
            config.maxProtectionLevel = BUILDER.comment("The minimum level of Protection that any Raider's armor will be enchanted with.").defineInRange("maxProtectionLevel", ((Integer)default_protectionLevel.m_14419_()).intValue(), 0, 10);
            BUILDER.comment("Change settings regarding the Assassin Illager Entity during Raids.").push("Assassin Illager");
            config.assassinConfig = new AssassinIllagerConfig();
            int default_assassin_sharpnessLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 5;
                default -> 0;
            };
            config.assassinConfig.sharpnessLevel = BUILDER.comment("Determines the level of Sharpness that Assassin Illager Swords will be enchanted with.").defineInRange("assassinSharpnessLevel", default_assassin_sharpnessLevel, 0, 10);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Dart Illager Entity during Raids.").push("Dart Illager");
            config.dartConfig = new DartIllagerConfig();
            int default_dart_sharpnessLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
                default -> 0;
            };
            config.dartConfig.sharpnessLevel = BUILDER.comment("Determines the level of Sharpness that Dart Illager Swords will be enchanted with.").defineInRange("dartSharpnessLevel", default_dart_sharpnessLevel, 0, 10);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Electro Illager Entity during Raids.").push("Electro Illager");
            config.electroConfig = new ElectroIllagerConfig();
            double default_electro_concentratedBoltDamage = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 19.0;
                case RaidDifficulty.LEGEND -> 20.0;
                case RaidDifficulty.MASTER -> 24.0;
                case RaidDifficulty.GRANDMASTER -> 30.0;
                default -> 18.0;
            };
            config.electroConfig.concentratedBoltDamage = BUILDER.comment("The damage that the Electro Illager's Concentrated Bolt spell deals.").defineInRange("electroConcentratedBoltDamage", default_electro_concentratedBoltDamage, 0.1, Double.MAX_VALUE);
            int default_electro_genericLightningStrikeCount = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 4;
                case RaidDifficulty.LEGEND -> 6;
                case RaidDifficulty.MASTER -> 8;
                case RaidDifficulty.GRANDMASTER -> 10;
                default -> 3;
            };
            config.electroConfig.genericLightningStrikeCount = BUILDER.comment("Determines the number of lightning strikes generated by the Electro Illager's Generic Lightning attack.").defineInRange("electroGenericLightningStrikeCount", default_electro_genericLightningStrikeCount, 1, Integer.MAX_VALUE);
            boolean default_electro_extraRingBolts = raidDifficulty.is(RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER);
            config.electroConfig.extraRingBolts = BUILDER.comment("If true, Electro Illagers will summon a second set of Lightning Bolts during their Ring Lightning attack.").define("electroExtraRingBolts", default_electro_extraRingBolts);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Frost Illager Entity during Raids.").push("Frost Illager");
            config.frostConfig = new FrostIllagerConfig();
            float default_frost_snowballBlastDamage = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 3.5f;
                case RaidDifficulty.LEGEND -> 5.5f;
                case RaidDifficulty.MASTER -> 7.0f;
                case RaidDifficulty.GRANDMASTER -> 10.0f;
                default -> 1.5f;
            };
            config.frostConfig.snowballBlastDamage = BUILDER.comment("Determines the damage of individual snowballs in the Frost Illager's Snowball Blast attack").defineInRange("frostSnowballBlastDamage", (double)default_frost_snowballBlastDamage, 0.1, Double.MAX_VALUE);
            int default_frost_barrageDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 140;
                case RaidDifficulty.LEGEND -> 240;
                case RaidDifficulty.MASTER -> 300;
                case RaidDifficulty.GRANDMASTER -> 400;
                default -> 60;
            };
            config.frostConfig.barrageDuration = BUILDER.comment("Determines the duration of the Frost Illager's Barrage attack, in ticks (20 ticks = 1 second).").defineInRange("frostBarrageDuration", default_frost_barrageDuration, 1, Integer.MAX_VALUE);
            int default_frost_freezeDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 120;
                case RaidDifficulty.LEGEND -> 160;
                case RaidDifficulty.MASTER -> 200;
                case RaidDifficulty.GRANDMASTER -> 300;
                default -> 80;
            };
            config.frostConfig.freezeDuration = BUILDER.comment("Determines the duration of the Frost Illager's Freeze attack, in ticks (20 ticks = 1 second). Mining Fatigue duration will be 1/4 of this value.").defineInRange("frostFreezeDuration", default_frost_freezeDuration, 1, Integer.MAX_VALUE);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Necromancer Illager Entity during Raids.").push("Necromancer Illager");
            config.necromancerConfig = new NecromancerIllagerConfig();
            int default_necromancer_minionSummonCount = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 5;
                case RaidDifficulty.GRANDMASTER -> 10;
                default -> 0;
            };
            config.necromancerConfig.minionSummonCount = BUILDER.comment("The number of mobs spawned when the Necromancer uses its Summon Minions attack.").defineInRange("necromancerMinionSummonCount", default_necromancer_minionSummonCount, 0, Integer.MAX_VALUE);
            int default_necromancer_minionProtectionLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 4;
                default -> 0;
            };
            config.necromancerConfig.minionProtectionLevel = BUILDER.comment("The maximum level of Protection a Summoned Minion's armor will be enchanted with. The actual level of Protection will randomly chosen between 1 and this value. 0 removes this enchantment from Minion armor.").defineInRange("minionProtectionLevel", default_necromancer_minionProtectionLevel, 0, 10);
            int default_necromancer_hordeSize = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 10;
                case RaidDifficulty.LEGEND -> 15;
                case RaidDifficulty.MASTER -> 20;
                case RaidDifficulty.GRANDMASTER -> 30;
                default -> 5;
            };
            config.necromancerConfig.hordeSize = BUILDER.comment("The number of mobs spawned when the Necromancer uses its Summon Horde attack.").defineInRange("necromancerHordeSize", default_necromancer_hordeSize, 0, Integer.MAX_VALUE);
            int default_necromancer_hordeLifetime = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 600;
                case RaidDifficulty.LEGEND -> 1200;
                case RaidDifficulty.MASTER -> 1800;
                case RaidDifficulty.GRANDMASTER -> 3600;
                default -> 300;
            };
            config.necromancerConfig.hordeLifetime = BUILDER.comment("How long Necromancer Summoned Hordes will be alive before dying automatically, in ticks (20 ticks = 1 second).").defineInRange("necromancerHordeLifetime", default_necromancer_hordeLifetime, 0, Integer.MAX_VALUE);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Shaman Illager Entity during Raids.").push("Shaman Illager");
            config.shamanConfig = new ShamanIllagerConfig();
            int default_shaman_debuffAmount = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
                default -> 1;
            };
            config.shamanConfig.debuffAmount = BUILDER.comment("The amount of debuffs the Shaman will inflict during its primary attack.").defineInRange("shamanDebuffAmount", default_shaman_debuffAmount, 0, 6);
            int default_shaman_nauseaDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 40;
                case RaidDifficulty.LEGEND -> 60;
                case RaidDifficulty.MASTER -> 80;
                case RaidDifficulty.GRANDMASTER -> 160;
                default -> 20;
            };
            config.shamanConfig.nauseaDuration = BUILDER.comment("Duration of the Nausea Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanNauseaDuration", default_shaman_nauseaDuration, 0, Integer.MAX_VALUE);
            int default_shaman_slownessDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 100;
                case RaidDifficulty.MASTER -> 160;
                case RaidDifficulty.GRANDMASTER -> 240;
                default -> 60;
            };
            config.shamanConfig.slownessDuration = BUILDER.comment("Duration of the Slowness Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanSlownessDuration", default_shaman_slownessDuration, 0, Integer.MAX_VALUE);
            int default_shaman_slownessAmplifier = switch (raidDifficulty) {
                case RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 1;
            };
            config.shamanConfig.slownessAmplifier = BUILDER.comment("Amplifier of the Slowness Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanSlownessAmplifier", default_shaman_slownessAmplifier, 0, Integer.MAX_VALUE);
            int default_shaman_MiningFatigueDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 100;
                case RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 160;
                case RaidDifficulty.GRANDMASTER -> 280;
                default -> 40;
            };
            config.shamanConfig.miningFatigueDuration = BUILDER.comment("Duration of the Mining Fatigue Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanMiningFatigueDuration", default_shaman_MiningFatigueDuration, 0, Integer.MAX_VALUE);
            int default_shaman_miningFatigueAmplifier = switch (raidDifficulty) {
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 1;
            };
            config.shamanConfig.miningFatigueAmplifier = BUILDER.comment("Amplifier of the Mining Fatigue Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanMiningFatigueAmplifier", default_shaman_miningFatigueAmplifier, 0, Integer.MAX_VALUE);
            int default_shaman_poisonDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 100;
                case RaidDifficulty.GRANDMASTER -> 200;
                default -> 50;
            };
            config.shamanConfig.poisonDuration = BUILDER.comment("Duration of the Poison Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanPoisonDuration", default_shaman_poisonDuration, 0, Integer.MAX_VALUE);
            int default_shaman_poisonAmplifier = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
                default -> 1;
            };
            config.shamanConfig.poisonAmplifier = BUILDER.comment("Amplifier of the Poison Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanPoisonAmplifier", default_shaman_poisonAmplifier, 0, Integer.MAX_VALUE);
            int default_shaman_levitationDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 40;
                case RaidDifficulty.LEGEND -> 80;
                case RaidDifficulty.MASTER -> 100;
                case RaidDifficulty.GRANDMASTER -> 160;
                default -> 20;
            };
            config.shamanConfig.levitationDuration = BUILDER.comment("Duration of the Levitation Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanLevitationDuration", default_shaman_levitationDuration, 0, Integer.MAX_VALUE);
            int default_shaman_weaknessDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 60;
                case RaidDifficulty.LEGEND -> 100;
                case RaidDifficulty.MASTER -> 120;
                case RaidDifficulty.GRANDMASTER -> 200;
                default -> 20;
            };
            config.shamanConfig.weaknessDuration = BUILDER.comment("Weakness of the Weakness Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanWeaknessDuration", default_shaman_weaknessDuration, 0, Integer.MAX_VALUE);
            int default_shaman_weaknessAmplifier = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 4;
                default -> 1;
            };
            config.shamanConfig.weaknessAmplifier = BUILDER.comment("Amplifier of the Weakness Effect inflicted by the Shaman, in ticks (20 ticks = 1 second).").defineInRange("shamanWeaknessAmplifier", default_shaman_weaknessAmplifier, 0, Integer.MAX_VALUE);
            float default_shaman_buffRadius = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 5.0f;
                case RaidDifficulty.LEGEND -> 8.0f;
                case RaidDifficulty.MASTER -> 12.0f;
                case RaidDifficulty.GRANDMASTER -> 20.0f;
                default -> 3.0f;
            };
            config.shamanConfig.buffRadius = BUILDER.comment("The maximum radius of the Shaman's boost attacks. All raiders within this radius of the Shaman will receive boosts.").defineInRange("shamanBuffRadius", (double)default_shaman_buffRadius, 0.0, Double.MAX_VALUE);
            int default_shaman_allyResistanceDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 80;
                case RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 160;
                case RaidDifficulty.GRANDMASTER -> 360;
                default -> 40;
            };
            config.shamanConfig.allyResistanceDuration = BUILDER.comment("The duration of the Resistance Effect that the Shaman gives its allies.").defineInRange("shamanAllyResistanceDuration", default_shaman_allyResistanceDuration, 0, Integer.MAX_VALUE);
            int default_shaman_allyResistanceAmplifier = switch (raidDifficulty) {
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 1;
            };
            config.shamanConfig.allyResistanceAmplifier = BUILDER.comment("The amplifier of the Resistance Effect that the Shaman gives its allies.").defineInRange("shamanAllyResistanceAmplifier", default_shaman_allyResistanceAmplifier, 0, Integer.MAX_VALUE);
            int default_shaman_allyStrengthDuration = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.MASTER -> 200;
                case RaidDifficulty.LEGEND, RaidDifficulty.GRANDMASTER -> 480;
                default -> 120;
            };
            config.shamanConfig.allyStrengthDuration = BUILDER.comment("The duration of the Strength Effect that the Shaman gives its allies.").defineInRange("shamanAllyStrengthDuration", default_shaman_allyStrengthDuration, 0, Integer.MAX_VALUE);
            int default_shaman_allyStrengthAmplifier = switch (raidDifficulty) {
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 1;
            };
            config.shamanConfig.allyStrengthAmplifier = BUILDER.comment("The amplifier of the Strength Effect that the Shaman gives its allies.").defineInRange("shamanAllyStrengthAmplifier", default_shaman_allyStrengthAmplifier, 0, Integer.MAX_VALUE);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Tank Illager Entity during Raids.").push("Tank Illager");
            config.tankConfig = new TankIllagerConfig();
            int default_tank_protectionLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
                default -> 1;
            };
            config.tankConfig.protectionLevel = BUILDER.comment("Determines the level of Protection that Tank Illager armor will be enchanted with. 0 to disable.").defineInRange("tankProtectionLevel", default_tank_protectionLevel, 0, 10);
            int default_tank_thornsLevel = switch (raidDifficulty) {
                case RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 0;
            };
            config.tankConfig.thornsLevel = BUILDER.comment("Determines the level of Thorns that Tank Illager armor will be enchanted with. 0 to disable.").defineInRange("tankThornsLevel", default_tank_thornsLevel, 0, 10);
            BUILDER.pop();
            BUILDER.comment("Change settings regarding the Warrior Illager Entity during Raids.").push("Warrior Illager");
            config.warriorConfig = new WarriorIllagerConfig();
            List<String> default_warrior_possibleSwords = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> List.of("STONE", "GOLD", "IRON");
                case RaidDifficulty.LEGEND -> List.of("IRON", "DIAMOND");
                case RaidDifficulty.MASTER -> List.of("IRON", "DIAMOND", "NETHERITE");
                case RaidDifficulty.GRANDMASTER -> List.of("NETHERITE");
                default -> List.of("STONE");
            };
            config.warriorConfig.possibleSwords = BUILDER.comment("Determines the possible swords that Warrior Illagers can have equipped during Raids. Valid Swords: STONE, GOLD, IRON, DIAMOND, NETHERITE (Case-Sensitive!).").defineList("warriorPossibleSwords", default_warrior_possibleSwords, o -> List.of("STONE", "GOLD", "IRON", "DIAMOND", "NETHERITE").contains(o.toString()));
            int default_warrior_sharpnessChance = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 20;
                case RaidDifficulty.LEGEND -> 35;
                case RaidDifficulty.MASTER -> 45;
                case RaidDifficulty.GRANDMASTER -> 90;
                default -> 0;
            };
            config.warriorConfig.sharpnessChance = BUILDER.comment("Determines the chance that Warrior Illager swords will be enchanted with some level of Sharpness.").defineInRange("warriorSharpnessChance", default_warrior_sharpnessChance, 0, 100);
            Tuple default_warrior_sharpnessLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> new Tuple((Object)1, (Object)3);
                case RaidDifficulty.LEGEND -> new Tuple((Object)2, (Object)4);
                case RaidDifficulty.MASTER -> new Tuple((Object)3, (Object)5);
                case RaidDifficulty.GRANDMASTER -> new Tuple((Object)4, (Object)6);
                default -> new Tuple((Object)0, (Object)0);
            };
            config.warriorConfig.minSharpnessLevel = BUILDER.comment("The minimum level of Sharpness that Warrior Illager swords will be enchanted with.").defineInRange("warriorMinSharpnessLevel", ((Integer)default_warrior_sharpnessLevel.m_14418_()).intValue(), 1, 10);
            config.warriorConfig.maxSharpnessLevel = BUILDER.comment("The maximum level of Sharpness that Warrior Illager swords will be enchanted with.").defineInRange("warriorMaxSharpnessLevel", ((Integer)default_warrior_sharpnessLevel.m_14419_()).intValue(), 1, 10);
            int default_warrior_fireAspectChance = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 5;
                case RaidDifficulty.LEGEND -> 10;
                case RaidDifficulty.MASTER -> 15;
                case RaidDifficulty.GRANDMASTER -> 50;
                default -> 0;
            };
            config.warriorConfig.fireAspectChance = BUILDER.comment("Determines the chance that Warrior Illager swords will be enchanted with some level of Fire Aspect.").defineInRange("warriorFireAspectChance", default_warrior_fireAspectChance, 0, 100);
            int default_warrior_fireAspectLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 0;
            };
            config.warriorConfig.fireAspectLevel = BUILDER.comment("The level of Fire Aspect that Warrior Illager swords will be enchanted with.").defineInRange("warriorFireAspectLevel", default_warrior_fireAspectLevel, 1, 10);
            int default_warrior_knockbackChance = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 10;
                case RaidDifficulty.LEGEND -> 15;
                case RaidDifficulty.MASTER -> 20;
                case RaidDifficulty.GRANDMASTER -> 90;
                default -> 0;
            };
            config.warriorConfig.knockbackChance = BUILDER.comment("Determines the chance that Warrior Illager swords will be enchanted with some level of Knockback.").defineInRange("warriorKnockbackChance", default_warrior_knockbackChance, 0, 100);
            int default_warrior_knockbackLevel = switch (raidDifficulty) {
                case RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
                default -> 0;
            };
            config.warriorConfig.knockbackLevel = BUILDER.comment("The level of Knockback that Warrior Illager swords will be enchanted with.").defineInRange("warriorKnockbackLevel", default_warrior_knockbackLevel, 1, 10);
            BUILDER.pop();
            switch (raidDifficulty) {
                case DEFAULT: {
                    DEFAULT_CONFIG = config;
                    break;
                }
                case HERO: {
                    HERO_CONFIG = config;
                    break;
                }
                case LEGEND: {
                    LEGEND_CONFIG = config;
                    break;
                }
                case MASTER: {
                    MASTER_CONFIG = config;
                    break;
                }
                case GRANDMASTER: {
                    APOCALYPSE_CONFIG = config;
                }
            }
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)BUILDER.build(), "difficultraids/difficulty-" + raidDifficulty.toString().toLowerCase() + ".toml");
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER.build(), "difficultraids/general.toml");
    }

    public static class RaidDifficultyConfig {
        private ForgeConfigSpec.BooleanValue elitesEnabled;
        private ForgeConfigSpec.IntValue reinforcementChance;
        private ForgeConfigSpec.IntValue armorChance;
        private ForgeConfigSpec.IntValue maxArmorPieces;
        private ForgeConfigSpec.ConfigValue<List<? extends String>> validArmorTiers;
        private ForgeConfigSpec.IntValue protectionChance;
        private ForgeConfigSpec.IntValue minProtectionLevel;
        private ForgeConfigSpec.IntValue maxProtectionLevel;
        private AssassinIllagerConfig assassinConfig;
        private DartIllagerConfig dartConfig;
        private ElectroIllagerConfig electroConfig;
        private FrostIllagerConfig frostConfig;
        private NecromancerIllagerConfig necromancerConfig;
        private ShamanIllagerConfig shamanConfig;
        private TankIllagerConfig tankConfig;
        private WarriorIllagerConfig warriorConfig;

        public boolean areElitesEnabled() {
            return (Boolean)this.elitesEnabled.get();
        }

        public int reinforcementChance() {
            return (Integer)this.reinforcementChance.get();
        }

        public int armorChance() {
            return (Integer)this.armorChance.get();
        }

        public int maxArmorPieces() {
            return (Integer)this.maxArmorPieces.get();
        }

        public List<ArmorMaterials> validArmorTiers() {
            return ((List)this.validArmorTiers.get()).stream().map(String::toString).map(s -> switch (s) {
                case "LEATHER" -> ArmorMaterials.LEATHER;
                case "CHAIN" -> ArmorMaterials.CHAIN;
                case "IRON" -> ArmorMaterials.IRON;
                case "DIAMOND" -> ArmorMaterials.DIAMOND;
                case "NETHERITE" -> ArmorMaterials.NETHERITE;
                default -> null;
            }).filter(Objects::nonNull).toList();
        }

        public int protectionChance() {
            return (Integer)this.protectionChance.get();
        }

        public Tuple<Integer, Integer> protectionLevel() {
            return new Tuple((Object)((Integer)this.minProtectionLevel.get()), (Object)((Integer)this.maxProtectionLevel.get()));
        }

        public AssassinIllagerConfig assassin() {
            return this.assassinConfig;
        }

        public DartIllagerConfig dart() {
            return this.dartConfig;
        }

        public ElectroIllagerConfig electro() {
            return this.electroConfig;
        }

        public FrostIllagerConfig frost() {
            return this.frostConfig;
        }

        public NecromancerIllagerConfig necromancer() {
            return this.necromancerConfig;
        }

        public ShamanIllagerConfig shaman() {
            return this.shamanConfig;
        }

        public TankIllagerConfig tank() {
            return this.tankConfig;
        }

        public WarriorIllagerConfig warrior() {
            return this.warriorConfig;
        }
    }

    public static class AssassinIllagerConfig {
        private ForgeConfigSpec.IntValue sharpnessLevel;

        public int sharpnessLevel() {
            return (Integer)this.sharpnessLevel.get();
        }
    }

    public static class DartIllagerConfig {
        private ForgeConfigSpec.IntValue sharpnessLevel;

        public int sharpnessLevel() {
            return (Integer)this.sharpnessLevel.get();
        }
    }

    public static class ElectroIllagerConfig {
        private ForgeConfigSpec.DoubleValue concentratedBoltDamage;
        private ForgeConfigSpec.IntValue genericLightningStrikeCount;
        private ForgeConfigSpec.BooleanValue extraRingBolts;

        public float concentratedBoltDamage() {
            return ((Double)this.concentratedBoltDamage.get()).floatValue();
        }

        public int genericLightningStrikeCount() {
            return (Integer)this.genericLightningStrikeCount.get();
        }

        public boolean extraRingBolts() {
            return (Boolean)this.extraRingBolts.get();
        }
    }

    public static class FrostIllagerConfig {
        private ForgeConfigSpec.DoubleValue snowballBlastDamage;
        private ForgeConfigSpec.IntValue barrageDuration;
        private ForgeConfigSpec.IntValue freezeDuration;

        public float snowballBlastDamage() {
            return ((Double)this.snowballBlastDamage.get()).floatValue();
        }

        public int barrageDuration() {
            return (Integer)this.barrageDuration.get();
        }

        public int freezeDuration() {
            return (Integer)this.freezeDuration.get();
        }
    }

    public static class NecromancerIllagerConfig {
        public ForgeConfigSpec.IntValue minionSummonCount;
        private ForgeConfigSpec.IntValue minionProtectionLevel;
        private ForgeConfigSpec.IntValue hordeSize;
        private ForgeConfigSpec.IntValue hordeLifetime;

        public int minionSummonCount() {
            return (Integer)this.minionSummonCount.get();
        }

        public int minionProtectionLevel() {
            return (Integer)this.minionProtectionLevel.get();
        }

        public int hordeSize() {
            return (Integer)this.hordeSize.get();
        }

        public int hordeLifetime() {
            return (Integer)this.hordeLifetime.get();
        }
    }

    public static class ShamanIllagerConfig {
        private ForgeConfigSpec.IntValue debuffAmount;
        private ForgeConfigSpec.IntValue nauseaDuration;
        private ForgeConfigSpec.IntValue slownessDuration;
        private ForgeConfigSpec.IntValue slownessAmplifier;
        private ForgeConfigSpec.IntValue miningFatigueDuration;
        private ForgeConfigSpec.IntValue miningFatigueAmplifier;
        private ForgeConfigSpec.IntValue poisonDuration;
        private ForgeConfigSpec.IntValue poisonAmplifier;
        private ForgeConfigSpec.IntValue levitationDuration;
        private ForgeConfigSpec.IntValue weaknessDuration;
        private ForgeConfigSpec.IntValue weaknessAmplifier;
        private ForgeConfigSpec.DoubleValue buffRadius;
        private ForgeConfigSpec.IntValue allyResistanceDuration;
        private ForgeConfigSpec.IntValue allyResistanceAmplifier;
        private ForgeConfigSpec.IntValue allyStrengthDuration;
        private ForgeConfigSpec.IntValue allyStrengthAmplifier;

        public int debuffAmount() {
            return (Integer)this.debuffAmount.get();
        }

        public int nauseaDuration() {
            return (Integer)this.nauseaDuration.get();
        }

        public int slownessDuration() {
            return (Integer)this.slownessDuration.get();
        }

        public int slownessAmplifier() {
            return (Integer)this.slownessAmplifier.get();
        }

        public int miningFatigueDuration() {
            return (Integer)this.miningFatigueDuration.get();
        }

        public int miningFatigueAmplifier() {
            return (Integer)this.miningFatigueAmplifier.get();
        }

        public int poisonDuration() {
            return (Integer)this.poisonDuration.get();
        }

        public int poisonAmplifier() {
            return (Integer)this.poisonAmplifier.get();
        }

        public int levitationDuration() {
            return (Integer)this.levitationDuration.get();
        }

        public int weaknessDuration() {
            return (Integer)this.weaknessDuration.get();
        }

        public int weaknessAmplifier() {
            return (Integer)this.weaknessAmplifier.get();
        }

        public float buffRadius() {
            return ((Double)this.buffRadius.get()).floatValue();
        }

        public int allyResistanceDuration() {
            return (Integer)this.allyResistanceDuration.get();
        }

        public int allyResistanceAmplifier() {
            return (Integer)this.allyResistanceAmplifier.get();
        }

        public int allyStrengthDuration() {
            return (Integer)this.allyStrengthDuration.get();
        }

        public int allyStrengthAmplifier() {
            return (Integer)this.allyStrengthAmplifier.get();
        }
    }

    public static class TankIllagerConfig {
        private ForgeConfigSpec.IntValue protectionLevel;
        private ForgeConfigSpec.IntValue thornsLevel;

        public int protectionLevel() {
            return (Integer)this.protectionLevel.get();
        }

        public int thornsLevel() {
            return (Integer)this.thornsLevel.get();
        }
    }

    public static class WarriorIllagerConfig {
        private ForgeConfigSpec.ConfigValue<List<? extends String>> possibleSwords;
        private ForgeConfigSpec.IntValue sharpnessChance;
        private ForgeConfigSpec.IntValue minSharpnessLevel;
        private ForgeConfigSpec.IntValue maxSharpnessLevel;
        private ForgeConfigSpec.IntValue fireAspectChance;
        private ForgeConfigSpec.IntValue fireAspectLevel;
        private ForgeConfigSpec.IntValue knockbackChance;
        private ForgeConfigSpec.IntValue knockbackLevel;

        public List<Item> possibleSwords() {
            return ((List)this.possibleSwords.get()).stream().map(String::toString).map(s -> switch (s) {
                case "STONE" -> Items.f_42425_;
                case "GOLD" -> Items.f_42430_;
                case "IRON" -> Items.f_42383_;
                case "DIAMOND" -> Items.f_42388_;
                case "NETHERITE" -> Items.f_42393_;
                default -> null;
            }).filter(Objects::nonNull).toList();
        }

        public int sharpnessChance() {
            return (Integer)this.sharpnessChance.get();
        }

        public Tuple<Integer, Integer> sharpnessLevel() {
            return new Tuple((Object)((Integer)this.minSharpnessLevel.get()), (Object)((Integer)this.maxSharpnessLevel.get()));
        }

        public int fireAspectChance() {
            return (Integer)this.fireAspectChance.get();
        }

        public int fireAspectLevel() {
            return (Integer)this.fireAspectLevel.get();
        }

        public int knockbackChance() {
            return (Integer)this.knockbackChance.get();
        }

        public int knockbackLevel() {
            return (Integer)this.knockbackLevel.get();
        }
    }
}

