/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.setup;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.items.GMArmorItem;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DifficultRaidsItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"difficultraids");
    private static final Supplier<Item.Properties> DEFAULT_TOTEM_PROPERTIES = () -> new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40757_).m_41497_(Rarity.UNCOMMON).m_41486_();
    public static final RegistryObject<Item> TOTEM_OF_INVISIBILITY = ITEMS.register("invisibility_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_LIGHTNING = ITEMS.register("lightning_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_POISON = ITEMS.register("poison_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_SPEED = ITEMS.register("speed_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_VENGEANCE = ITEMS.register("vengeance_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_DESTINY = ITEMS.register("destiny_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get().m_41497_(Rarity.RARE)));
    public static final RegistryObject<Item> TOTEM_OF_LEVITATION = ITEMS.register("levitation_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_PROTECTION = ITEMS.register("protection_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get().m_41497_(Rarity.RARE)));
    public static final RegistryObject<Item> TOTEM_OF_FREEZING = ITEMS.register("freezing_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_PERSISTENCE = ITEMS.register("persistence_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get().m_41497_(Rarity.RARE)));
    public static final RegistryObject<Item> TOTEM_OF_TELEPORTATION = ITEMS.register("teleportation_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> TOTEM_OF_FIREBALLS = ITEMS.register("fireball_totem", () -> new Item(DEFAULT_TOTEM_PROPERTIES.get()));
    public static final RegistryObject<Item> GRANDMASTER_HELMET = ITEMS.register("grandmaster_helmet", () -> new GMArmorItem(EquipmentSlot.HEAD));
    public static final RegistryObject<Item> GRANDMASTER_CHESTPLATE = ITEMS.register("grandmaster_chestplate", () -> new GMArmorItem(EquipmentSlot.CHEST));
    public static final RegistryObject<Item> GRANDMASTER_LEGGINGS = ITEMS.register("grandmaster_leggings", () -> new GMArmorItem(EquipmentSlot.LEGS));
    public static final RegistryObject<Item> GRANDMASTER_BOOTS = ITEMS.register("grandmaster_boots", () -> new GMArmorItem(EquipmentSlot.FEET));
    public static final RegistryObject<Item> SPAWN_EGG_WARRIOR_ILLAGER = DifficultRaidsItems.registerSpawnEgg("warrior_illager", DifficultRaidsEntityTypes.WARRIOR_ILLAGER, 10792624);
    public static final RegistryObject<Item> SPAWN_EGG_DART_ILLAGER = DifficultRaidsItems.registerSpawnEgg("dart_illager", DifficultRaidsEntityTypes.DART_ILLAGER, 12040350);
    public static final RegistryObject<Item> SPAWN_EGG_ELECTRO_ILLAGER = DifficultRaidsItems.registerSpawnEgg("electro_illager", DifficultRaidsEntityTypes.ELECTRO_ILLAGER, 11119881);
    public static final RegistryObject<Item> SPAWN_EGG_NECROMANCER_ILLAGER = DifficultRaidsItems.registerSpawnEgg("necromancer_illager", DifficultRaidsEntityTypes.NECROMANCER_ILLAGER, 3943767);
    public static final RegistryObject<Item> SPAWN_EGG_SHAMAN_ILLAGER = DifficultRaidsItems.registerSpawnEgg("shaman_illager", DifficultRaidsEntityTypes.SHAMAN_ILLAGER, 3904568);
    public static final RegistryObject<Item> SPAWN_EGG_TANK_ILLAGER = DifficultRaidsItems.registerSpawnEgg("tank_illager", DifficultRaidsEntityTypes.TANK_ILLAGER, 0x2B2B2B);
    public static final RegistryObject<Item> SPAWN_EGG_ASSASSIN_ILLAGER = DifficultRaidsItems.registerSpawnEgg("assassin_illager", DifficultRaidsEntityTypes.ASSASSIN_ILLAGER, 0xF7F7F0);
    public static final RegistryObject<Item> SPAWN_EGG_FROST_ILLAGER = DifficultRaidsItems.registerSpawnEgg("frost_illager", DifficultRaidsEntityTypes.FROST_ILLAGER, 5943748);

    private static <T extends Mob> RegistryObject<Item> registerSpawnEgg(String name, RegistryObject<EntityType<T>> entityType, int highlight) {
        return ITEMS.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)entityType, 5659484, highlight, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

