/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.smart.render.SRInstall;
import net.smart.render.render.SRRenderData;
import net.smart.utilities.Reflect;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class SRModelRotationRenderer
extends ModelRenderer {
    protected static final float RadiantToAngle = 57.295776f;
    protected static final float Whole = (float)Math.PI * 2;
    protected static final float Half = (float)Math.PI;
    private static FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private static float[] array = new float[16];
    private SRModelRotationRenderer base;
    public boolean ignoreRender;
    public boolean forceRender;
    private boolean compiled = false;
    private int displayList;
    public int rotationOrder = XYZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public boolean ignoreBase;
    public boolean ignoreSuperRotation;
    public static int XYZ = 0;
    public static int XZY = 1;
    public static int YXZ = 2;
    public static int YZX = 3;
    public static int ZXY = 4;
    public static int ZYX = 5;
    public boolean fadeEnabled;
    private boolean fadeOffsetX;
    private boolean fadeOffsetY;
    private boolean fadeOffsetZ;
    public boolean fadeRotateAngleX;
    public boolean fadeRotateAngleY;
    public boolean fadeRotateAngleZ;
    private boolean fadeRotationPointX;
    private boolean fadeRotationPointY;
    private boolean fadeRotationPointZ;
    public SRRenderData previous;
    private static Field _compiled = Reflect.GetField(ModelRenderer.class, SRInstall.ModelRenderer_compiled);
    private static Method _compileDisplayList = Reflect.GetMethod(ModelRenderer.class, SRInstall.ModelRenderer_compileDisplayList, Float.TYPE);
    private static Field _displayList = Reflect.GetField(ModelRenderer.class, SRInstall.ModelRenderer_displayList);

    public SRModelRotationRenderer(ModelBase modelBase, int i, int j, SRModelRotationRenderer baseRenderer) {
        super(modelBase, i, j);
        this.base = baseRenderer;
        if (this.base != null) {
            this.base.func_78792_a(this);
        }
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.fadeEnabled = false;
    }

    public void func_78785_a(float f) {
        if (!this.ignoreRender && !this.ignoreBase || this.forceRender) {
            this.doRender(f, this.ignoreBase);
        }
    }

    public void renderIgnoreBase(float f) {
        if (this.ignoreBase) {
            this.doRender(f, false);
        }
    }

    public void doRender(float f, boolean useParentTransformations) {
        if (!this.preRender(f)) {
            return;
        }
        this.preTransforms(f, true, useParentTransformations);
        GL11.glCallList((int)this.displayList);
        if (this.field_78805_m != null) {
            for (int i = 0; i < this.field_78805_m.size(); ++i) {
                ((ModelRenderer)this.field_78805_m.get(i)).func_78785_a(f);
            }
        }
        this.postTransforms(f, true, useParentTransformations);
    }

    public boolean preRender(float f) {
        if (this.field_78807_k) {
            return false;
        }
        if (!this.field_78806_j) {
            return false;
        }
        if (!this.compiled) {
            this.UpdateCompiled();
        }
        if (!this.compiled) {
            Reflect.Invoke(_compileDisplayList, (Object)this, Float.valueOf(f));
            this.UpdateDisplayList();
            this.compiled = true;
        }
        return true;
    }

    public void preTransforms(float f, boolean push, boolean useParentTransformations) {
        if (this.base != null && !this.ignoreBase && useParentTransformations) {
            this.base.preTransforms(f, push, true);
        }
        this.preTransform(f, push);
    }

    public void preTransform(float f, boolean push) {
        if (this.field_78795_f != 0.0f || this.field_78796_g != 0.0f || this.field_78808_h != 0.0f || this.ignoreSuperRotation) {
            if (push) {
                GL11.glPushMatrix();
            }
            GL11.glTranslatef((float)(this.field_78800_c * f), (float)(this.field_78797_d * f), (float)(this.field_78798_e * f));
            if (this.ignoreSuperRotation) {
                buffer.rewind();
                GL11.glGetFloat((int)2982, (FloatBuffer)buffer);
                buffer.get(array);
                GL11.glLoadIdentity();
                GL11.glTranslatef((float)(array[12] / array[15]), (float)(array[13] / array[15]), (float)(array[14] / array[15]));
            }
            SRModelRotationRenderer.rotate(this.rotationOrder, this.field_78795_f, this.field_78796_g, this.field_78808_h);
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
        } else if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.field_82906_o != 0.0f || this.field_82908_p != 0.0f || this.field_82907_q != 0.0f) {
            GL11.glTranslatef((float)(this.field_78800_c * f), (float)(this.field_78797_d * f), (float)(this.field_78798_e * f));
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
        }
    }

    private static void rotate(int rotationOrder, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        if (rotationOrder == ZXY && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotationOrder == YXZ && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == YZX || rotationOrder == YXZ || rotationOrder == ZXY || rotationOrder == ZYX) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if ((rotationOrder == XZY || rotationOrder == ZYX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == XZY || rotationOrder == YZX || rotationOrder == ZXY || rotationOrder == ZYX) && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == YXZ || rotationOrder == YZX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == XYZ || rotationOrder == XZY) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    public void postTransform(float f, boolean pop) {
        if (this.field_78795_f != 0.0f || this.field_78796_g != 0.0f || this.field_78808_h != 0.0f || this.ignoreSuperRotation) {
            if (pop) {
                GL11.glPopMatrix();
            }
        } else if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.field_82906_o != 0.0f || this.field_82908_p != 0.0f || this.field_82907_q != 0.0f) {
            GL11.glTranslatef((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
            GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
            GL11.glTranslatef((float)(-this.field_78800_c * f), (float)(-this.field_78797_d * f), (float)(-this.field_78798_e * f));
        }
    }

    public void postTransforms(float f, boolean pop, boolean useParentTransformations) {
        this.postTransform(f, pop);
        if (this.base != null && !this.ignoreBase && useParentTransformations) {
            this.base.postTransforms(f, pop, true);
        }
    }

    public void reset() {
        this.rotationOrder = XYZ;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.field_78800_c = 0.0f;
        this.field_78797_d = 0.0f;
        this.field_78798_e = 0.0f;
        this.field_78795_f = 0.0f;
        this.field_78796_g = 0.0f;
        this.field_78808_h = 0.0f;
        this.ignoreBase = false;
        this.ignoreSuperRotation = false;
        this.forceRender = false;
        this.field_82906_o = 0.0f;
        this.field_82908_p = 0.0f;
        this.field_82907_q = 0.0f;
        this.fadeOffsetX = false;
        this.fadeOffsetY = false;
        this.fadeOffsetZ = false;
        this.fadeRotateAngleX = false;
        this.fadeRotateAngleY = false;
        this.fadeRotateAngleZ = false;
        this.fadeRotationPointX = false;
        this.fadeRotationPointY = false;
        this.fadeRotationPointZ = false;
        this.previous = null;
    }

    public void func_78791_b(float f) {
        boolean update = !this.compiled;
        super.func_78791_b(f);
        if (update) {
            this.UpdateLocals();
        }
    }

    public void func_78794_c(float f) {
        boolean update;
        boolean bl = update = !this.compiled;
        if (!this.preRender(f)) {
            return;
        }
        if (update) {
            this.UpdateLocals();
        }
        this.preTransforms(f, false, true);
    }

    private void UpdateLocals() {
        this.UpdateCompiled();
        if (this.compiled) {
            this.UpdateDisplayList();
        }
    }

    private void UpdateCompiled() {
        this.compiled = (Boolean)Reflect.GetField(_compiled, (Object)this);
    }

    private void UpdateDisplayList() {
        this.displayList = (Integer)Reflect.GetField(_displayList, (Object)this);
    }

    public void fadeStore(float totalTime) {
        if (this.previous != null) {
            this.previous.offsetX = this.field_82906_o;
            this.previous.offsetY = this.field_82908_p;
            this.previous.offsetZ = this.field_82907_q;
            this.previous.rotateAngleX = this.field_78795_f;
            this.previous.rotateAngleY = this.field_78796_g;
            this.previous.rotateAngleZ = this.field_78808_h;
            this.previous.rotationPointX = this.field_78800_c;
            this.previous.rotationPointY = this.field_78797_d;
            this.previous.rotationPointZ = this.field_78798_e;
            this.previous.totalTime = totalTime;
        }
    }

    public void fadeIntermediate(float totalTime) {
        if (this.previous != null && totalTime - this.previous.totalTime <= 2.0f) {
            this.field_82906_o = SRModelRotationRenderer.GetIntermediatePosition(this.previous.offsetX, this.field_82906_o, this.fadeOffsetX, this.previous.totalTime, totalTime);
            this.field_82908_p = SRModelRotationRenderer.GetIntermediatePosition(this.previous.offsetY, this.field_82908_p, this.fadeOffsetY, this.previous.totalTime, totalTime);
            this.field_82907_q = SRModelRotationRenderer.GetIntermediatePosition(this.previous.offsetZ, this.field_82907_q, this.fadeOffsetZ, this.previous.totalTime, totalTime);
            this.field_78795_f = SRModelRotationRenderer.GetIntermediateAngle(this.previous.rotateAngleX, this.field_78795_f, this.fadeRotateAngleX, this.previous.totalTime, totalTime);
            this.field_78796_g = SRModelRotationRenderer.GetIntermediateAngle(this.previous.rotateAngleY, this.field_78796_g, this.fadeRotateAngleY, this.previous.totalTime, totalTime);
            this.field_78808_h = SRModelRotationRenderer.GetIntermediateAngle(this.previous.rotateAngleZ, this.field_78808_h, this.fadeRotateAngleZ, this.previous.totalTime, totalTime);
            this.field_78800_c = SRModelRotationRenderer.GetIntermediatePosition(this.previous.rotationPointX, this.field_78800_c, this.fadeRotationPointX, this.previous.totalTime, totalTime);
            this.field_78797_d = SRModelRotationRenderer.GetIntermediatePosition(this.previous.rotationPointY, this.field_78797_d, this.fadeRotationPointY, this.previous.totalTime, totalTime);
            this.field_78798_e = SRModelRotationRenderer.GetIntermediatePosition(this.previous.rotationPointZ, this.field_78798_e, this.fadeRotationPointZ, this.previous.totalTime, totalTime);
        }
    }

    public boolean canBeRandomBoxSource() {
        return true;
    }

    private static float GetIntermediatePosition(float prevPosition, float shouldPosition, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldPosition == prevPosition) {
            return shouldPosition;
        }
        return prevPosition + (shouldPosition - prevPosition) * (totalTime - lastTotalTime) * 0.2f;
    }

    private static float GetIntermediateAngle(float prevAngle, float shouldAngle, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldAngle == prevAngle) {
            return shouldAngle;
        }
        while (prevAngle >= (float)Math.PI * 2) {
            prevAngle -= (float)Math.PI * 2;
        }
        while (prevAngle < 0.0f) {
            prevAngle += (float)Math.PI * 2;
        }
        while (shouldAngle >= (float)Math.PI * 2) {
            shouldAngle -= (float)Math.PI * 2;
        }
        while (shouldAngle < 0.0f) {
            shouldAngle += (float)Math.PI * 2;
        }
        if (shouldAngle > prevAngle && shouldAngle - prevAngle > (float)Math.PI) {
            prevAngle += (float)Math.PI * 2;
        }
        if (shouldAngle < prevAngle && prevAngle - shouldAngle > (float)Math.PI) {
            shouldAngle += (float)Math.PI * 2;
        }
        return prevAngle + (shouldAngle - prevAngle) * (totalTime - lastTotalTime) * 0.2f;
    }
}

