/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.smart.moving.ISMClient;
import net.smart.moving.SMContext;

public class SMClient
implements ISMClient {
    private final Map<String, Float> maximumExhaustionValues = new HashMap<String, Float>();
    private boolean nativeUserInterfaceDrawing = true;

    @Override
    public float getMaximumExhaustion() {
        float maxExhaustion = SMContext.Config.getMaxExhaustion();
        if (this.maximumExhaustionValues.size() > 0) {
            Iterator<Float> iterator = this.maximumExhaustionValues.values().iterator();
            while (iterator.hasNext()) {
                maxExhaustion = Math.max(iterator.next().floatValue(), maxExhaustion);
            }
        }
        return maxExhaustion;
    }

    @Override
    public float getMaximumUpJumpCharge() {
        return ((Float)SMContext.Config._jumpChargeMaximum.value).floatValue();
    }

    @Override
    public float getMaximumHeadJumpCharge() {
        return ((Float)SMContext.Config._headJumpChargeMaximum.value).floatValue();
    }

    @Override
    public void setMaximumExhaustionValue(String key, float value) {
        this.maximumExhaustionValues.put(key, Float.valueOf(value));
    }

    @Override
    public float getMaximumExhaustionValue(String key) {
        return this.maximumExhaustionValues.get(key).floatValue();
    }

    @Override
    public boolean removeMaximumExhaustionValue(String key) {
        return this.maximumExhaustionValues.remove(key) != null;
    }

    @Override
    public void setNativeUserInterfaceDrawing(boolean value) {
        this.nativeUserInterfaceDrawing = value;
    }

    @Override
    public boolean getNativeUserInterfaceDrawing() {
        return this.nativeUserInterfaceDrawing;
    }
}

