/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.smart.moving.SMClient;
import net.smart.moving.SMFactory;
import net.smart.moving.SMServer;
import net.smart.moving.config.SMClientConfig;
import net.smart.moving.config.SMOptions;
import net.smart.render.statistics.SmartStatisticsContext;

public abstract class SMContext {
    public static final SMClient Client = new SMClient();
    public static final SMOptions Options = new SMOptions();
    public static SMClientConfig Config = Options;
    private static MinecraftServer lastMinecraftServer = null;
    private static boolean initialized;

    public static void onTickInGame() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e != null && minecraft.field_71441_e.field_72995_K) {
            SMFactory.handleMultiPlayerTick(minecraft);
        }
        Options.initializeForGameIfNeccessary();
        SMContext.initializeServerIfNecessary();
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        SmartStatisticsContext.setCalculateHorizontalStats((boolean)true);
        ClientRegistry.registerKeyBinding((KeyBinding)SMContext.Options.keyBindGrab);
        ClientRegistry.registerKeyBinding((KeyBinding)SMContext.Options.keyBindConfigToggle);
        ClientRegistry.registerKeyBinding((KeyBinding)SMContext.Options.keyBindSpeedIncrease);
        ClientRegistry.registerKeyBinding((KeyBinding)SMContext.Options.keyBindSpeedDecrease);
        initialized = true;
    }

    public static void initializeServerIfNecessary() {
        MinecraftServer currentMinecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (currentMinecraftServer != null && currentMinecraftServer != lastMinecraftServer) {
            int gameTypeID = currentMinecraftServer.func_71265_f().func_77148_a();
            SMServer.initialize(SMOptions.optionsPath, gameTypeID, Options);
        }
        lastMinecraftServer = currentMinecraftServer;
    }

    public static IBlockState getState(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos);
    }

    public static IBlockState getState(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z));
    }
}

