/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import api.player.model.ModelPlayerAPI;
import api.player.model.ModelPlayerBaseSorting;
import api.player.render.RenderPlayerAPI;
import api.player.render.RenderPlayerBaseSorting;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.smart.moving.SMContext;
import net.smart.moving.SMFactory;
import net.smart.moving.SMInstall;
import net.smart.moving.SMLocalUserNameProvider;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.SMPlayerBase;
import net.smart.moving.SMServer;
import net.smart.moving.SMServerComm;
import net.smart.moving.SMServerPlayerBase;
import net.smart.moving.config.SMConfig;
import net.smart.moving.config.SMOptions;
import net.smart.moving.model.SMModelPlayerBase;
import net.smart.moving.render.SMRenderPlayerBase;
import net.smart.render.SRInfo;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;

@Mod(modid="smartmoving", name="Smart Moving", version="1.12.2-17.0-RC4", useMetadata=true)
public class SMMod {
    static final String ID = "smartmoving";
    static final String NAME = "Smart Moving";
    static final String VERSION = "1.12.2-17.0-RC4";
    protected static String ModComVersion = "2.4";
    private final boolean isClient = FMLCommonHandler.instance().getSide().isClient();
    private boolean hasRenderer = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (this.isClient) {
            this.register();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        SMPacketHandler.registerPackets();
        if (this.isClient) {
            SMPlayerBase.registerPlayerBase();
            SMServerPlayerBase.registerPlayerBase();
            SMServerComm.localUserNameProvider = new SMLocalUserNameProvider();
            MinecraftForge.EVENT_BUS.register((Object)this);
            SMFactory.initialize();
            this.checkForMods();
            SMContext.initialize();
        } else {
            SMServer.initialize(new File("."), FMLCommonHandler.instance().getMinecraftServerInstance().func_71265_f().func_77148_a(), new SMConfig());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.isClient) {
            SMServerPlayerBase.registerPlayerBase();
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        SMContext.onTickInGame();
    }

    private void register() {
        String[] inferiors = new String[]{SRInfo.ModName};
        RenderPlayerBaseSorting renderSorting = new RenderPlayerBaseSorting();
        renderSorting.setAfterLocalConstructingInferiors(inferiors);
        renderSorting.setOverrideDoRenderInferiors(inferiors);
        renderSorting.setOverrideRotateCorpseInferiors(inferiors);
        renderSorting.setOverrideRenderLivingAtInferiors(inferiors);
        RenderPlayerAPI.register((String)NAME, SMRenderPlayerBase.class, (RenderPlayerBaseSorting)renderSorting);
        ModelPlayerBaseSorting modelSorting = new ModelPlayerBaseSorting();
        modelSorting.setAfterLocalConstructingInferiors(inferiors);
        ModelPlayerAPI.register((String)NAME, SMModelPlayerBase.class, (ModelPlayerBaseSorting)modelSorting);
    }

    private void checkForMods() {
        List modList = Loader.instance().getActiveModList();
        boolean hasRedPowerWiring = false;
        boolean hasBuildCraftTransport = false;
        boolean hasFiniteLiquid = false;
        boolean hasBetterThanWolves = false;
        boolean hasSinglePlayerCommands = false;
        boolean hasRopesPlus = false;
        boolean hasASGrapplingHook = false;
        boolean hasBetterMisc = false;
        for (int i = 0; i < modList.size(); ++i) {
            ModContainer mod = (ModContainer)modList.get(i);
            String name = mod.getName();
            if (name.contains("RedPowerWiring")) {
                hasRedPowerWiring = true;
                continue;
            }
            if (name.contains("BuildCraftTransport")) {
                hasBuildCraftTransport = true;
                continue;
            }
            if (name.contains("Liquid")) {
                hasFiniteLiquid = true;
                continue;
            }
            if (name.contains("FCBetterThanWolves")) {
                hasBetterThanWolves = true;
                continue;
            }
            if (name.contains("SinglePlayerCommands")) {
                hasSinglePlayerCommands = true;
                continue;
            }
            if (name.contains("ASGrapplingHook")) {
                hasASGrapplingHook = true;
                continue;
            }
            if (!name.contains("BetterMisc")) continue;
            hasBetterMisc = true;
        }
        hasRopesPlus = Reflect.CheckClasses(SMMod.class, (Name[])new Name[]{SMInstall.RopesPlusCore});
        SMOptions.initialize(hasRedPowerWiring, hasBuildCraftTransport, hasFiniteLiquid, hasBetterThanWolves, hasSinglePlayerCommands, hasRopesPlus, hasASGrapplingHook, hasBetterMisc);
    }
}

