/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import api.player.server.IServerPlayerAPI;
import java.io.File;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.SMInfo;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.config.SMConfig;
import net.smart.moving.config.SMServerOptions;
import net.smart.properties.Property;

public class SMServer {
    public static SMConfig Options = null;
    private static SMServerOptions optionsHandler = null;
    public static final float SmallSizeItemGrabHeight = 0.25f;
    protected final IEntityPlayerMP mp;
    private boolean resetFallDistance = false;
    private boolean resetTicksForFloatKick = false;
    private boolean initialized = false;
    public boolean crawlingInitialized;
    public int crawlingCooldown;
    public boolean isCrawling;
    public boolean isSmall;
    private boolean isSneakButtonPressed;

    public SMServer(IEntityPlayerMP mp, boolean onTheFly) {
        this.mp = mp;
        if (onTheFly) {
            this.initialize(true);
        }
    }

    public void initialize(boolean alwaysSendMessage) {
        if (((Boolean)SMServer.Options._globalConfig.value).booleanValue()) {
            SMPacketHandler.sendConfigContent(this.mp, optionsHandler.writeToProperties(), null);
        } else if (((Boolean)SMServer.Options._serverConfig.value).booleanValue()) {
            SMPacketHandler.sendConfigContent(this.mp, optionsHandler.writeToProperties(this.mp, false), null);
        } else if (alwaysSendMessage) {
            SMPacketHandler.sendConfigContent(this.mp, SMServer.Options.enabled ? new String[]{} : null, null);
        }
        this.initialized = true;
    }

    public void processStatePacket(IMessage message, long state) {
        if (!this.initialized) {
            this.initialize(false);
        }
        boolean isCrawling = (state >>> 13 & 1L) != 0L;
        this.setCrawling(isCrawling);
        boolean isSmall = (state >>> 15 & 1L) != 0L;
        this.setSmall(isSmall);
        boolean isClimbing = (state >>> 14 & 1L) != 0L;
        boolean isCrawlClimbing = (state >>> 12 & 1L) != 0L;
        boolean isCeilingClimbing = (state >>> 18 & 1L) != 0L;
        boolean isWallJumping = (state >>> 31 & 1L) != 0L;
        this.isSneakButtonPressed = (state >>> 33 & 1L) != 0L;
        this.resetFallDistance = isClimbing || isCrawlClimbing || isCeilingClimbing || isWallJumping;
        this.resetTicksForFloatKick = isClimbing || isCrawlClimbing || isCeilingClimbing;
        SMPacketHandler.INSTANCE.sendToAllTracking(message, (Entity)this.mp.getEntityPlayerMP());
    }

    public void processConfigPacket(String clientConfigurationVersion) {
        boolean warn = true;
        String type = "unknown";
        if (clientConfigurationVersion != null) {
            for (int i = 0; i < SMConfig._all.length; ++i) {
                if (!clientConfigurationVersion.equals(SMConfig._all[i])) continue;
                warn = i > 0;
                type = warn ? "outdated" : "matching";
                break;
            }
        }
        String message = "Smart Moving player \"" + this.mp.getUsername() + "\" connected with " + type + " configuration system";
        if (clientConfigurationVersion != null) {
            message = message + " version \"" + clientConfigurationVersion + "\"";
        }
        if (warn) {
            FMLLog.warning((String)message, (Object[])new Object[0]);
        } else {
            FMLLog.info((String)message, (Object[])new Object[0]);
        }
    }

    public void processConfigChangePacket(String localUserName) {
        if (!((Boolean)SMServer.Options._globalConfig.value).booleanValue()) {
            this.toggleSingleConfig();
            return;
        }
        String username = this.mp.getUsername();
        if (localUserName == username) {
            this.toggleConfig();
            return;
        }
        String[] rightPlayerNames = (String[])SMServer.Options._usersWithChangeConfigRights.value;
        for (int i = 0; i < rightPlayerNames.length; ++i) {
            if (!rightPlayerNames[i].equals(username)) continue;
            this.toggleConfig();
            return;
        }
        SMPacketHandler.sendConfigChange(this.mp);
    }

    public void processSpeedChangePacket(int difference, String localUserName) {
        if (!((Boolean)SMServer.Options._globalConfig.value).booleanValue()) {
            this.changeSingleSpeed(difference);
            return;
        }
        if (!this.hasRight(localUserName, SMServer.Options._usersWithChangeSpeedRights)) {
            SMPacketHandler.sendSpeedChange(this.mp, 0, null);
        } else {
            this.changeSpeed(difference);
        }
    }

    public void processHungerChangePacket(float hunger) {
        this.mp.localAddExhaustion(hunger);
    }

    public void processSoundPacket(String soundId, float volume, float pitch) {
        this.mp.localPlaySound(soundId, volume, pitch);
    }

    private boolean hasRight(String localUserName, Property<String[]> rights) {
        String username = this.mp.getUsername();
        if (localUserName == username) {
            return true;
        }
        String[] rightPlayerNames = (String[])rights.value;
        for (int i = 0; i < rightPlayerNames.length; ++i) {
            if (!rightPlayerNames[i].equals(username)) continue;
            return true;
        }
        return false;
    }

    public void toggleSingleConfig() {
        SMPacketHandler.sendConfigContent(this.mp, optionsHandler.writeToProperties(this.mp, true), this.mp.getUsername());
    }

    public IEntityPlayerMP[] getAllPlayers() {
        List playerEntityList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        IEntityPlayerMP[] result = new IEntityPlayerMP[playerEntityList.size()];
        for (int i = 0; i < playerEntityList.size(); ++i) {
            result[i] = (IEntityPlayerMP)((IServerPlayerAPI)playerEntityList.get(i)).getServerPlayerBase(SMInfo.ModName);
        }
        return result;
    }

    public void toggleConfig() {
        optionsHandler.toggle(this.mp);
        String[] config = optionsHandler.writeToProperties();
        IEntityPlayerMP[] players = this.getAllPlayers();
        for (int n = 0; n < players.length; ++n) {
            SMPacketHandler.sendConfigContent(players[n], config, this.mp.getUsername());
        }
    }

    public void changeSingleSpeed(int difference) {
        optionsHandler.changeSingleSpeed(this.mp, difference);
        SMPacketHandler.sendSpeedChange(this.mp, difference, this.mp.getUsername());
    }

    public void changeSpeed(int difference) {
        optionsHandler.changeSpeed(difference, this.mp);
        IEntityPlayerMP[] players = this.getAllPlayers();
        for (int n = 0; n < players.length; ++n) {
            SMPacketHandler.sendSpeedChange(players[n], difference, this.mp.getUsername());
        }
    }

    public void afterOnUpdate() {
        if (this.resetFallDistance) {
            this.mp.resetFallDistance();
        }
        if (this.resetTicksForFloatKick) {
            this.mp.resetTicksForFloatKick();
        }
    }

    public static void initialize(File optionsPath, int gameType, SMConfig config) {
        Options = config;
        optionsHandler = new SMServerOptions(Options, optionsPath, gameType);
    }

    public void setCrawling(boolean crawling) {
        if (!crawling && this.isCrawling) {
            this.crawlingCooldown = 10;
        }
        this.isCrawling = crawling;
    }

    public void setSmall(boolean isSmall) {
        this.mp.setHeight(isSmall ? 0.8f : 1.8f);
        this.isSmall = isSmall;
    }

    public void afterSetPosition(double d, double d1, double d2) {
        if (!this.crawlingInitialized) {
            this.mp.setMaxY(this.mp.getMinY() + (double)this.mp.getHeight() - 1.0);
        }
    }

    public void beforeIsPlayerSleeping() {
        if (!this.crawlingInitialized) {
            this.mp.setMaxY(this.mp.getMinY() + (double)this.mp.getHeight());
            this.crawlingInitialized = true;
        }
    }

    public void beforeOnUpdate() {
        if (this.crawlingCooldown > 0) {
            --this.crawlingCooldown;
        }
    }

    public void afterOnLivingUpdate() {
        if (!this.isSmall) {
            return;
        }
        if (this.mp.doGetHealth() <= 0.0f) {
            return;
        }
        double offset = 0.25;
        AxisAlignedBB box = this.mp.expandBox(this.mp.getBox(), 1.0, offset, 1.0);
        List<?> offsetEntities = this.mp.getEntitiesExcludingPlayer(box);
        if (offsetEntities != null && offsetEntities.size() > 0) {
            Object[] offsetEntityArray = offsetEntities.toArray();
            box = this.mp.expandBox(box, 0.0, -offset, 0.0);
            List<?> standardEntities = this.mp.getEntitiesExcludingPlayer(box);
            for (int i = 0; i < offsetEntityArray.length; ++i) {
                Entity offsetEntity = (Entity)offsetEntityArray[i];
                if (standardEntities != null && standardEntities.contains(offsetEntity) || this.mp.isDeadEntity(offsetEntity)) continue;
                this.mp.onCollideWithPlayer(offsetEntity);
            }
        }
    }

    public boolean isEntityInsideOpaqueBlock() {
        if (this.crawlingCooldown > 0) {
            return false;
        }
        return this.mp.localIsEntityInsideOpaqueBlock();
    }

    public void addMovementStat(double var1, double var3, double var5) {
        this.mp.localAddMovementStat(var1, var3, var5);
    }

    public void addExhaustion(float exhaustion) {
        this.mp.localAddExhaustion(exhaustion);
    }

    public boolean isSneaking() {
        return this.mp.getItemInUseCount() > 0 || this.mp.localIsSneaking();
    }
}

