/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.config;

import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.smart.moving.SMContext;
import net.smart.moving.SMInfo;
import net.smart.moving.SMInstall;
import net.smart.moving.config.SMClientConfig;
import net.smart.moving.config.SMConfig;
import net.smart.properties.Property;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;

public class SMOptions
extends SMClientConfig {
    private static final int DefaultChatId = 0;
    private static final int ConfigChatId = SMInfo.ModName.hashCode();
    private static final int SpeedChatId = SMInfo.ModName.hashCode() + 1;
    public static boolean hasRedPowerWire = false;
    public static boolean hasBuildCraftTransportation = false;
    public static boolean hasFiniteLiquid = false;
    public static boolean hasBetterThanWolves = false;
    public static boolean hasSinglePlayerCommands = false;
    public static boolean hasRopesPlus = false;
    public static boolean hasASGrapplingHook = false;
    public static boolean hasBetterMisc = false;
    public int gameType;
    private static Field _currentGameType = Reflect.GetField(PlayerControllerMP.class, (Name)SMInstall.PlayerControllerMP_currentGameType);
    public final Property<Boolean> _localUserHasChangeConfigRight = SMOptions.Unmodified("move.global.config.right.local.user", new String[0]).comment("Whether the current local user has the right to change the global configuration in-game (despite of the names listed in \"move.global.config.right.user.names\"").section(new String[0]);
    public final Property<Boolean> _localUserHasChangeSpeedRight = SMOptions.Unmodified("move.global.speed.right.local.user", new String[0]).comment("Whether the current local user has the right to change the global speed in-game (despite of the names listed in \"move.global.config.right.user.names\"");
    public final Property<Float> _perspectiveFadeFactor = SMOptions.PositiveFactor("move.perspective.fade.factor", new String[0]).values(java.lang.Float.valueOf(0.5f), java.lang.Float.valueOf(0.1f), java.lang.Float.valueOf(1.0f)).comment("Fading speed factor between the different perspectives (>= 0.1, <= 1, set to '1' to switch off)").book("Viewpoint perspective", "Below you find the options to manipulate the viewpoint perspective");
    public final Property<Float> _perspectiveRunFactor = SMOptions.Float("move.perspective.run.factor", new String[0]).key("move.run.perspective.factor", _pre_sm_2_1).defaults(java.lang.Float.valueOf(1.0f), new String[0]).comment("Standard sprinting perspective (set to '0' to switch off)");
    public final Property<Float> _perspectiveSprintFactor = SMOptions.Float("move.perspective.sprint.factor", new String[0]).key("move.sprint.perspective.factor", _pre_sm_2_1).defaults(java.lang.Float.valueOf(1.5f), new String[0]).comment("Smart on ground sprinting perspective (set to '0' to switch off)");
    public final Property<Float> _angleJumpDoubleClickTicks = SMOptions.Positive("move.jump.angle.double.click.ticks", new String[0]).singular().up(java.lang.Float.valueOf(3.0f), java.lang.Float.valueOf(2.0f)).comment("The maximum number of ticks between two clicks to trigger a side or back jump (>= 2)").book("User interface", "Below you find the options to manipulate Smart Moving's user interface");
    public final Property<Boolean> _wallJumpDoubleClick = SMOptions.Unmodified("move.jump.wall.double.click", new String[0]).singular().comment("Whether wall jumping should be triggered by single or double clicking (and then press and holding) the jump button").section(new String[0]);
    public final Property<Float> _wallJumpDoubleClickTicks = SMOptions.Positive("move.jump.wall.double.click.ticks", new String[0]).singular().up(java.lang.Float.valueOf(3.0f), java.lang.Float.valueOf(2.0f)).comment("The maximum number of ticks between two clicks to trigger a wall jump (>= 2, depends on \"move.jump.wall.double.click\")");
    public final Property<Boolean> _climbJumpBackHeadOnGrab = SMOptions.Unmodified("move.jump.climb.back.head.on.grab", new String[0]).singular().comment("Whether pressing or not pressing the grab button while climb jumping back results in a head jump").section(new String[0]);
    public final Property<Boolean> _displayExhaustionBar = SMOptions.Unmodified("move.gui.exhaustion.bar", new String[0]).singular().comment("Whether to display the exhaustion bar in the game overlay").section(new String[0]);
    public final Property<Boolean> _displayJumpChargeBar = SMOptions.Unmodified("move.gui.jump.charge.bar", new String[0]).singular().comment("Whether to display the jump charge bar in the game overlay");
    public final Property<Boolean> _sneakToggle = SMOptions.Modified("move.sneak.toggle", new String[0]).comment("To switch on/off sneak toggling").section(new String[0]);
    public final Property<Boolean> _crawlToggle = SMOptions.Modified("move.crawl.toggle", new String[0]).comment("To switch on/off crawl toggling");
    public final Property<Boolean> _flyCloseToGround = SMOptions.Modified("move.fly.ground.close", new String[0]).comment("To switch on/off flying close to the ground").section(new String[0]);
    public final Property<Boolean> _flyWhileOnGround = SMOptions.Modified("move.fly.ground.collide", new String[0]).depends(this._flyCloseToGround).comment("To switch on/off flying while colliding with the grond (Relevant only if \"move.fly.ground.close\" is true)");
    public final Property<Boolean> _flyControlVertical = SMOptions.Unmodified("move.fly.control.vertical", new String[0]).comment("Whether flying control also depends on where the player looks vertically.").section(new String[0]);
    public final Property<Boolean> _diveControlVertical = SMOptions.Unmodified("move.dive.control.vertical", new String[0]).comment("Whether diving control also depends on where the player looks vertically.");
    private final Property<Integer> _old_toggleKeyCode = SMOptions.Integer("move.toggle.key", _pre_sm_1_7).singular().defaults(67, new String[0]);
    private final Property<String> _defaultConfigToggleKeyName = SMOptions.String("move.config.toggle.default.key.name", new String[0]).key("move.toggle.key.name", _pre_sm_3_2).singular().defaults("F9", new String[0]).source(this._old_toggleKeyCode.toKeyName(), _pre_sm_1_7).singular().comment("Key name to toggle Smart Moving features in-game (default: \"F9\")").section(new String[0]);
    private final Property<String> _defaultGrabKeyName = SMOptions.String("move.grab.default.key.name", new String[0]).singular().defaults("LCONTROL", new String[0]).singular().comment("Default key name to \"grab\" (default: \"LCONTROL\")");
    private final Property<String> _speedIncreaseKeyName = SMOptions.String("move.speed.increase.default.key.name", new String[0]).key("move.speed.increase.key.name", _pre_sm_3_2).singular().defaults("O", new String[0]).singular().comment("Key name to increase the moving speed ingame (default: \"O\")");
    private final Property<String> _speedDecreaseKeyName = SMOptions.String("move.speed.decrease.default.key.name", new String[0]).key("move.speed.decrease.key.name", _pre_sm_3_2).singular().defaults("I", new String[0]).singular().comment("Key name to decrease the moving speed ingame (default: \"I\")");
    public final Property<Integer> _defaultConfigToggleKeyCode = this._defaultConfigToggleKeyName.toKeyCode(67);
    public final Property<Integer> _defaultGrabKeyCode = this._defaultGrabKeyName.toKeyCode(29);
    public final Property<Integer> _defaultSpeedIncreaseKeyCode = this._speedIncreaseKeyName.toKeyCode(24);
    public final Property<Integer> _defaultSpeedDecreaseKeyCode = this._speedDecreaseKeyName.toKeyCode(23);
    public final Property<Boolean> _configChat = SMOptions.Unmodified("move.config.chat", new String[0]).singular().comment("To switch on/off option status messages via chat system").book("Message Management", "Below you find the options to define in which case Smart Moving should write messages about its current behavior to the ingame chat");
    public final Property<Boolean> _configChatInit = SMOptions.Unmodified("move.config.chat.init", new String[0]).depends(this._configChat).singular().comment("To switch on/off the initial option status message when starting a game (Relevant only if \"move.config.chat\" is not false)");
    public final Property<Boolean> _configChatInitHelp = SMOptions.Unmodified("move.config.chat.init.help", new String[0]).depends(this._configChatInit).singular().comment("To switch on/off the initial option help message (Relevant only if \"move.config.chat.init\" is not false and no improved keybinding GUI (Minecraft Forge or the Macros/Keybind mod) is installed)");
    public final Property<Boolean> _configChatServer = SMOptions.Unmodified("move.config.chat.server", new String[0]).depends(this._configChat).singular().comment("To switch on/off the server config overridden status message when joining a multiplayer game (Relevant only if \"move.config.chat\" is not false)");
    public final Property<Boolean> _speedChat = SMOptions.Unmodified("move.speed.chat", new String[0]).singular().comment("To switch on/off speed messages via chat system").section(new String[0]);
    public final Property<Boolean> _speedChatInit = SMOptions.Unmodified("move.speed.chat.init", new String[0]).depends(this._speedChat).singular().comment("To switch on/off the intial speed message when starting a game (Relevant only if \"move.speed.chat\" is not false)");
    public final Property<Boolean> _speedChatInitHelp = SMOptions.Unmodified("move.speed.chat.init.help", new String[0]).depends(this._speedChatInit).singular().comment("To switch on/off the initial speed help message (Relevant only if \"move.speed.chat.init\" is not false and no improved keybinding GUI (Minecraft Forge or the Macros/Keybind mod) is installed))");
    public final Property<Boolean> _speedChatServer = SMOptions.Unmodified("move.config.chat.server", new String[0]).depends(this._speedChat).singular().comment("To switch on/off the server speed change message when joining a multiplayer game (Relevant only if \"move.speed.chat\" is not false)");
    public KeyBinding keyBindGrab;
    public KeyBinding keyBindConfigToggle;
    public KeyBinding keyBindSpeedIncrease;
    public KeyBinding keyBindSpeedDecrease;
    public static final File optionsPath = Minecraft.func_71410_x().field_71412_D;

    public SMOptions() {
        this.loadFromOptionsFile(optionsPath);
        this.saveToOptionsFile(optionsPath);
        this.keyBindGrab = new KeyBinding("key.climb", ((Integer)this._defaultGrabKeyCode.value).intValue(), "key.categories.gameplay");
        this.keyBindConfigToggle = new KeyBinding("key.config.toggle", ((Integer)this._defaultConfigToggleKeyCode.value).intValue(), "key.categories.smartmoving");
        this.keyBindSpeedIncrease = new KeyBinding("key.speed.increase", ((Integer)this._defaultSpeedIncreaseKeyCode.value).intValue(), "key.categories.smartmoving");
        this.keyBindSpeedDecrease = new KeyBinding("key.speed.decrease", ((Integer)this._defaultSpeedDecreaseKeyCode.value).intValue(), "key.categories.smartmoving");
    }

    public boolean isSneakToggleEnabled() {
        return (Boolean)this._sneakToggle.value != false && this.enabled;
    }

    public boolean isCrawlToggleEnabled() {
        return (Boolean)this._crawlToggle.value != false && this.enabled;
    }

    public int angleJumpDoubleClickTicks() {
        return (int)Math.ceil(((Float)this._angleJumpDoubleClickTicks.value).floatValue());
    }

    public int wallJumpDoubleClickTicks() {
        return (int)Math.ceil(((Float)this._wallJumpDoubleClickTicks.value).floatValue());
    }

    @Override
    public void toggle() {
        super.toggle();
        if (((Boolean)this._configChat.value).booleanValue()) {
            this.writeClientConfigMessageToChat(false);
        }
        Property defaultKey = null;
        switch (this.gameType) {
            default: {
                defaultKey = this._survivalDefaultConfigKey;
                break;
            }
            case 1: {
                defaultKey = this._creativeDefaultConfigKey;
                break;
            }
            case 2: {
                defaultKey = this._adventureDefaultConfigKey;
            }
        }
        if (defaultKey != null) {
            String currentKey = this.getCurrentKey();
            defaultKey.setValue(currentKey);
            this.saveToOptionsFile(optionsPath);
        }
    }

    @Override
    public void changeSpeed(int difference) {
        super.changeSpeed(difference);
        this.writeClientSpeedMessageToChat(false);
        this.saveToOptionsFile(optionsPath);
    }

    private void writeClientConfigMessageToChat(boolean everyone) {
        String prefix = SMOptions.getClientEveryonePrefix("move.config.chat.client", everyone);
        if (SMContext.Config.enabled) {
            boolean unnamed;
            String name = (String)SMContext.Config._configKeyName.value;
            if (name.isEmpty()) {
                name = null;
            }
            boolean bl = unnamed = name == null;
            if (unnamed) {
                name = this.getCurrentKey();
            }
            if (name == "enabled" || unnamed && this.getKeyCount() == 1) {
                SMOptions.writeToChat(prefix + "enabled", ConfigChatId, new Object[0]);
            } else {
                SMOptions.writeToChat(prefix + (unnamed ? "unnamed" : "named"), ConfigChatId, name);
            }
        } else {
            SMOptions.writeToChat(prefix + "disabled", ConfigChatId, new Object[0]);
        }
    }

    public void writeClientSpeedMessageToChat(boolean everyone) {
        if (!((Boolean)this._speedChat.value).booleanValue()) {
            return;
        }
        Object percent = SMContext.Config.getSpeedPercent();
        String prefix = SMOptions.getClientEveryonePrefix("move.speed.chat.client", everyone);
        String key = prefix + (percent.equals(SMConfig.defaultSpeedPercent) ? "reset" : "change");
        SMOptions.writeToChat(key, SpeedChatId, percent);
    }

    private static String getClientEveryonePrefix(String base, boolean everyone) {
        String result = base + ".";
        if (everyone) {
            result = result + "everyone.";
        }
        return result;
    }

    public void writeServerConfigMessageToChat() {
        if (!((Boolean)this._configChatServer.value).booleanValue()) {
            return;
        }
        if (SMContext.Config.enabled) {
            String configName = (String)SMContext.Config._configKeyName.value;
            if (configName != null && !configName.isEmpty()) {
                SMOptions.writeToChat("move.config.chat.server.global.named", 0, configName);
            } else {
                SMOptions.writeToChat("move.config.chat.server.global.unnamed", 0, new Object[0]);
            }
        } else {
            SMOptions.writeToChat("move.config.chat.server.disable", 0, new Object[0]);
        }
    }

    public void writeServerReconfigMessageToChat(boolean wasEnabled, String username, boolean everyone) {
        if (Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName().equals(username)) {
            this.writeClientConfigMessageToChat(everyone);
        } else if (((Boolean)this._configChatServer.value).booleanValue()) {
            if (SMContext.Config.enabled) {
                boolean hasConfigName;
                String configname = (String)SMContext.Config._configKeyName.value;
                boolean bl = hasConfigName = configname != null && !configname.isEmpty();
                if (wasEnabled) {
                    if (hasConfigName) {
                        if (username != null) {
                            SMOptions.writeToChat("move.config.chat.server.update.named.user", ConfigChatId, configname, username);
                        } else {
                            SMOptions.writeToChat("move.config.chat.server.update.named", ConfigChatId, configname);
                        }
                    } else if (username != null) {
                        SMOptions.writeToChat("move.config.chat.server.update.unnamed.user", ConfigChatId, username);
                    } else {
                        SMOptions.writeToChat("move.config.chat.server.update.unnamed", ConfigChatId, new Object[0]);
                    }
                } else if (hasConfigName) {
                    if (username != null) {
                        SMOptions.writeToChat("move.config.chat.server.update.named.user", ConfigChatId, configname, username);
                    } else {
                        SMOptions.writeToChat("move.config.chat.server.update.named", ConfigChatId, configname);
                    }
                } else if (username != null) {
                    SMOptions.writeToChat("move.config.chat.server.enable.user", ConfigChatId, username);
                } else {
                    SMOptions.writeToChat("move.config.chat.server.enable", ConfigChatId, new Object[0]);
                }
            } else if (wasEnabled) {
                if (username != null) {
                    SMOptions.writeToChat("move.config.chat.server.disable.user", ConfigChatId, username);
                } else {
                    SMOptions.writeToChat("move.config.chat.server.disable", ConfigChatId, new Object[0]);
                }
            }
        }
    }

    public void writeServerDeconfigMessageToChat() {
        if (((Boolean)this._configChatServer.value).booleanValue()) {
            SMOptions.writeToChat("move.config.chat.server.local", 0, new Object[0]);
        }
    }

    public void writeServerSpeedMessageToChat(String username, boolean everyone) {
        if (Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName().equals(username)) {
            this.writeClientSpeedMessageToChat(everyone);
        } else if (((Boolean)this._speedChatServer.value).booleanValue()) {
            Object percent = SMContext.Config.getSpeedPercent();
            String prefix = "move.speed.chat.server.";
            if (percent.equals(SMConfig.defaultSpeedPercent)) {
                SMOptions.writeToChat(prefix + "reset", SpeedChatId, username);
            } else {
                SMOptions.writeToChat(prefix + "change", SpeedChatId, percent, username);
            }
        }
    }

    public static void writeNoRightsToChangeConfigMessageToChat(boolean isRemote) {
        SMOptions.writeToChat("move.config.chat.server.illegal." + (isRemote ? "remote" : "local"), ConfigChatId, new Object[0]);
    }

    public static void writeNoRightsToChangeSpeedMessageToChat(boolean isRemote) {
        SMOptions.writeToChat("move.speed.chat.server.illegal." + (isRemote ? "remote" : "local"), SpeedChatId, new Object[0]);
    }

    private static void writeToChat(String key, int id, Object ... parameters) {
        String message = parameters == null || parameters.length == 0 ? I18n.func_135052_a((String)key, (Object[])new Object[0]) : I18n.func_135052_a((String)key, (Object[])parameters);
        GuiNewChat guiChat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        if (id != 0) {
            for (int i = 0; i < 5; ++i) {
                guiChat.func_146242_c(id);
            }
        }
        guiChat.func_146234_a((ITextComponent)new TextComponentString(message), id);
    }

    public static void initialize(boolean redPowerWiring, boolean buildCraftTransportation, boolean finiteLiquid, boolean betterThanWolves, boolean singlePlayerCommands, boolean ropesPlus, boolean aSGrapplingHook, boolean betterMisc) {
        hasRedPowerWire = redPowerWiring;
        hasBuildCraftTransportation = buildCraftTransportation;
        hasFiniteLiquid = finiteLiquid;
        hasBetterThanWolves = betterThanWolves;
        hasSinglePlayerCommands = singlePlayerCommands;
        hasRopesPlus = ropesPlus;
        hasASGrapplingHook = aSGrapplingHook;
        hasBetterMisc = betterMisc;
    }

    public void resetForNewGame() {
        this.gameType = -1;
    }

    public void initializeForGameIfNeccessary() {
        Object speedPercent;
        PlayerControllerMP controller = Minecraft.func_71410_x().field_71442_b;
        if (controller == null) {
            return;
        }
        int currentGameType = ((GameType)Reflect.GetField((Field)_currentGameType, (Object)controller)).func_77148_a();
        if (currentGameType == this.gameType) {
            return;
        }
        this.gameType = currentGameType;
        String[] keys = null;
        String defaultKey = null;
        switch (this.gameType) {
            case 0: {
                keys = (String[])this._survivalConfigKeys.value;
                defaultKey = (String)this._survivalDefaultConfigKey.value;
                break;
            }
            case 1: {
                keys = (String[])this._creativeConfigKeys.value;
                defaultKey = (String)this._creativeDefaultConfigKey.value;
                break;
            }
            case 2: {
                keys = (String[])this._adventureConfigKeys.value;
                defaultKey = (String)this._adventureDefaultConfigKey.value;
                break;
            }
            default: {
                defaultKey = "";
            }
        }
        this.setKeys(keys);
        if (!defaultKey.isEmpty()) {
            this.setCurrentKey(defaultKey);
        }
        if (((Boolean)this._configChatInit.value).booleanValue()) {
            this.writeClientConfigMessageToChat(false);
        }
        if (this.isUserSpeedEnabled() && ((Boolean)this._speedChatInit.value).booleanValue() && !(speedPercent = this.getSpeedPercent()).equals(defaultSpeedPercent)) {
            SMOptions.writeToChat("move.speed.chat.client.init", 0, speedPercent);
        }
    }
}

