/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.config;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.config.SMConfig;
import net.smart.properties.Properties;
import net.smart.properties.Property;

public class SMServerOptions {
    public final SMConfig config;
    public final File optionsPath;
    private final Property<Map<String, String>> _userConfigKeys;

    public SMServerOptions(SMConfig config, File optionsPath, int gameType) {
        this.config = config;
        this.optionsPath = optionsPath;
        config.loadFromOptionsFile(optionsPath);
        config.saveToOptionsFile(optionsPath);
        Property<String> configKey = null;
        Property<String[]> configKeys = null;
        switch (gameType) {
            default: {
                configKey = config._survivalDefaultConfigKey;
                configKeys = config._survivalConfigKeys;
                this._userConfigKeys = config._survivalDefaultConfigUserKeys;
                break;
            }
            case 1: {
                configKey = config._creativeDefaultConfigKey;
                configKeys = config._creativeConfigKeys;
                this._userConfigKeys = config._creativeDefaultConfigUserKeys;
                break;
            }
            case 2: {
                configKey = config._adventureDefaultConfigKey;
                configKeys = config._adventureConfigKeys;
                this._userConfigKeys = config._adventureDefaultConfigUserKeys;
            }
        }
        config.setKeys((String[])configKeys.value);
        config.setCurrentKey(configKey != null && !((String)configKey.value).isEmpty() ? (String)configKey.value : null);
        SMServerOptions.logConfigState(config, null, false);
    }

    public void toggle(IEntityPlayerMP player) {
        this.config.toggle();
        this.config.saveToOptionsFile(this.optionsPath);
        SMServerOptions.logConfigState(this.config, player.getUsername(), true);
    }

    public void changeSpeed(int difference, IEntityPlayerMP player) {
        this.config.changeSpeed(difference);
        this.config.saveToOptionsFile(this.optionsPath);
        SMServerOptions.logSpeedState(this.config, player.getUsername());
    }

    private static void logConfigState(SMConfig config, String username, boolean reconfig) {
        String message = "Smart Moving ";
        if (((Boolean)config._globalConfig.value).booleanValue()) {
            if (!reconfig) {
                FMLLog.info((String)(message + "overrides client configurations"), (Object[])new Object[0]);
            }
            String postfix = SMServerOptions.getPostfix(username);
            if (config.enabled) {
                String currentKey = config.getCurrentKey();
                message = message + (reconfig ? "changed to " : "uses ");
                if (currentKey == null) {
                    FMLLog.info((String)(message + "default server configuration" + postfix), (Object[])new Object[0]);
                } else {
                    String configName = (String)config._configKeyName.value;
                    message = message + "server configuration ";
                    if (configName.isEmpty()) {
                        FMLLog.info((String)(message + "with key \"" + currentKey + "\"" + postfix), (Object[])new Object[0]);
                    } else {
                        FMLLog.info((String)(message + "\"" + configName + "\"" + postfix), (Object[])new Object[0]);
                    }
                }
            } else {
                FMLLog.info((String)(message + "disabled" + postfix), (Object[])new Object[0]);
            }
        } else {
            FMLLog.info((String)(message + "allows client configurations"), (Object[])new Object[0]);
        }
    }

    private static void logSpeedState(SMConfig config, String username) {
        FMLLog.info((String)("Smart Moving speed set to " + config.getSpeedPercent() + "%" + SMServerOptions.getPostfix(username)), (Object[])new Object[0]);
    }

    private static String getPostfix(String username) {
        if (username == null) {
            return "";
        }
        return " by user '" + username + "'";
    }

    public String[] writeToProperties() {
        return this.writeToProperties(null, null);
    }

    public String[] writeToProperties(IEntityPlayerMP mp, String key) {
        if (key == null ? !this.config.enabled : key == "disabled") {
            return new String[]{this.config._globalConfig.getCurrentKey(), this.config._globalConfig.getValueString()};
        }
        Properties properties = new Properties();
        this.config.write(properties, key);
        String[] result = new String[properties.size() * 2];
        Iterator<Map.Entry<Object, Object>> keys = properties.entrySet().iterator();
        String speedUserExponentKey = mp != null ? this.config._speedUserExponent.getCurrentKey() : null;
        int i = 0;
        while (keys.hasNext()) {
            Integer userExponent;
            Map.Entry<Object, Object> entry = keys.next();
            int n = i++;
            String string = entry.getKey().toString();
            result[n] = string;
            String propertyKey = string;
            if (mp != null && propertyKey.equals(speedUserExponentKey) && (userExponent = (Integer)((Map)this.config._speedUsersExponents.value).get(mp.getUsername())) != null) {
                entry.setValue(this.config._speedUserExponent.getValueString(userExponent));
            }
            result[i++] = entry.getValue().toString();
        }
        return result;
    }

    public void changeSingleSpeed(IEntityPlayerMP player, int difference) {
        Integer exponent = this.getPlayerSpeedExponent(player);
        if (exponent == null) {
            exponent = (Integer)this.config._speedUserExponent.value;
        }
        exponent = exponent + difference;
        this.setPlayerSpeedExponent(player, exponent);
    }

    public Integer getPlayerSpeedExponent(IEntityPlayerMP player) {
        return (Integer)((Map)this.config._speedUsersExponents.value).get(player.getUsername());
    }

    public synchronized void setPlayerSpeedExponent(IEntityPlayerMP player, Integer exponent) {
        ((Map)this.config._speedUsersExponents.value).put(player.getUsername(), exponent);
        this.config.saveToOptionsFile(this.optionsPath);
    }

    public String[] writeToProperties(IEntityPlayerMP player, boolean toggle) {
        String key = this.getPlayerConfigurationKey(player);
        if (key == null || !this.config.hasKey(key)) {
            key = this.config.getCurrentKey();
            this.setPlayerConfigurationKey(player, key);
        }
        if (toggle) {
            key = this.config.getNextKey(key);
            this.setPlayerConfigurationKey(player, key);
        }
        return this.writeToProperties(player, key);
    }

    public String getPlayerConfigurationKey(IEntityPlayerMP player) {
        return (String)((Map)this._userConfigKeys.value).get(player.getUsername());
    }

    public synchronized void setPlayerConfigurationKey(IEntityPlayerMP player, String key) {
        ((Map)this._userConfigKeys.value).put(player.getUsername(), key);
        this.config.saveToOptionsFile(this.optionsPath);
    }
}

