/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.smart.moving.SMComm;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.SMServerComm;
import net.smart.moving.SMServerPlayerBase;

public class StatePacket
implements IMessage {
    public static final byte PacketId = 0;
    public int entityId;
    public long state;

    public StatePacket() {
    }

    public StatePacket(int entityId, long state) {
        this.entityId = entityId;
        this.state = state;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.state = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeLong(this.state);
    }

    public static class ServerHandler
    implements IMessageHandler<StatePacket, IMessage> {
        public IMessage onMessage(StatePacket message, MessageContext ctx) {
            SMServerPlayerBase serverPlayer = SMServerPlayerBase.getPlayerBase(ctx.getServerHandler().field_147369_b);
            SMPacketHandler.receivePacket(message, SMServerComm.instance, serverPlayer);
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<StatePacket, IMessage> {
        public IMessage onMessage(StatePacket message, MessageContext ctx) {
            SMPacketHandler.receivePacket(message, SMComm.instance, null);
            return null;
        }
    }
}

